/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCLog;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigUtil {
    public static void setLang(Configuration cfg) {
        for (String s : cfg.getCategoryNames()) {
            ConfigCategory cat;
            ConfigCategory p = cat = cfg.getCategory(s);
            while (p != null) {
                p.setLanguageKey("config." + p.getQualifiedName());
                p = p.parent;
            }
            for (Property prop : cat.values()) {
                prop.setLanguageKey(cat.getLanguagekey() + "." + prop.getName());
            }
        }
    }

    public static <E extends Enum<E>> void setEnumProperty(Property prop, E[] possible) {
        String[] validValues = new String[possible.length];
        for (int i = 0; i < possible.length; ++i) {
            validValues[i] = ((Enum)possible[i]).name().toLowerCase(Locale.ROOT);
        }
        prop.setValidValues(validValues);
    }

    public static <E extends Enum<E>> E parseEnumForConfig(Property prop, E defaultOption) {
        return (E)ConfigUtil.parseEnumForConfig((Property)prop, (Enum[])((Enum[])defaultOption.getDeclaringClass().getEnumConstants()), defaultOption);
    }

    public static <E extends Enum<E>> E parseEnumForConfig(Property prop, E[] possible, E defaultOption) {
        LinkedList match = new LinkedList();
        Collections.addAll(match, possible);
        LinkedList<char[]> lowerCaseNames = new LinkedList<char[]>();
        for (Enum val : match) {
            lowerCaseNames.add(val.name().toLowerCase(Locale.ROOT).toCharArray());
        }
        char[] chars = prop.getString().toLowerCase(Locale.ROOT).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            Iterator iter = match.iterator();
            Iterator iterNames = lowerCaseNames.iterator();
            while (iter.hasNext()) {
                iter.next();
                char[] name = (char[])iterNames.next();
                if (name.length >= i && name[i] == chars[i]) continue;
                iter.remove();
                iterNames.remove();
            }
            if (match.size() != 1) continue;
            return (E)ConfigUtil.getAssumingEqual((Property)prop, (Enum)((Enum)match.peek()), possible);
        }
        return (E)ConfigUtil.getAssumingEqual((Property)prop, defaultOption, possible);
    }

    private static <E extends Enum<E>> E getAssumingEqual(Property prop, E mode, E[] possible) {
        String value = prop.getString();
        if (!mode.name().equalsIgnoreCase(value)) {
            BCLog.logger.warn("[lib.config] Unknown " + mode.getClass().getSimpleName() + " for " + prop.getName() + " '" + value + "', assuming " + mode.name());
            BCLog.logger.warn("[lib.config] Possible values:");
            for (E e : possible) {
                BCLog.logger.info("[lib.config]  - '" + ((Enum)e).name().toLowerCase(Locale.ROOT));
            }
        }
        return mode;
    }
}

