/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.crafting.MobCharmRepairRecipe;
import xreliquary.crafting.factories.AlkahestryChargingRecipeFactory;
import xreliquary.crafting.factories.AlkahestryCraftingRecipeFactory;
import xreliquary.crafting.factories.AlkahestryDrainRecipeFactory;
import xreliquary.init.ModItems;
import xreliquary.items.ItemAlkahestryTome;

@Mod.EventBusSubscriber(modid="xreliquary")
public class XRRecipes {
    public static List<AlkahestryCraftingRecipeFactory.AlkahestryCraftingRecipe> craftingRecipes = Lists.newArrayList();
    public static List<AlkahestryChargingRecipeFactory.AlkahestryChargingRecipe> chargingRecipes = Lists.newArrayList();
    public static AlkahestryDrainRecipeFactory.AlkahestryDrainRecipe drainRecipe;
    public static ItemStack NEBULOUS_HEART;
    public static ItemStack CREEPER_GLAND;
    public static ItemStack SLIME_PEARL;
    public static ItemStack BAT_WING;
    public static ItemStack RIB_BONE;
    public static ItemStack WITHER_RIB;
    public static ItemStack STORM_EYE;
    public static ItemStack FERTILE_ESSENCE;
    public static ItemStack FROZEN_CORE;
    public static ItemStack MOLTEN_CORE;
    public static ItemStack ZOMBIE_HEART;
    public static ItemStack INFERNAL_CLAW;
    public static ItemStack SHELL_FRAGMENT;
    public static ItemStack SQUID_BEAK;
    public static ItemStack CHELICERAE;
    public static ItemStack GUARDIAN_SPIKE;
    private static ItemStack WITHER_SKULL;

    private static ItemStack ingredient(int m) {
        return new ItemStack((Item)ModItems.mobIngredient, 1, m);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<IRecipe> event) {
        XRRecipes.initConstants();
        XRRecipes.registerCustomRecipes();
        ItemStack tome = new ItemStack((Item)ModItems.alkahestryTome);
        ItemAlkahestryTome.setCharge(tome, 0);
        XRRecipes.addRecipe(tome, MOLTEN_CORE, new ItemStack((Item)ModItems.witchHat), STORM_EYE, CREEPER_GLAND, new ItemStack(Items.field_151122_aG), SLIME_PEARL, CHELICERAE, WITHER_SKULL, NEBULOUS_HEART);
    }

    private static void registerCustomRecipes() {
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MobCharmRepairRecipe());
    }

    private static void initConstants() {
        NEBULOUS_HEART = XRRecipes.ingredient(11);
        CREEPER_GLAND = XRRecipes.ingredient(3);
        SLIME_PEARL = XRRecipes.ingredient(4);
        BAT_WING = XRRecipes.ingredient(5);
        RIB_BONE = XRRecipes.ingredient(0);
        WITHER_RIB = XRRecipes.ingredient(1);
        STORM_EYE = XRRecipes.ingredient(8);
        FERTILE_ESSENCE = XRRecipes.ingredient(9);
        FROZEN_CORE = XRRecipes.ingredient(10);
        MOLTEN_CORE = XRRecipes.ingredient(7);
        ZOMBIE_HEART = XRRecipes.ingredient(6);
        INFERNAL_CLAW = XRRecipes.ingredient(13);
        SHELL_FRAGMENT = XRRecipes.ingredient(14);
        SQUID_BEAK = XRRecipes.ingredient(12);
        CHELICERAE = XRRecipes.ingredient(2);
        GUARDIAN_SPIKE = XRRecipes.ingredient(16);
        WITHER_SKULL = new ItemStack(Items.field_151144_bL, 1, 1);
    }

    private static void addRecipe(ItemStack result, ItemStack ... stacks) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (ItemStack stack : stacks) {
            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
        }
        ForgeRegistries.RECIPES.register(new ShapelessRecipes("Reliquary", result, ingredients).setRegistryName(result.func_77973_b().getRegistryName()));
    }
}

