/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPredicate {
    public static final BlockPredicate ANY = new BlockPredicate(ImmutableSet.of(), Blocks.field_150350_a, NBTPredicate.field_193479_a){

        @Override
        public boolean test(World world, BlockPos pos) {
            return true;
        }
    };
    private ImmutableSet<PropertyPredicate> propertyPredicates;
    private final Block block;
    private final NBTPredicate nbtPredicate;

    private BlockPredicate(ImmutableSet<PropertyPredicate> propertyPredicates, Block block, NBTPredicate nbt) {
        this.propertyPredicates = propertyPredicates;
        this.block = block;
        this.nbtPredicate = nbt;
    }

    public static BlockPredicate deserialize(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return ANY;
        }
        JsonObject json = element.getAsJsonObject();
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"block")));
        BlockStateContainer container = block.func_176194_O();
        HashSet properties = new HashSet();
        if (json.has("properties")) {
            for (JsonElement propertyRawGroup : JsonUtils.func_151214_t((JsonObject)json, (String)"properties")) {
                JsonObject propertyGroup = propertyRawGroup.getAsJsonObject();
                IProperty propertyKey = container.func_185920_a(JsonUtils.func_151200_h((JsonObject)propertyGroup, (String)"property"));
                if (propertyKey == null) continue;
                BlockPredicate.createPropertyPredicateAndAddToSet(properties, propertyKey, JsonUtils.func_151200_h((JsonObject)propertyGroup, (String)"value"), JsonUtils.func_151200_h((JsonObject)propertyGroup, (String)"comparator"));
            }
        }
        NBTPredicate nbtPredicate = json.has("nbt") ? NBTPredicate.func_193476_a((JsonElement)json.get("nbt")) : NBTPredicate.field_193479_a;
        return new BlockPredicate((ImmutableSet<PropertyPredicate>)new ImmutableSet.Builder().addAll(properties).build(), block, nbtPredicate);
    }

    private static <T extends Comparable<T>> void createPropertyPredicateAndAddToSet(HashSet<PropertyPredicate<?>> predicateSet, IProperty<T> key, String value, String comparisonType) {
        Optional schrodingersVar = key.func_185929_b(value);
        PropertyPredicate.ComparisonType predicateComparator = PropertyPredicate.ComparisonType.get(comparisonType);
        if (predicateComparator == null || !schrodingersVar.isPresent()) {
            return;
        }
        predicateSet.add(new PropertyPredicate(key, (Comparable)schrodingersVar.get(), predicateComparator, null));
    }

    public boolean test(World world, BlockPos pos) {
        if (!this.test(world.func_180495_p(pos))) {
            return false;
        }
        if (this.nbtPredicate == NBTPredicate.field_193479_a) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        return te != null && this.nbtPredicate.func_193477_a((NBTBase)te.serializeNBT());
    }

    private boolean test(IBlockState state) {
        if (this.block != state.func_177230_c()) {
            return false;
        }
        for (PropertyPredicate propertyPredicate : this.propertyPredicates) {
            if (propertyPredicate.test(state)) continue;
            return false;
        }
        return true;
    }

    private static class PropertyPredicate<T extends Comparable<T>> {
        private final IProperty<T> property;
        private final T value;
        private ComparisonType comparisonType;

        private PropertyPredicate(IProperty<T> key, T value, ComparisonType comparisonType) {
            this.property = key;
            this.value = value;
            this.comparisonType = comparisonType;
        }

        private boolean test(IBlockState state) {
            return state.func_177227_a().contains(this.property) && this.comparisonType.test(this.value, state.func_177229_b(this.property));
        }

        /* synthetic */ PropertyPredicate(IProperty x0, Comparable x1, ComparisonType x2, 1 x3) {
            this(x0, x1, x2);
        }

        private static enum ComparisonType {
            EQUAL{

                @Override
                <T extends Comparable<T>> boolean test(T k, T v) {
                    return k.compareTo(v) == 0;
                }
            }
            ,
            NOT{

                @Override
                <T extends Comparable<T>> boolean test(T k, T v) {
                    return k.compareTo(v) != 0;
                }
            }
            ,
            LESSER{

                @Override
                <T extends Comparable<T>> boolean test(T k, T v) {
                    return k.compareTo(v) < 0;
                }
            }
            ,
            GREATER{

                @Override
                <T extends Comparable<T>> boolean test(T k, T v) {
                    return k.compareTo(v) > 0;
                }
            };


            abstract <T extends Comparable<T>> boolean test(T var1, T var2);

            @Nullable
            private static ComparisonType get(String type) {
                switch (type) {
                    case "equal": 
                    case "same": {
                        return EQUAL;
                    }
                    case "not": 
                    case "different": 
                    case "equaln't": {
                        return NOT;
                    }
                    case "lesser": 
                    case "lesser_than": {
                        return LESSER;
                    }
                    case "greater": 
                    case "greater_than": {
                        return GREATER;
                    }
                }
                return null;
            }
        }
    }
}

