/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.handler;

import com.animania.Animania;
import com.animania.addons.AddonResourcePack;
import com.animania.api.addons.AnimaniaAddon;
import com.animania.api.addons.IAddonGuiHandler;
import com.animania.api.addons.LoadAddon;
import com.animania.common.helper.ReflectionUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.DependencyParser;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="animania")
public class AddonHandler {
    private static int guiHandlerCounter = 1000;
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<String, AnimaniaAddon> loadedAddons = new HashMap<String, AnimaniaAddon>();
    private static List<MissingModsException> missingModsExceptions = new ArrayList<MissingModsException>();
    private static Map<String, IAddonGuiHandler> addonGuiHandlers = new HashMap<String, IAddonGuiHandler>();
    private static Method loadFactories;
    private static Method loadConstants;
    private static Method loadBuildtInAdvancements;
    private static Method loadCustomAdvancements;
    private static Field advancementManager;
    private static Field ADVANCEMENT_LIST;
    private static Field hasErrored;

    public static void preInitCommon() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.preInitCommon();
        }
    }

    public static void initCommon() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.initCommon();
        }
    }

    public static void preInitClient() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.preInitClient();
        }
    }

    public static void initClient() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.initClient();
        }
    }

    public static void loadAddons(ASMDataTable table) {
        Set asmData = table.getAll(LoadAddon.class.getCanonicalName());
        asmData.forEach(asm -> {
            try {
                Class<AnimaniaAddon> clazz = Class.forName(asm.getClassName()).asSubclass(AnimaniaAddon.class);
                AnimaniaAddon a = clazz.newInstance();
                if (loadedAddons.containsKey(a.getAddonID())) {
                    throw new RuntimeException("The addon with the id " + a.getAddonID() + " is already installed!");
                }
                if (a.getAddonID().equals("template")) {
                    return;
                }
                loadedAddons.put(a.getAddonID(), a);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Animania.LOGGER.error((Object)e);
            }
        });
        loadedAddons.values().forEach(addon -> AddonHandler.register(addon));
    }

    public static void registerAddonGuiHandler(String addonId, IAddonGuiHandler handler) {
        handler.setGuiIdOffset(guiHandlerCounter);
        addonGuiHandlers.put(addonId, handler);
        guiHandlerCounter += 1000;
    }

    public static Object openAddonGui(EntityPlayer player, int guiId, World world, int x, int y, int z, Side side) {
        Object returnObject = null;
        for (IAddonGuiHandler handler : addonGuiHandlers.values()) {
            returnObject = side == Side.CLIENT ? handler.getClientGuiElement(guiId - handler.getGuiIdOffset(), player, world, x, y, z) : handler.getServerGuiElement(guiId - handler.getGuiIdOffset(), player, world, x, y, z);
            if (returnObject == null) continue;
            return returnObject;
        }
        return null;
    }

    public static void throwErrors() {
        if (!missingModsExceptions.isEmpty() && !Animania.IS_DEV) {
            MultipleModsErrored errors = new MultipleModsErrored(Collections.EMPTY_LIST, missingModsExceptions);
            Animania.proxy.throwCustomModLoadingErrorDisplayException(errors);
        }
    }

    public static boolean isAddonLoaded(String addonID) {
        return loadedAddons.get(addonID) != null;
    }

    private static void register(AnimaniaAddon addon) {
        if (addon == null) {
            return;
        }
        if (addon.getAddonID().equals("template")) {
            return;
        }
        Map loadedMods = Loader.instance().getIndexedModList();
        DependencyParser parser = new DependencyParser(addon.getAddonID(), Side.SERVER);
        DependencyParser.DependencyInfo info = parser.parseDependencies(addon.getDependencies());
        for (ArtifactVersion dependency : info.dependencies) {
            ArtifactVersion modVersion;
            String modid = dependency.getLabel();
            if (modid == null) {
                throw new RuntimeException("Modid Dependency for " + addon.getAddonID() + " cannot be null.");
            }
            ModContainer container = (ModContainer)loadedMods.get(modid);
            if (container == null) {
                if (AddonHandler.isAddonLoaded(modid)) {
                    AnimaniaAddon depAddon = loadedAddons.get(modid);
                    DefaultArtifactVersion addonVersion = new DefaultArtifactVersion(modid, depAddon.getVersion());
                    if (!dependency.containsVersion((ArtifactVersion)addonVersion)) {
                        MissingModsException ex = new MissingModsException(addon.getAddonID(), addon.getAddonName());
                        ex.addMissingMod(dependency, (ArtifactVersion)addonVersion, true);
                        ex.missingMods.add(dependency);
                        missingModsExceptions.add(ex);
                        continue;
                    }
                } else {
                    MissingModsException ex = new MissingModsException(addon.getAddonID(), addon.getAddonName());
                    ex.addMissingMod(dependency, null, true);
                    ex.missingMods.add(dependency);
                    missingModsExceptions.add(ex);
                    continue;
                }
            }
            if (dependency.containsVersion(modVersion = container.getProcessedVersion())) continue;
            MissingModsException ex = new MissingModsException(addon.getAddonID(), addon.getAddonName());
            ex.addMissingMod(dependency, modVersion, true);
            ex.missingMods.add(dependency);
            missingModsExceptions.add(ex);
        }
        AddonHandler.addAddonResourcePack(addon);
        Animania.LOGGER.info("Loaded Addon " + addon.getAddonName() + " with id " + addon.getAddonID() + " and Class " + addon.getClass().getName());
    }

    private static void addAddonResourcePack(AnimaniaAddon addon) {
        Animania.proxy.addAddonResourcePack(addon);
    }

    @SubscribeEvent
    public static void onRecipeRegistry(RegistryEvent.Register<IRecipe> event) {
        for (AnimaniaAddon addon : loadedAddons.values()) {
            AddonHandler.registerAddonFactories(addon);
            AddonHandler.loadAddonRecipes(addon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerAddonFactories(AnimaniaAddon addon) {
        ModContainer mod = Loader.instance().activeModContainer();
        boolean isJar = !mod.getSource().isDirectory();
        FileSystem fs = null;
        try {
            Tuple<FileSystem, Path> tuple = AddonResourcePack.getAddonPath(addon);
            Path fPath = (Path)tuple.func_76340_b();
            fs = (FileSystem)tuple.func_76341_a();
            JsonContext ctx = new JsonContext(mod.getModId());
            fPath = isJar ? fs.getPath("/assets/" + addon.getAddonID() + "/" + ctx.getModId() + "/recipes/_factories.json", new String[0]) : fPath.resolve(ctx.getModId() + "/recipes/_factories.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                    loadFactories.invoke(CraftingHelper.class, json, ctx, new CraftingHelper.FactoryLoader[]{CraftingHelper.RECIPES, CraftingHelper.INGREDIENTS, CraftingHelper.CONDITIONS});
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            IOUtils.closeQuietly((Closeable)fs);
        }
        catch (JsonParseException | IOException e) {
            FMLLog.log.error("Error loading _factories.json: ", e);
        }
        finally {
            IOUtils.closeQuietly(fs);
        }
    }

    private static void loadAddonRecipes(AnimaniaAddon addon) {
        ModContainer mod = Loader.instance().activeModContainer();
        JsonContext ctx = new JsonContext(mod.getModId());
        AddonHandler.findFiles(addon, mod, mod.getModId() + "/recipes", root -> {
            Path fPath = root.resolve("_constants.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject[].class);
                    loadConstants.invoke((Object)ctx, new Object[]{json});
                }
                catch (JsonParseException | IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    FMLLog.log.error("Error loading _constants.json: ", e);
                    return false;
                }
            }
            return true;
        }, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) return true;
            if (relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (JsonContext)ctx)) {
                    Boolean bl = true;
                    return bl;
                }
                IRecipe recipe = CraftingHelper.getRecipe((JsonObject)json, (JsonContext)ctx);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe.setRegistryName(key));
                return true;
            }
            catch (JsonParseException e) {
                FMLLog.log.error("Parsing error loading recipe {}", (Object)key, (Object)e);
                return false;
            }
            catch (IOException e) {
                FMLLog.log.error("Couldn't read recipe {} from {}", (Object)key, file, (Object)e);
                return false;
            }
        }, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean findFiles(AnimaniaAddon addon, ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor, boolean defaultUnfoundRoot, boolean visitAllFiles) {
        boolean success;
        block15: {
            boolean isJar = !mod.getSource().isDirectory();
            success = true;
            Tuple<FileSystem, Path> tuple = AddonResourcePack.getAddonPath(addon);
            try {
                Boolean cont;
                Path root = null;
                root = isJar ? ((FileSystem)tuple.func_76341_a()).getPath("/assets/" + addon.getAddonID() + "/" + base, new String[0]) : ((Path)tuple.func_76340_b()).resolve(base);
                if (root == null || !Files.exists(root, new LinkOption[0])) {
                    boolean bl = defaultUnfoundRoot;
                    return bl;
                }
                if (!(preprocessor == null || (cont = preprocessor.apply(root)) != null && cont.booleanValue())) {
                    boolean bl = false;
                    return bl;
                }
                if (processor == null) break block15;
                Iterator itr = null;
                try {
                    itr = Files.walk(root, new FileVisitOption[0]).iterator();
                }
                catch (IOException e) {
                    FMLLog.log.error("Error iterating filesystem for: {}", (Object)addon.getAddonID(), (Object)e);
                    boolean bl = false;
                    if (tuple.func_76341_a() != null) {
                        IOUtils.closeQuietly((Closeable)((Closeable)tuple.func_76341_a()));
                    }
                    return bl;
                }
                while (itr != null && itr.hasNext()) {
                    Boolean cont2 = processor.apply(root, (Path)itr.next());
                    if (visitAllFiles) {
                        success &= cont2 != null && cont2 != false;
                        continue;
                    }
                    if (cont2 != null && cont2.booleanValue()) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (tuple.func_76341_a() != null) {
                    IOUtils.closeQuietly((Closeable)((Closeable)tuple.func_76341_a()));
                }
            }
        }
        return success;
    }

    private static void loadAddonAdvancements(AnimaniaAddon addon, Map<ResourceLocation, Advancement.Builder> map) {
        ModContainer mod = Loader.instance().activeModContainer();
        JsonContext ctx = new JsonContext(mod.getModId());
        AddonHandler.findFiles(addon, mod, "animania/advancements", null, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(mod.getModId(), name);
            if (!map.containsKey(key)) {
                Boolean bl;
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(file);
                    String contents = IOUtils.toString((Reader)reader);
                    JsonObject json = (JsonObject)JsonUtils.func_188178_a((Gson)CraftingHelper.GSON, (String)contents, JsonObject.class);
                    if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (JsonContext)ctx)) {
                        Boolean bl2 = true;
                        return bl2;
                    }
                    Advancement.Builder builder = (Advancement.Builder)JsonUtils.func_188178_a((Gson)AdvancementManager.field_192783_b, (String)contents, Advancement.Builder.class);
                    map.put(key, builder);
                }
                catch (JsonParseException jsonparseexception) {
                    FMLLog.log.error("Parsing error loading built-in advancement " + key, (Throwable)jsonparseexception);
                    bl = false;
                    return bl;
                }
                catch (IOException ioexception) {
                    FMLLog.log.error("Couldn't read advancement " + key + " from " + file, (Throwable)ioexception);
                    bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, true, true);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            try {
                AdvancementManager manager = (AdvancementManager)advancementManager.get(world);
                AdvancementList list = (AdvancementList)ADVANCEMENT_LIST.get(manager);
                hasErrored.set(manager, false);
                list.func_192087_a();
                Map map = (Map)loadCustomAdvancements.invoke((Object)manager, new Object[0]);
                loadBuildtInAdvancements.invoke((Object)manager, map);
                boolean error = ForgeHooks.loadAdvancements((Map)map);
                if (error) {
                    hasErrored.set(manager, true);
                }
                for (AnimaniaAddon addon : loadedAddons.values()) {
                    if (addon.getAddonID().equals("template")) continue;
                    AddonHandler.loadAddonAdvancements(addon, map);
                }
                list.func_192083_a(map);
                for (Advancement advancement : list.func_192088_b()) {
                    if (advancement.func_192068_c() == null) continue;
                    AdvancementTreeNode.func_192323_a((Advancement)advancement);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            loadFactories = ReflectionUtil.findMethod(CraftingHelper.class, "loadFactories", null, JsonObject.class, JsonContext.class, CraftingHelper.FactoryLoader[].class);
            loadFactories.setAccessible(true);
            loadConstants = ReflectionUtil.findMethod(JsonContext.class, "loadConstants", null, JsonObject[].class);
            loadConstants.setAccessible(true);
            advancementManager = ReflectionUtil.findField(World.class, "field_191951_C", "advancementManager");
            advancementManager.setAccessible(true);
            hasErrored = ReflectionUtil.findField(AdvancementManager.class, "field_193768_e", "hasErrored");
            hasErrored.setAccessible(true);
            loadBuildtInAdvancements = ReflectionUtil.findMethod(AdvancementManager.class, "loadBuiltInAdvancements", "func_192777_a", Map.class);
            loadBuildtInAdvancements.setAccessible(true);
            loadCustomAdvancements = ReflectionUtil.findMethod(AdvancementManager.class, "loadCustomAdvancements", "func_192781_c", new Class[0]);
            loadCustomAdvancements.setAccessible(true);
            ADVANCEMENT_LIST = ReflectionUtil.findField(AdvancementManager.class, "field_192784_c", "ADVANCEMENT_LIST");
            ADVANCEMENT_LIST.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

