/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.world.loading;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="universaltweaks")
public class UTUnloader {
    public static int tickCount = 0;

    @SubscribeEvent
    public static void utUnloader(TickEvent.ServerTickEvent event) {
        Integer[] dims;
        if (!UTConfig.TWEAKS_WORLD.DIMENSION_UNLOAD.utUnloaderToggle || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCount < UTConfig.TWEAKS_WORLD.DIMENSION_UNLOAD.utUnloaderInterval) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTUnloader ::: Server tick event");
        }
        tickCount = 0;
        for (Integer id : dims = DimensionManager.getIDs()) {
            UTUnloader.utHandleDimUnload(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void utHandleDimUnload(Integer id) {
        WorldServer worldServer = DimensionManager.getWorld((int)id);
        ChunkProviderServer chunkProviderServer = worldServer.func_72863_F();
        DimensionType dimensionType = DimensionManager.getProviderType((int)id);
        String dimensionName = "";
        if (dimensionType != null) {
            dimensionName = dimensionType.func_186065_b();
        }
        for (String dimConfig : UTConfig.TWEAKS_WORLD.DIMENSION_UNLOAD.utUnloaderBlacklist) {
            if (!dimensionName.matches(dimConfig) && !Integer.toString(id).matches(dimConfig)) continue;
            return;
        }
        if (!worldServer.field_73011_w.func_186058_p().shouldLoadSpawn() && ForgeChunkManager.getPersistentChunksFor((World)worldServer).isEmpty() && chunkProviderServer.func_73152_e() == 0 && worldServer.field_73010_i.isEmpty() && worldServer.field_72996_f.isEmpty() && worldServer.field_147482_g.isEmpty()) {
            try {
                worldServer.func_73044_a(true, null);
                UniversalTweaks.LOGGER.info("Saved all chunks from dimension " + dimensionName);
            }
            catch (MinecraftException e) {
                UniversalTweaks.LOGGER.error("Caught an exception while saving all chunks:", (Throwable)e);
            }
            finally {
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)worldServer));
                worldServer.func_73041_k();
                DimensionManager.setWorld((int)id, null, (MinecraftServer)worldServer.func_73046_m());
                UniversalTweaks.LOGGER.info("Unloaded dimension " + dimensionName);
            }
        }
    }
}

