/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.smoothscrolling;

import java.util.function.Function;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.util.math.MathHelper;

public class UTSmoothScrolling {
    public static Function<Double, Double> easingMethod = v -> v;

    public static Function<Double, Double> getEasingMethod() {
        return easingMethod;
    }

    public static long getScrollDuration() {
        return UTConfig.TWEAKS_MISC.SMOOTH_SCROLLING.utSmoothScrollingDuration;
    }

    public static float getScrollStep() {
        return (float)UTConfig.TWEAKS_MISC.SMOOTH_SCROLLING.utSmoothScrollingStep;
    }

    public static float getBounceBackMultiplier() {
        return (float)UTConfig.TWEAKS_MISC.SMOOTH_SCROLLING.utSmoothScrollingBounce;
    }

    public static float handleScrollingPosition(float[] target, float scroll, float maxScroll, float delta, double start, double duration) {
        if (UTSmoothScrolling.getBounceBackMultiplier() >= 0.0f) {
            target[0] = UTSmoothScrolling.clamp(target[0], maxScroll);
            if (target[0] < 0.0f) {
                target[0] = target[0] - target[0] * (1.0f - UTSmoothScrolling.getBounceBackMultiplier()) * delta / 3.0f;
            } else if (target[0] > maxScroll) {
                target[0] = (target[0] - maxScroll) * (1.0f - (1.0f - UTSmoothScrolling.getBounceBackMultiplier()) * delta / 3.0f) + maxScroll;
            }
        } else {
            target[0] = UTSmoothScrolling.clamp(target[0], maxScroll, 0.0f);
        }
        if (!Precision.almostEquals(scroll, target[0], 0.001f)) {
            return UTSmoothScrolling.expoEase(scroll, target[0], Math.min(((double)System.currentTimeMillis() - start) / duration * (double)delta * 3.0, 1.0));
        }
        return target[0];
    }

    public static float expoEase(float start, float end, double amount) {
        return start + (end - start) * UTSmoothScrolling.getEasingMethod().apply(amount).floatValue();
    }

    public static float clamp(float v, float maxScroll) {
        return UTSmoothScrolling.clamp(v, maxScroll, 300.0f);
    }

    public static float clamp(float v, float maxScroll, float clampExtension) {
        return MathHelper.func_76131_a((float)v, (float)(-clampExtension), (float)(maxScroll + clampExtension));
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }
}

