/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.entities.rallyhealth;

import java.util.List;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="universaltweaks")
public class UTRallyHealth {
    @SubscribeEvent
    public static void utDamageHandler(LivingHurtEvent event) {
        if (!UTConfig.TWEAKS_ENTITIES.RALLY_HEALTH.utRallyHealthToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTRallyHealth ::: Damage handler");
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound playerData = player.getEntityData();
            if (event.getSource().func_76346_g() != null && !player.field_70170_p.field_72995_K) {
                playerData.func_74776_a("lastDamage", event.getAmount());
                playerData.func_74757_a("atRisk", true);
                playerData.func_74768_a("riskTime", 0);
                playerData.func_74778_a("lastMob", event.getSource().func_76346_g().func_70005_c_());
            }
        }
    }

    @SubscribeEvent
    public static void utLivingAttack(LivingAttackEvent event) {
        if (!UTConfig.TWEAKS_ENTITIES.RALLY_HEALTH.utRallyHealthToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTRallyHealth ::: Living attack");
        }
        if (event.getSource().func_76355_l().equals("player") && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            NBTTagCompound playerData = player.getEntityData();
            if (event.getEntityLiving().func_70005_c_().equals(playerData.func_74779_i("lastMob")) && !player.field_70170_p.field_72995_K && playerData.func_74767_n("atRisk") && player.field_70170_p.field_73012_v.nextInt(100) < UTConfig.TWEAKS_ENTITIES.RALLY_HEALTH.utRallyHealthHealChance) {
                player.func_70691_i(playerData.func_74760_g("lastDamage"));
                playerData.func_74757_a("atRisk", false);
                if (UTConfig.TWEAKS_ENTITIES.RALLY_HEALTH.utRallyHealthSound) {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.5f, 2.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void utRiskEvent(TickEvent.PlayerTickEvent event) {
        if (!UTConfig.TWEAKS_ENTITIES.RALLY_HEALTH.utRallyHealthToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTRallyHealth ::: Risk event");
        }
        if (event.phase.equals((Object)TickEvent.Phase.START) && event.side.isServer()) {
            MinecraftServer server = event.player.field_70170_p.func_73046_m();
            if (server == null) {
                return;
            }
            List playerList = server.func_184103_al().func_181057_v();
            for (EntityPlayer players : playerList) {
                NBTTagCompound playerData = players.getEntityData();
                int riskTime = playerData.func_74762_e("riskTime");
                if (playerData.func_74767_n("atRisk")) {
                    if (riskTime >= UTConfig.TWEAKS_ENTITIES.RALLY_HEALTH.utRallyHealthRiskTime) {
                        riskTime = 0;
                        playerData.func_74768_a("riskTime", riskTime);
                        playerData.func_74757_a("atRisk", false);
                        continue;
                    }
                    playerData.func_74768_a("riskTime", ++riskTime);
                    continue;
                }
                riskTime = 0;
                playerData.func_74768_a("riskTime", riskTime);
            }
        }
    }
}

