/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.techreborn.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.tiles.tier1.TileRollingMachine;

@Mixin(value={TileRollingMachine.class}, remap=false)
public abstract class UTRollingMachineBlockEntityMixin
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @Shadow
    public static int energyPerTick;
    @Shadow
    public static int runTime;
    @Shadow
    public Inventory inventory;
    @Shadow
    public int tickTime;
    @Shadow
    public ItemStack currentRecipeOutput;
    @Shadow
    public IRecipe currentRecipe;
    @Shadow
    public boolean locked;
    IRecipe utLastRecipe = null;
    @Shadow
    private int outputSlot;
    private List<Item> utCachedInventoryStructure = null;
    private boolean utForceRefresh = false;

    @Shadow
    public abstract void setIsActive(boolean var1);

    @Shadow
    public abstract Optional<InventoryCrafting> balanceRecipe(InventoryCrafting var1);

    @Shadow
    public abstract boolean canMake(InventoryCrafting var1);

    public ItemStack utFindMatchingRecipeOutput(InventoryCrafting inv, World world) {
        IRecipe recipe = this.utFindMatchingRecipe(inv, world);
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        return recipe.func_77572_b(inv);
    }

    public IRecipe utFindMatchingRecipe(InventoryCrafting inv, World world) {
        if (this.utIsCorrectCachedInventory()) {
            return this.utLastRecipe;
        }
        this.utCachedInventoryStructure = this.utFastInvLayout();
        IRecipe foundRecipe = RollingMachineRecipe.instance.findMatchingRecipe(inv, world);
        if (foundRecipe != null) {
            this.utLastRecipe = foundRecipe;
            return foundRecipe;
        }
        this.utLastRecipe = null;
        return null;
    }

    @Shadow
    private InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @ModifyExpressionValue(method={"getCraftingMatrix"}, at={@At(value="FIELD", target="Lreborncore/common/util/Inventory;hasChanged:Z", opcode=180, ordinal=0)})
    private boolean utCheckForceRefresh(boolean original) {
        return UTConfig.MOD_INTEGRATION.TECH_REBORN.utOptimizeRollingMachineToggle ? this.utForceRefresh || original : original;
    }

    @Inject(method={"balanceRecipe"}, at={@At(value="HEAD")}, require=1)
    private void utBalanceRecipe(CallbackInfoReturnable<Optional<InventoryCrafting>> cir) {
        if (!UTConfig.MOD_INTEGRATION.TECH_REBORN.utOptimizeRollingMachineToggle) {
            return;
        }
        this.utForceRefresh = false;
    }

    @Inject(method={"createContainer"}, at={@At(value="HEAD")}, require=1)
    private void utCreateContainer(CallbackInfoReturnable<BuiltContainer> cir) {
        if (!UTConfig.MOD_INTEGRATION.TECH_REBORN.utOptimizeRollingMachineToggle) {
            return;
        }
        this.utForceRefresh = false;
    }

    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void utOptimizedUpdate(CallbackInfo ci) {
        if (!UTConfig.MOD_INTEGRATION.TECH_REBORN.utOptimizeRollingMachineToggle) {
            return;
        }
        ci.cancel();
        super.func_73660_a();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(10);
        this.utForceRefresh = true;
        InventoryCrafting craftMatrix = this.getCraftingMatrix();
        this.currentRecipe = this.utFindMatchingRecipe(craftMatrix, this.field_145850_b);
        if (this.currentRecipe != null) {
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                this.balanceRecipe(craftMatrix);
            }
            this.currentRecipeOutput = this.currentRecipe.func_77572_b(craftMatrix);
        } else {
            this.currentRecipeOutput = ItemStack.field_190927_a;
        }
        this.utForceRefresh = false;
        craftMatrix = this.getCraftingMatrix();
        if (this.currentRecipeOutput.func_190926_b() || !this.utCheckNotEmpty(craftMatrix)) {
            this.tickTime = 0;
            this.setIsActive(false);
            return;
        }
        if (this.canUseEnergy(this.getEuPerTick(energyPerTick)) && this.canMake(craftMatrix) && this.tickTime < Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1)) {
            this.setIsActive(true);
            this.useEnergy(this.getEuPerTick(energyPerTick));
            ++this.tickTime;
        } else {
            this.setIsActive(false);
            return;
        }
        if (this.tickTime >= Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1)) {
            if (this.inventory.func_70301_a(this.outputSlot).func_190926_b()) {
                this.inventory.func_70299_a(this.outputSlot, this.currentRecipeOutput);
            } else {
                this.inventory.func_70301_a(this.outputSlot).func_190917_f(this.currentRecipeOutput.func_190916_E());
            }
            this.tickTime = 0;
            for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                this.inventory.func_70298_a(i, 1);
            }
            if (!this.locked) {
                this.currentRecipeOutput = ItemStack.field_190927_a;
                this.currentRecipe = null;
            }
        }
    }

    @Inject(method={"canMake"}, at={@At(value="HEAD")}, cancellable=true)
    private void utCanMakeIgnoreLock(InventoryCrafting craftMatrix, CallbackInfoReturnable<Boolean> cir) {
        if (!UTConfig.MOD_INTEGRATION.TECH_REBORN.utOptimizeRollingMachineToggle) {
            return;
        }
        ItemStack stack = this.utFindMatchingRecipeOutput(craftMatrix, this.field_145850_b);
        if (stack.func_190926_b()) {
            cir.setReturnValue((Object)false);
            return;
        }
        ItemStack output = this.inventory.func_70301_a(this.outputSlot);
        if (output.func_190926_b()) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)(ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true) && output.func_190916_E() + stack.func_190916_E() <= output.func_77976_d() ? 1 : 0));
    }

    @ModifyArg(method={"createContainer"}, at=@At(value="INVOKE", target="Lreborncore/client/containerBuilder/builder/ContainerTileInventoryBuilder;onCraft(Ljava/util/function/Consumer;)Lreborncore/client/containerBuilder/builder/ContainerTileInventoryBuilder;"))
    private Consumer<InventoryCrafting> utModifyOnCraftCall(Consumer<InventoryCrafting> onCraft) {
        if (!UTConfig.MOD_INTEGRATION.TECH_REBORN.utOptimizeRollingMachineToggle) {
            return onCraft;
        }
        return inv -> this.inventory.func_70299_a(1, this.utFindMatchingRecipeOutput(this.getCraftingMatrix(), this.field_145850_b));
    }

    private boolean utCheckNotEmpty(InventoryCrafting craftMatrix) {
        if (this.locked) {
            boolean returnValue = false;
            for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack1 = craftMatrix.func_70301_a(i);
                if (stack1.func_190916_E() == 1) {
                    return false;
                }
                if (stack1.func_190916_E() <= 1) continue;
                returnValue = true;
            }
            return returnValue;
        }
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack1 = craftMatrix.func_70301_a(i);
            if (stack1.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private List<Item> utFastInvLayout() {
        if (this.inventory == null) {
            return null;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(9);
        for (int i = 0; i < 9; ++i) {
            arrayList.add(this.inventory.func_70301_a(i).func_77973_b());
        }
        return arrayList;
    }

    private boolean utIsCorrectCachedInventory() {
        if (this.utCachedInventoryStructure == null) {
            return false;
        }
        List<Item> current = this.utFastInvLayout();
        if (current == null || current.size() != this.utCachedInventoryStructure.size()) {
            return false;
        }
        for (int i = 0; i < current.size(); ++i) {
            if (current.get(i) == this.utCachedInventoryStructure.get(i)) continue;
            return false;
        }
        return true;
    }
}

