/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.config;

import com.cleanroommc.configanytime.ConfigAnytime;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.bugfixes.blocks.blockoverlay.UTBlockOverlayLists;
import mod.acgaming.universaltweaks.core.UTLoadingPlugin;
import mod.acgaming.universaltweaks.mods.botania.UTBotaniaFancySkybox;
import mod.acgaming.universaltweaks.tweaks.blocks.breakablebedrock.UTBreakableBedrock;
import mod.acgaming.universaltweaks.tweaks.items.parry.UTParry;
import mod.acgaming.universaltweaks.tweaks.items.rarity.UTCustomRarity;
import mod.acgaming.universaltweaks.tweaks.items.useduration.UTCustomUseDuration;
import mod.acgaming.universaltweaks.tweaks.misc.incurablepotions.UTIncurablePotions;
import mod.acgaming.universaltweaks.tweaks.misc.loadsound.UTLoadSound;
import mod.acgaming.universaltweaks.tweaks.misc.swingthroughgrass.UTSwingThroughGrassLists;
import mod.acgaming.universaltweaks.tweaks.performance.autosave.UTAutoSaveOFCompat;
import mod.acgaming.universaltweaks.util.compat.UTObsoleteModsHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="universaltweaks", name="UniversalTweaks")
public class UTConfig {
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.blocks")
    @Config.Name(value="Bugfixes: Blocks")
    public static final BugfixesBlocksCategory BUGFIXES_BLOCKS = new BugfixesBlocksCategory();
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.entities")
    @Config.Name(value="Bugfixes: Entities")
    public static final BugfixesEntitiesCategory BUGFIXES_ENTITIES = new BugfixesEntitiesCategory();
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.misc")
    @Config.Name(value="Bugfixes: Misc")
    public static final BugfixesMiscCategory BUGFIXES_MISC = new BugfixesMiscCategory();
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.world")
    @Config.Name(value="Bugfixes: World")
    public static final BugfixesWorldCategory BUGFIXES_WORLD = new BugfixesWorldCategory();
    @Config.LangKey(value="cfg.universaltweaks.debug")
    @Config.Name(value="Debug")
    public static final DebugCategory DEBUG = new DebugCategory();
    @Config.LangKey(value="cfg.universaltweaks.modintegration")
    @Config.Name(value="Mod Integration")
    public static final ModIntegrationCategory MOD_INTEGRATION = new ModIntegrationCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks")
    @Config.Name(value="Tweaks: Blocks")
    public static final TweaksBlocksCategory TWEAKS_BLOCKS = new TweaksBlocksCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.entities")
    @Config.Name(value="Tweaks: Entities")
    public static final TweaksEntitiesCategory TWEAKS_ENTITIES = new TweaksEntitiesCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.items")
    @Config.Name(value="Tweaks: Items")
    public static final TweaksItemsCategory TWEAKS_ITEMS = new TweaksItemsCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.misc")
    @Config.Name(value="Tweaks: Misc")
    public static final TweaksMiscCategory TWEAKS_MISC = new TweaksMiscCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.performance")
    @Config.Name(value="Tweaks: Performance")
    public static final TweaksPerformanceCategory TWEAKS_PERFORMANCE = new TweaksPerformanceCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.world")
    @Config.Name(value="Tweaks: World")
    public static final TweaksWorldCategory TWEAKS_WORLD = new TweaksWorldCategory();

    static {
        ConfigAnytime.register(UTConfig.class);
    }

    @Mod.EventBusSubscriber(modid="universaltweaks")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("universaltweaks")) {
                ConfigManager.sync((String)"universaltweaks", (Config.Type)Config.Type.INSTANCE);
                if (UTConfig.TWEAKS_BLOCKS.BREAKABLE_BEDROCK.utBreakableBedrockToggle) {
                    UTBreakableBedrock.initToolList();
                }
                if (UTConfig.TWEAKS_MISC.SWING_THROUGH_GRASS.utSwingThroughGrassToggle) {
                    UTSwingThroughGrassLists.initLists();
                }
                if (UTConfig.TWEAKS_MISC.INCURABLE_POTIONS.utIncurablePotionsToggle) {
                    UTIncurablePotions.initPotionList();
                }
                if (UTConfig.TWEAKS_ITEMS.utCustomRarities.length > 0) {
                    UTCustomRarity.initItemRarityMap();
                }
                if (UTConfig.TWEAKS_ITEMS.utCustomUseDurations.length > 0) {
                    UTCustomUseDuration.initItemUseMaps();
                }
                if (UTConfig.TWEAKS_ITEMS.PARRY.utParryToggle) {
                    UTParry.initProjectileList();
                }
                if (UTLoadingPlugin.isClient) {
                    if (UTConfig.BUGFIXES_BLOCKS.BLOCK_OVERLAY.utBlockOverlayToggle) {
                        UTBlockOverlayLists.initLists();
                    }
                    if (Loader.isModLoaded((String)"botania")) {
                        UTBotaniaFancySkybox.initDimList();
                    }
                    if (UTConfig.TWEAKS_MISC.LOAD_SOUNDS.utLoadSoundMode != TweaksMiscCategory.LoadSoundsCategory.EnumSoundModes.NOTHING) {
                        UTLoadSound.initLists();
                    }
                    UTAutoSaveOFCompat.updateOFConfig();
                }
                UTObsoleteModsHandler.showObsoleteMods = true;
                UniversalTweaks.LOGGER.info("Universal Tweaks config reloaded");
            }
        }
    }

    public static class ModIntegrationCategory {
        @Config.LangKey(value="cfg.universaltweaks.modintegration.abyssalcraft")
        @Config.Name(value="AbyssalCraft")
        public final AbyssalCraftCategory ABYSSALCRAFT = new AbyssalCraftCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.actuallyadditions")
        @Config.Name(value="Actually Additions")
        public final ActuallyAdditionsCategory ACTUALLY_ADDITIONS = new ActuallyAdditionsCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.arcanearchives")
        @Config.Name(value="Arcane Archives")
        public final ArcaneArchivesCategory ARCANE_ARCHIVES = new ArcaneArchivesCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.aoa")
        @Config.Name(value="Advent of Ascension")
        public final AOACategory AOA = new AOACategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.bop")
        @Config.Name(value="Biomes O' Plenty")
        public final BiomesOPlentyCategory BIOMES_O_PLENTY = new BiomesOPlentyCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.bm")
        @Config.Name(value="Blood Magic")
        public final BloodMagicCategory BLOOD_MAGIC = new BloodMagicCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.botania")
        @Config.Name(value="Botania")
        public final BotaniaCategory BOTANIA = new BotaniaCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.chisel")
        @Config.Name(value="Chisel")
        public final ChiselCategory CHISEL = new ChiselCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.cqrepoured")
        @Config.Name(value="Chocolate Quest Repoured")
        public final ChocolateQuestCategory CHOCOLATE_QUEST = new ChocolateQuestCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.cofhcore")
        @Config.Name(value="CoFH Core")
        public final CoFHCoreCategory COFH_CORE = new CoFHCoreCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.elementarystaffs")
        @Config.Name(value="Elementary Staffs")
        public final ElementaryStaffsCategory ELEMENTARY_STAFFS = new ElementaryStaffsCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.elenaidodge2")
        @Config.Name(value="Elenai Dodge 2")
        public final ElenaiDodge2Category ELENAI_DODGE_2 = new ElenaiDodge2Category();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.esm")
        @Config.Name(value="Epic Siege Mod")
        public final EpicSiegeModCategory EPIC_SIEGE_MOD = new EpicSiegeModCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.erebus")
        @Config.Name(value="The Erebus")
        public final ErebusCategory EREBUS = new ErebusCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.extrautilities")
        @Config.Name(value="Extra Utilities 2")
        public final ExtraUtilitiesCategory EXTRA_UTILITIES = new ExtraUtilitiesCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.forestry")
        @Config.Name(value="Forestry")
        public final ForestryCategory FORESTRY = new ForestryCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.industrialcraft")
        @Config.Name(value="IndustrialCraft 2")
        public final IndustrialCraftCategory INDUSTRIALCRAFT = new IndustrialCraftCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.industrialforegoing")
        @Config.Name(value="Industrial Foregoing")
        public final IndustrialForegoingCategory INDUSTRIAL_FOREGOING = new IndustrialForegoingCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.infernalmobs")
        @Config.Name(value="Infernal Mobs")
        public final InfernalMobsCategory INFERNAL_MOBS = new InfernalMobsCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.ironbackpacks")
        @Config.Name(value="Iron Backpacks")
        public final IronBackpacksCategory IRON_BACKPACKS = new IronBackpacksCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.itemstages")
        @Config.Name(value="Item Stages")
        public final ItemStagesCategory ITEM_STAGES = new ItemStagesCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.mekanism")
        @Config.Name(value="Mekanism")
        public final MekanismCategory MEKANISM = new MekanismCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.mobstages")
        @Config.Name(value="Mob Stages")
        public final MobStagesCategory MOB_STAGES = new MobStagesCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.netherchest")
        @Config.Name(value="Nether Chest")
        public final NetherChestCategory NETHER_CHEST = new NetherChestCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.netherrocks")
        @Config.Name(value="Netherrocks")
        public final NetherrocksCategory NETHERROCKS = new NetherrocksCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.nuclearcraft")
        @Config.Name(value="NuclearCraft")
        public final NuclearCraftCategory NUCLEARCRAFT = new NuclearCraftCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.projectred")
        @Config.Name(value="ProjectRed")
        public final ProjectRedCategory PROJECTRED = new ProjectRedCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.quark")
        @Config.Name(value="Quark")
        public final QuarkCategory QUARK = new QuarkCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.roost")
        @Config.Name(value="Roost")
        public final RoostCategory ROOST = new RoostCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.simpledifficulty")
        @Config.Name(value="Simple Difficulty")
        public final SimpleDifficultyCategory SIMPLE_DIFFICULTY = new SimpleDifficultyCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.spiceoflife")
        @Config.Name(value="Spice Of Life")
        public final SpiceOfLifeCategory SPICE_OF_LIFE = new SpiceOfLifeCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.sd")
        @Config.Name(value="Storage Drawers")
        public final StorageDrawersCategory STORAGE_DRAWERS = new StorageDrawersCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tr")
        @Config.Name(value="Tech Reborn")
        public final TechRebornCategory TECH_REBORN = new TechRebornCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tc")
        @Config.Name(value="Thaumcraft")
        public final ThaumcraftCategory THAUMCRAFT = new ThaumcraftCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tc.entities")
        @Config.Name(value="Thaumcraft: Entities")
        public final ThaumcraftEntitiesCategory THAUMCRAFT_ENTITIES = new ThaumcraftEntitiesCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tc.foci")
        @Config.Name(value="Thaumcraft: Foci")
        public final ThaumcraftFociCategory THAUMCRAFT_FOCI = new ThaumcraftFociCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.thaumicwonders")
        @Config.Name(value="Thaumic Wonders")
        public final ThaumicWondersCategory THAUMIC_WONDERS = new ThaumicWondersCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.thefarlanders")
        @Config.Name(value="The Farlanders")
        public final TheFarlandersCategory THE_FARLANDERS = new TheFarlandersCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.te")
        @Config.Name(value="Thermal Expansion")
        public final ThermalExpansionCategory THERMAL_EXPANSION = new ThermalExpansionCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tcon")
        @Config.Name(value="Tinkers' Construct")
        public final TinkersConstructCategory TINKERS_CONSTRUCT = new TinkersConstructCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tinyprogressions")
        @Config.Name(value="Tiny Progressions")
        public final TinyProgressionsCategory TINY_PROGRESSIONS = new TinyProgressionsCategory();

        public static class TinyProgressionsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class TinkersConstructCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Gaseous Fluids")
            @Config.Comment(value={"Excludes gaseous fluids from being transferable via faucets"})
            public boolean utTConGaseousFluidsToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="Projectile Despawning")
            @Config.Comment(value={"Despawns unbreakable projectiles faster to improve framerates"})
            public boolean utTConProjectileToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Offhand Shuriken")
            @Config.Comment(value={"Suppresses special abilities of long swords and rapiers when shurikens are wielded in the offhand"})
            public boolean utTConShurikenToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Ore Dictionary Cache")
            @Config.Comment(value={"Caches all ore dictionary smelting recipes to speed up game loading"})
            public boolean utTConOreDictCacheToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ThermalExpansionCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Insolator Custom Monoculture")
            @Config.Comment(value={"Adds Monoculture Cycle integration to desired phytogenic insolator recipes added by ModTweaker", "Register the recipe with Insolator.addRecipeMonoculture() instead of Insolator.addRecipe() in .zs files", "(and Insolator.addRecipeMonocultureSaplingInfuser() instead of Insolator.addRecipeSaplingInfuser())", "Note: Make sure the 'fertilizer' is specified as the secondaryInput arg in the function"})
            public boolean utTEInsolatorCustomMonoculture = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class TheFarlandersCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ThaumicWondersCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ThaumcraftFociCategory {
            @Config.LangKey(value="cfg.universaltweaks.modintegration.tc.foci.focuseffects")
            @Config.Name(value="Focus Effects")
            public final FocusEffectsCategory FOCUS_EFFECTS = new FocusEffectsCategory();
            @Config.LangKey(value="cfg.universaltweaks.modintegration.tc.foci.focusmediums")
            @Config.Name(value="Focus Mediums")
            public final FocusMediumsCategory FOCUS_MEDIUMS = new FocusMediumsCategory();

            public static class FocusMediumsCategory {
                @Config.RequiresMcRestart
                @Config.Name(value="[1] Bolt: Cast Sound")
                @Config.Comment(value={"Plays an additional cast sound when using any bolt focus medium to add an extra layer of pow"})
                public boolean utTCBoltMediumSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[2] Cloud: Cast Sound")
                @Config.Comment(value={"Plays an additional cast sound when using any cloud focus medium"})
                public boolean utTCCloudMediumSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[3] Mine: Sound Overhaul")
                @Config.Comment(value={"Adds additional cast, despawn, and setup sounds when using any mine focus medium"})
                public boolean utTCMineMediumSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[4] Spellbat: Cast Sound")
                @Config.Comment(value={"Plays an additional cast sound when summoning any type of spellbat"})
                public boolean utTCSpellBatMediumSoundToggle = true;
            }

            public static class FocusEffectsCategory {
                @Config.RequiresMcRestart
                @Config.Name(value="[01] Break: Cast Sound Revamp")
                @Config.Comment(value={"Overhauls the break focus effect cast sound"})
                public boolean utTCBreakFocusSoundRevampToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[02] Break: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the break focus effect"})
                public boolean utTCBreakFocusImpactSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[03] Earth: Cast Sound Revamp")
                @Config.Comment(value={"Overhauls the earth focus effect cast sound"})
                public boolean utTCEarthFocusSoundRevampToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[04] Earth: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the earth focus effect"})
                public boolean utTCEarthFocusImpactSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[05] Fire: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the fire focus effect"})
                public boolean utTCFireFocusImpactSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[06] Flux: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the flux focus effect"})
                public boolean utTCFluxFocusImpactSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[07] Frost: Cast Sound Revamp")
                @Config.Comment(value={"Overhauls the frost focus effect cast sound to make it a lot less plangent"})
                public boolean utTCFrostFocusSoundRevampToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[08] Frost: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the frost focus effect"})
                public boolean utTCFrostFocusImpactSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[09] Heal: Cast Sound Revamp")
                @Config.Comment(value={"Overhauls the heal focus effect cast sound"})
                public boolean utTCHealFocusSoundRevampToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[10] Heal: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the heal focus effect"})
                public boolean utTCHealFocusImpactSoundToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[11] Rift: Cast Sound Revamp")
                @Config.Comment(value={"Overhauls the rift focus effect cast sound"})
                public boolean utTCRiftFocusSoundRevampToggle = true;
                @Config.RequiresMcRestart
                @Config.Name(value="[12] Rift: Impact Sound")
                @Config.Comment(value={"Adds an impact sound to the rift focus effect"})
                public boolean utTCRiftFocusImpactSoundToggle = true;
            }
        }

        public static class ThaumcraftEntitiesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Firebat Particles")
            @Config.Comment(value={"Adds particles to firebats similar to legacy versions"})
            public boolean utTCFirebatParticlesToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Spiderlike Eldritch Crabs")
            @Config.Comment(value={"Rotates dead eldritch crabs all the way like endermites, silverfish, and spiders"})
            public boolean utTCSpiderlikeEldritchCrabToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Wisp Particles")
            @Config.Comment(value={"Increases particle size of wisps similar to legacy versions"})
            public boolean utTCWispParticlesToggle = true;
        }

        public static class ThaumcraftCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Flower Bounding Box")
            @Config.Comment(value={"Fixes the bounding box always being at the center in both cinderpearls and shimmerleafs"})
            public boolean utTCFlowerBoundingBoxToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Stable Thaumometer")
            @Config.Comment(value={"Stops the thaumometer from bobbing rapidly when using it to scan objects"})
            public boolean utTCStableThaumometerToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class TechRebornCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Optimized Rolling Machine")
            @Config.Comment(value={"Optimizes the Rolling Machine to reduce tick time"})
            public boolean utOptimizeRollingMachineToggle = true;
        }

        public static class StorageDrawersCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Item Handlers")
            @Config.Comment(value={"Fixes voiding of items when nearing full capacity", "Fixes slotless item handler implementation not allowing the extraction from compacting item drawers with the vending upgrade", "Caches the drawer controller tile to avoid getting the TE from the world every time a drawer slave is interacted with"})
            public boolean utSDItemHandlers = false;
            @Config.RequiresMcRestart
            @Config.Name(value="Render Range")
            @Config.Comment(value={"Approximate range in blocks at which drawers render contained items", "0 for default unlimited range"})
            public int utSDRenderRange = 0;
        }

        public static class SpiceOfLifeCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class SimpleDifficultyCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Iron Canteen Interaction Fix")
            @Config.Comment(value={"Fixes the interaction of iron canteens with rain collectors"})
            public boolean utRainCollectorCanteenToggle = true;
        }

        public static class RoostCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="ContentTweaker: Early Register CT Chickens")
            @Config.Comment(value={"Improves load time by registering CT chickens early for Roost to detect them", "Note: All CT chickens must be specified in \"Custom Chickens\" for this tweak to work!", "Note: In your .zs files, to use ContentTweaker's MaterialSystem Parts, you must:", "1) Use '#loader finalize_contenttweaker', not '#loader contenttweaker'", "2) Use the Material Part Bracket Handler to reference the item"})
            public boolean utRoostEarlyRegisterCTChickens = false;
            @Config.RequiresMcRestart
            @Config.Name(value="Custom Chickens")
            @Config.Comment(value={"Adds custom chickens from mods (e.g. ContentTweaker) to Roost's stock texture check", "Syntax: name", "name     Chicken name"})
            public String[] utRoostChickenMods = new String[0];
        }

        public static class QuarkCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ProjectRedCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class NuclearCraftCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Radiation Environment Map")
            @Config.Comment(value={"Changes the data table of the radiation environment handler to improve performance", "CONCURRENT_HASHMAP:        NuclearCraft default", "CONCURRENT_LINKED_HASHMAP: Keeps order of radiation environment info to improve iteration - Better performance", "CONCURRENT_LINKED_QUEUE:   Uses a queue to avoid iteration - Best performance"})
            public EnumMaps utNCRadiationEnvironmentMap = EnumMaps.CONCURRENT_LINKED_QUEUE;

            public static enum EnumMaps {
                CONCURRENT_HASHMAP,
                CONCURRENT_LINKED_HASHMAP,
                CONCURRENT_LINKED_QUEUE;

            }
        }

        public static class NetherrocksCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Right Click Harvesting Fix")
            @Config.Comment(value={"Prevents crashing with mods implementing right click crop harvesting"})
            public boolean utNRRightClickHarvestingToggle = true;
        }

        public static class NetherChestCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class MobStagesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Spawning Rules Fixes")
            @Config.Comment(value={"Fixes mob replacement ignoring entity spawning rules"})
            public boolean utSpawningRules = true;
        }

        public static class MekanismCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ItemStagesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Ingredient Matching")
            @Config.Comment(value={"Changes item matching code to CraftTweaker's ingredient matching system, fixes item NBT issues"})
            public boolean utIngredientMatching = true;
        }

        public static class IronBackpacksCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class InfernalMobsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Sticky Recall Compatibility")
            @Config.Comment(value={"Enables compatibility between Infernal Mobs' Sticky effect and Capsule's Recall enchantment"})
            public boolean utIMStickyRecallToggle = true;
        }

        public static class IndustrialForegoingCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class IndustrialCraftCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ForestryCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Arborist Villager Trades")
            @Config.Comment(value={"Adds custom emerald to germling trades to the arborist villager", "Syntax:        level;emeralds_min;emeralds_max;germlings_min;germlings_max;type;complexity_min;complexity_max", "level          Level when this trade becomes available (how much trading needs to be done)", "emeralds_min   Lower random limit for emeralds", "emeralds_max   Upper random limit for emeralds", "germlings_min  Lower random limit for germlings", "germlings_max  Upper random limit for germlings", "type           Type of germling, can be either pollen or sapling", "complexity_min Lower limit of allele complexity", "complexity_max Upper limit of allele complexity", "", "Example for a level 5 trade for a single sapling with a complexity between 6 and 10, costing between 10 to 40 emeralds:", "5;10;40;1;1;sapling;6;10"})
            public String[] utFOArboristDeals = new String[0];
            @Config.RequiresMcRestart
            @Config.Name(value="Disable Bee Damage Armor Bypass")
            @Config.Comment(value={"Disables damage caused by bees bypassing player armor"})
            public boolean utFOBeeDamageArmorBypassToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Extra Trees: Gather Windfall")
            @Config.Comment(value={"Allows Forestry farms to pick up ExtraTrees fruit"})
            public boolean utFOGatherWindfallToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Replanting Cocoa Beans")
            @Config.Comment(value={"Allows Forestry farms to automatically replant cocoa beans"})
            public boolean utFOCocoaBeansToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ExtraUtilitiesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ErebusCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Preserved Blocks Fix")
            @Config.Comment(value={"Prevents HWYLA/TOP crashes with preserved blocks"})
            public boolean utEBPreservedBlocksToggle = true;
        }

        public static class EpicSiegeModCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Disable Digger AI Debug")
            @Config.Comment(value={"Disables leftover debug logging inside the digger AI of the beta builds"})
            public boolean utESMDiggerDebugToggle = true;
        }

        public static class ElenaiDodge2Category {
            @Config.RequiresMcRestart
            @Config.Name(value="Feathers Helper API Fix")
            @Config.Comment(value={"Fixes server-sided crashes when the Feathers Helper API is utilized"})
            public boolean utED2FeathersHelperToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Sprinting Feather Consumption")
            @Config.Comment(value={"Sets the amount of consumed half-feathers per interval when the player is sprinting"})
            public int utED2SprintingFeatherConsumption = 0;
            @Config.Name(value="Sprinting Feather Interval")
            @Config.Comment(value={"Sets the rate feathers are consumed in ticks when the player is sprinting"})
            public int utED2SprintingFeatherInterval = 20;
            @Config.Name(value="Sprinting Feather Requirement")
            @Config.Comment(value={"Sets the amount of half-feathers required to start sprinting"})
            public int utED2SprintingFeatherRequirement = 6;
        }

        public static class ElementaryStaffsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Electric Staff Port")
            @Config.Comment(value={"Reintroduces the 1.5 electric staff behavior along with some subtle particles"})
            public boolean utESElectricStaffToggle = true;
        }

        public static class CoFHCoreCategory {
            @Config.Name(value="Vorpal Enchantment Damage")
            @Config.Comment(value={"Sets the damage multiplier of the Vorpal enchantment"})
            public double utCoFHVorpalDamage = 10.0;
        }

        public static class ChocolateQuestCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Legacy Golden Feather")
            @Config.Comment(value={"Restores the golden feather behavior from the original Better Dungeons mod"})
            public boolean utCQRGoldenFeatherToggle = true;
        }

        public static class ChiselCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class BotaniaCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Fancy Skybox")
            @Config.Comment(value={"Enables the Botania Garden of Glass skybox for custom dimensions", "Abides by Botania's 'enableFancySkybox' config option", "Example: 43"})
            public Integer[] utBotaniaSkyboxDims = new Integer[0];
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class BloodMagicCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Optimized Hellfire Forge")
            @Config.Comment(value={"Optimizes the Hellfire/Soul Forge to reduce tick time"})
            public boolean utBMOptimizeSoulForgeToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="World Unload Memory Leak Fix")
            @Config.Comment(value={"Fixes memory leak related to unloading worlds/switching dimensions"})
            public boolean utBMWorldUnloadToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class BiomesOPlentyCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Hot Spring Water")
            @Config.Comment(value={"Fixes rapid inflection of regeneration effects in hot spring water"})
            public boolean utBoPHotSpringWaterToggle = true;
        }

        public static class AOACategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Inventory-less GUI Compatibility")
            @Config.Comment(value={"Fixes AoA player ticking in certain GUIs without player inventories (i.e. Flux Networks GUI)"})
            public boolean utFixPlayerTickInInventorylessGui = false;
        }

        public static class ArcaneArchivesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class ActuallyAdditionsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Duplication Fixes")
            @Config.Comment(value={"Fixes various duplication exploits"})
            public boolean utDuplicationFixesToggle = true;
        }

        public static class AbyssalCraftCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Optimized Item Transport")
            @Config.Comment(value={"Makes an optimization to reduce tick overhead of AbyssalCraft's item transport system"})
            public boolean utOptimizedItemTransferToggle = true;
        }
    }

    public static class DebugCategory {
        @Config.Name(value="Bypass Incompatibility Warnings")
        @Config.Comment(value={"For those who live life on the edge, may or may not include Jons"})
        public boolean utBypassIncompatibilityToggle = false;
        @Config.Name(value="Debug Logging")
        @Config.Comment(value={"Enables debug logging"})
        public boolean utDebugToggle = false;
        @Config.Name(value="Show Loading Time")
        @Config.Comment(value={"Prints the time the game needed to launch to the log"})
        public boolean utLoadingTimeToggle = true;
    }

    public static class TweaksWorldCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.chunkgenlimit")
        @Config.Name(value="Chunk Gen Limit")
        public final ChunkGenLimitCategory CHUNK_GEN_LIMIT = new ChunkGenLimitCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.dimensionunload")
        @Config.Name(value="Dimension Unload")
        public final DimensionUnloadCategory DIMENSION_UNLOAD = new DimensionUnloadCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Sea Level")
        @Config.Comment(value={"Sets the default height of the overworld's sea level", "Vanilla default is 63"})
        public int utSeaLevel = 63;
        @Config.RequiresMcRestart
        @Config.Name(value="Stronghold Replacement")
        @Config.Comment(value={"Replaces stronghold generation with a safer variant"})
        public boolean utStrongholdToggle = true;
        @Config.Name(value="Tidy Chunk")
        @Config.Comment(value={"Tidies newly generated chunks by removing scattered item entities"})
        public boolean utTidyChunkToggle = false;

        public static class DimensionUnloadCategory {
            @Config.Name(value="[1] Dimension Unload Toggle")
            @Config.Comment(value={"Unloads dimensions not in use to free up resources"})
            public boolean utUnloaderToggle = true;
            @Config.Name(value="[2] Interval")
            @Config.Comment(value={"Time (in ticks) to wait before checking dimensions"})
            public int utUnloaderInterval = 600;
            @Config.Name(value="[3] Blacklist")
            @Config.Comment(value={"List of dimensions which should not be unloaded", "Can be dimension name or ID", "Uses regular expressions"})
            public String[] utUnloaderBlacklist = new String[]{"0", "overworld"};
        }

        public static class ChunkGenLimitCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Chunk Gen Limit Toggle")
            @Config.Comment(value={"Limits maximum chunk generation per tick for improved server performance"})
            public boolean utChunkGenLimitToggle = false;
            @Config.Name(value="[2] Ticks")
            @Config.Comment(value={"Maximum chunks to generate per tick per dimension"})
            public int utChunkGenLimitTicks = 2;
            @Config.Name(value="[3] Time")
            @Config.Comment(value={"Maximum time in ms to spend generating chunks per tick per dimension"})
            public int utChunkGenLimitTime = 5;
        }
    }

    public static class TweaksPerformanceCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Auto Save Interval")
        @Config.Comment(value={"Determines the interval in ticks between world auto saves"})
        public int utAutoSaveInterval = 900;
        @Config.RequiresMcRestart
        @Config.Name(value="Check Animated Models")
        @Config.Comment(value={"Improves model load times by checking if an animated model exists before trying to load it"})
        public boolean utCheckAnimatedModelsToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Crafting Cache")
        @Config.Comment(value={"Adds an IRecipe cache to improve recipe performance in larger modpacks"})
        public boolean utCraftingCacheToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Audio Debug")
        @Config.Comment(value={"Improves loading times by removing debug code for missing sounds and subtitles"})
        public boolean utDisableAudioDebugToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Fancy Missing Model")
        @Config.Comment(value={"Improves rendering performance by removing the resource location text on missing models"})
        public boolean utDisableFancyMissingModelToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Faster Background Startup")
        @Config.Comment(value={"Fixes slow background startup edge case caused by checking tooltips during the loading process"})
        public boolean utFasterBackgroundStartupToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast Dye Blending")
        @Config.Comment(value={"Replaces color lookup for sheep to check a predefined table rather than querying the recipe registry"})
        public boolean utDyeBlendingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast Prefix Checking")
        @Config.Comment(value={"Optimizes Forge's ID prefix checking and removes prefix warnings impacting load time"})
        public boolean utPrefixCheckToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast World Loading")
        @Config.Comment(value={"Skips initial world chunk loading & garbage collection to speed up world loading", "May have side effects such as slower chunk generation"})
        public boolean utWorldLoadingToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Redstone Lighting")
        @Config.Comment(value={"Disables lighting of active redstone, repeaters, and comparators to improve performance"})
        public boolean utRedstoneLightingToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Uncap FPS")
        @Config.Comment(value={"Removes the hardcoded 30 FPS limit in screens like the main menu"})
        public boolean utUncapFPSToggle = true;
    }

    public static class TweaksMiscCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.incurablepotions")
        @Config.Name(value="Incurable Potions")
        public final IncurablePotionsCategory INCURABLE_POTIONS = new IncurablePotionsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.lightning")
        @Config.Name(value="Lightning")
        public final LightningCategory LIGHTNING = new LightningCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.loadsounds")
        @Config.Name(value="Load Sounds")
        public final LoadSoundsCategory LOAD_SOUNDS = new LoadSoundsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.pickupnotification")
        @Config.Name(value="Pickup Notification")
        public final PickupNotificationCategory PICKUP_NOTIFICATION = new PickupNotificationCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.smoothscrolling")
        @Config.Name(value="Smooth Scrolling")
        public final SmoothScrollingCategory SMOOTH_SCROLLING = new SmoothScrollingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.stg")
        @Config.Name(value="Swing Through Grass")
        public final SwingThroughGrassCategory SWING_THROUGH_GRASS = new SwingThroughGrassCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.toastcontrol")
        @Config.Name(value="Toast Control")
        public final ToastControlCategory TOAST_CONTROL = new ToastControlCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Copy World Seed")
        @Config.Comment(value={"Enables clicking of `/seed` world seed in chat to copy to clipboard"})
        public boolean utCopyWorldSeedToggle = false;
        @Config.Name(value="Damage Tilt")
        @Config.Comment(value={"Restores feature to tilt the camera when damaged"})
        public boolean utDamageTiltToggle = true;
        @Config.Name(value="Default Difficulty")
        @Config.Comment(value={"Sets the default difficulty for newly generated worlds"})
        public EnumDifficulty utDefaultDifficulty = EnumDifficulty.NORMAL;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Narrator")
        @Config.Comment(value={"Disables the narrator functionality entirely"})
        public boolean utDisableNarratorToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="End Portal Parallax")
        @Config.Comment(value={"Re-implements parallax rendering of the end portal from 1.10 and older"})
        public boolean utEndPortalParallaxToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Infinite Music")
        @Config.Comment(value={"Lets background music play continuously without delays"})
        public boolean utInfiniteMusicToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Linear XP Amount")
        @Config.Comment(value={"Sets the amount of XP needed for each level, effectively removing the increasing level scaling", "0 for vanilla default"})
        public int utLinearXP = 0;
        @Config.RequiresMcRestart
        @Config.Name(value="No Night Vision Flash")
        @Config.Comment(value={"Disables the flashing effect when the night vision potion effect is about to run out"})
        public boolean utNightVisionFlashToggle = false;
        @Config.Name(value="No Potion Shift")
        @Config.Comment(value={"Disables the inventory shift when potion effects are active"})
        public boolean utPotionShiftToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="No Smelting XP")
        @Config.Comment(value={"Disables the experience reward when smelting items in furnaces"})
        public boolean utSmeltingXPToggle = false;
        @Config.Name(value="Offhand Improvement")
        @Config.Comment(value={"Prevents placing offhand blocks when blocks or food are held in the mainhand"})
        public boolean utOffhandToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Overlay Message Height")
        @Config.Comment(value={"Sets the Y value of the overlay message (action bar), displayed for playing records etc.", "-4 for vanilla default"})
        public int utOverlayMessageHeight = -4;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove Realms Button")
        @Config.Comment(value={"Removes the redundant Minecraft Realms button from the main menu", "Incompatible with RandomPatches"})
        public boolean utRealmsButtonToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove Recipe Book")
        @Config.Comment(value={"Removes the recipe book button from GUIs"})
        public boolean utRecipeBookToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove Snooper")
        @Config.Comment(value={"Forcefully turns off the snooper and hides the snooper settings button from the options menu"})
        public boolean utSnooperToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Selected Item Tooltip Height")
        @Config.Comment(value={"Sets the Y value of the selected item tooltip, displayed when held items are changed", "59 for vanilla default"})
        public int utSelectedItemTooltipHeight = 59;
        @Config.RequiresMcRestart
        @Config.Name(value="Skip Credits")
        @Config.Comment(value={"Skips the credits screen after the player goes through the end podium portal"})
        public boolean utSkipCreditsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Skip Missing Registry Entries Screen")
        @Config.Comment(value={"Automatically confirms the 'Missing Registry Entries' screen on world load", "Identical to the launch parameter `-Dfml.queryResult=confirm`"})
        public boolean utSkipRegistryScreenToggle = false;
        @Config.Name(value="Toggle Cheats Button")
        @Config.Comment(value={"Adds a button to the pause menu to toggle cheats"})
        public boolean utToggleCheatsToggle = true;

        public static class ToastControlCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Toast Control Toggle")
            @Config.Comment(value={"Enables the control of toasts (pop-up text boxes)"})
            public boolean utToastControlToggle = true;
            @Config.Name(value="[2] Disable Advancement Toasts")
            @Config.Comment(value={"Determines if advancement toasts are blocked. Enabling will block ALL advancements."})
            public boolean utToastControlAdvancementsToggle = false;
            @Config.Name(value="[3] Disable Recipe Toasts")
            @Config.Comment(value={"Determines if recipe unlock toasts are blocked. Blocks \"you have unlocked a new recipe\" toasts."})
            public boolean utToastControlRecipesToggle = true;
            @Config.Name(value="[4] Disable System Toasts")
            @Config.Comment(value={"Determines if system toasts are blocked. This is used only for the narrator toggle notification right now."})
            public boolean utToastControlSystemToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="[5] Disable Tutorial Toasts")
            @Config.Comment(value={"Determines if tutorial toasts are blocked. Blocks useless things like use WASD to move."})
            public boolean utToastControlTutorialToggle = true;
        }

        public static class SwingThroughGrassCategory {
            @Config.Name(value="[1] Swing Through Grass Toggle")
            @Config.Comment(value={"Allows hitting entities through grass instead of breaking it"})
            public boolean utSwingThroughGrassToggle = true;
            @Config.Name(value="[2] Blacklist")
            @Config.Comment(value={"Excludes blocks from the swing through grass tweak", "Syntax: modid:block"})
            public String[] utSwingThroughGrassBlacklist = new String[0];
            @Config.Name(value="[3] Whitelist")
            @Config.Comment(value={"Includes blocks in the swing through grass tweak", "Syntax: modid:block"})
            public String[] utSwingThroughGrassWhitelist = new String[0];
        }

        public static class SmoothScrollingCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Smooth Scrolling Toggle")
            @Config.Comment(value={"Adds smooth scrolling to in-game lists"})
            public boolean utSmoothScrollingToggle = true;
            @Config.Name(value="[2] Bounce Back Multiplier")
            public double utSmoothScrollingBounce = 0.24;
            @Config.Name(value="[3] Scroll Duration")
            public int utSmoothScrollingDuration = 600;
            @Config.Name(value="[4] Scroll Step")
            public double utSmoothScrollingStep = 19.0;
        }

        public static class PickupNotificationCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Pickup Notification Toggle")
            @Config.Comment(value={"Displays notifications when the player obtains or loses items"})
            public boolean utPickupNotificationToggle = false;
            @Config.Name(value="[02] Display Item Additions")
            @Config.Comment(value={"Displays item additions when a player obtains an item"})
            public boolean utPUNItemAdditions = true;
            @Config.Name(value="[03] Display Item Removals")
            @Config.Comment(value={"Displays item removals when a player loses an item"})
            public boolean utPUNItemRemovals = true;
            @Config.Name(value="[04] Display Experience")
            @Config.Comment(value={"Displays changes in player experience"})
            public boolean utPUNExperience = true;
            @Config.Name(value="[05] Display Icon")
            @Config.Comment(value={"Displays the icon of the respective item"})
            public boolean utPUNDisplayIcon = true;
            @Config.Name(value="[06] Display Name")
            @Config.Comment(value={"Displays the name of the respective item"})
            public boolean utPUNDisplayName = true;
            @Config.Name(value="[07] Display Background")
            @Config.Comment(value={"Displays a dark rectangle behind changed items"})
            public boolean utPUNDisplayBackground = false;
            @Config.Name(value="[08] Display Offset Horizontal")
            @Config.Comment(value={"Sets the horizontal offset of the notification"})
            public int utPUNOffsetHorizontal = 0;
            @Config.Name(value="[09] Display Offset Vertical")
            @Config.Comment(value={"Sets the vertical offset of the notification"})
            public int utPUNOffsetVertical = 18;
            @Config.Name(value="[10] Snap Position")
            @Config.Comment(value={"Sets the edge/corner of the screen to use as the base location"})
            public EnumDrawPosition utPUNSnapPosition = EnumDrawPosition.BOTTOM_RIGHT;
            @Config.Name(value="[11] Name Scale")
            @Config.Comment(value={"Sets the scaling of item names"})
            public double utPUNScaleName = 0.8;
            @Config.Name(value="[12] Icon Scale")
            @Config.Comment(value={"Sets the scaling of item icons"})
            public double utPUNScaleIcon = 0.8;
            @Config.Name(value="[13] Soft Limit")
            @Config.Comment(value={"Sets the maximum number of items in the queue before they start fading out artificially"})
            public int utPUNSoftLimit = 6;
            @Config.Name(value="[14] Fade Limit")
            @Config.Comment(value={"Sets the number of items that will be faded out after the soft limit is reached"})
            public int utPUNFadeLimit = 3;
            @Config.Name(value="[15] Display Duration")
            @Config.Comment(value={"Sets the duration in ticks how long the notification will be displayed"})
            public int utPUNDisplayDuration = 120;
            @Config.Name(value="[16] Fade Duration")
            @Config.Comment(value={"Sets the duration in ticks how long the notification fades out"})
            public int utPUNFadeDuration = 20;
            @Config.Name(value="[17] Blacklist: Ignore Item Changes")
            @Config.Comment(value={"List of item registry names to ignore when displaying changes", "Syntax: modid:item"})
            public String[] utPUNBlacklistItem = new String[0];
            @Config.Name(value="[18] Blacklist: Ignore Subitem Changes")
            @Config.Comment(value={"List of item registry names for which to ignore subitem changes", "Syntax: modid:item"})
            public String[] utPUNBlacklistSubitem = new String[0];

            public static enum EnumDrawPosition {
                BOTTOM_RIGHT,
                BOTTOM,
                BOTTOM_LEFT,
                LEFT,
                TOP_LEFT,
                TOP,
                TOP_RIGHT,
                RIGHT,
                CENTER;

            }
        }

        public static class LoadSoundsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Mode")
            @Config.Comment(value={"Play load sound on..."})
            public EnumSoundModes utLoadSoundMode = EnumSoundModes.NOTHING;
            @Config.Name(value="[2] Minecraft Loaded Sounds")
            @Config.Comment(value={"Sounds to play when Minecraft is loaded", "Syntax: eventname;pitch"})
            public String[] utLoadSoundMC = new String[]{"entity.experience_orb.pickup;1.0", "entity.player.levelup;1.0"};
            @Config.Name(value="[3] World Loaded Sounds")
            @Config.Comment(value={"Sounds to play when the world is loaded", "Syntax: eventname;pitch"})
            public String[] utLoadSoundWorld = new String[]{"entity.experience_orb.pickup;1.0", "entity.player.levelup;1.0"};

            public static enum EnumSoundModes {
                NOTHING,
                MINECRAFT,
                WORLD,
                MINECRAFT_AND_WORLD;

            }
        }

        public static class LightningCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Lightning Damage")
            @Config.Comment(value={"Sets the damage lightning bolts deal to entities"})
            public double utLightningDamage = 5.0;
            @Config.RequiresMcRestart
            @Config.Name(value="Lightning Fire Ticks")
            @Config.Comment(value={"Sets the duration in ticks lightning bolts set entities on fire"})
            public int utLightningFireTicks = 8;
            @Config.RequiresMcRestart
            @Config.Name(value="No Lightning Fire")
            @Config.Comment(value={"Disables the creation of fire around lightning strikes"})
            public boolean utLightningFireToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="No Lightning Flash")
            @Config.Comment(value={"Disables the flashing of skybox and ground brightness on lightning bolt strikes"})
            public boolean utLightningFlashToggle = false;
        }

        public static class IncurablePotionsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Incurable Potions Toggle")
            @Config.Comment(value={"Determines if potion effects are curable with curative items like buckets of milk"})
            public boolean utIncurablePotionsToggle = true;
            @Config.Name(value="[2] Potion Effect List")
            @Config.Comment(value={"Syntax: modid:potioneffect"})
            public String[] utIncurablePotionsList = new String[0];
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Potion effects incurable by curative items, others are curable", "Whitelist Mode: Potion effects curable by curative items, others are incurable"})
            public EnumLists utIncurablePotionsListMode = EnumLists.BLACKLIST;
        }
    }

    public static class TweaksItemsCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.attackcooldown")
        @Config.Name(value="Attack Cooldown")
        public final AttackCooldownCategory ATTACK_COOLDOWN = new AttackCooldownCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.itementities")
        @Config.Name(value="Item Entities")
        public final ItemEntitiesCategory ITEM_ENTITIES = new ItemEntitiesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.mending")
        @Config.Name(value="Mending")
        public final MendingCategory MENDING = new MendingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.parry")
        @Config.Name(value="Shield Parry")
        public final ParryCategory PARRY = new ParryCategory();
        @Config.Name(value="Always Eat")
        @Config.Comment(value={"Allows the consumption of food at any time, regardless of the hunger bar"})
        public boolean utAlwaysEatToggle = false;
        @Config.Name(value="Auto Switch Tools")
        @Config.Comment(value={"Switches the selected hotbar slot to a proper tool if required"})
        public boolean utAutoSwitchToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Crafting Repair")
        @Config.Comment(value={"Disables crafting recipes for repairing tools"})
        public boolean utCraftingRepairToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Hardcore Buckets")
        @Config.Comment(value={"Prevents placing of liquid source blocks in the world"})
        public boolean utHardcoreBucketsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Leftover Breath Bottles")
        @Config.Comment(value={"Disables dragon's breath from being a container item and leaving off empty bottles when a stack is brewed with"})
        public boolean utLeftoverBreathBottleToggle = true;
        @Config.Name(value="Bow Infinity")
        @Config.Comment(value={"Bows enchanted with Infinity no longer require arrows"})
        public boolean utBowInfinityToggle = true;
        @Config.Name(value="Custom Rarity")
        @Config.Comment(value={"Sets custom rarities for items, affecting tooltip colors", "Syntax: modid:item:meta;rarity", "'meta' is optional and defaults to 0", "Available rarities: common, uncommon, rare, epic", "Example -> minecraft:diamond;rare"})
        public String[] utCustomRarities = new String[]{"minecraft:dragon_breath;uncommon", "minecraft:elytra;uncommon", "minecraft:experience_bottle;uncommon", "minecraft:nether_star;uncommon", "minecraft:skull:0;uncommon", "minecraft:skull:1;uncommon", "minecraft:skull:2;uncommon", "minecraft:skull:3;uncommon", "minecraft:skull:4;uncommon", "minecraft:skull:5;uncommon", "minecraft:totem_of_undying;uncommon", "minecraft:beacon;rare", "minecraft:end_crystal;rare", "minecraft:barrier;epic", "minecraft:chain_command_block;epic", "minecraft:command_block;epic", "minecraft:command_block_minecart;epic", "minecraft:dragon_egg;epic", "minecraft:knowledge_book;epic", "minecraft:repeating_command_block;epic", "minecraft:structure_block;epic", "minecraft:structure_void;epic", "thaumcraft:thaumium_axe;uncommon", "thaumcraft:thaumium_hoe;uncommon", "thaumcraft:thaumium_pick;uncommon", "thaumcraft:thaumium_shovel;uncommon", "thaumcraft:thaumium_sword;uncommon", "thaumcraft:void_axe;uncommon", "thaumcraft:void_hoe;uncommon", "thaumcraft:void_pick;uncommon", "thaumcraft:void_shovel;uncommon", "thaumcraft:void_sword;uncommon", "thaumcraft:primal_crusher;epic"};
        @Config.RequiresMcRestart
        @Config.Name(value="Custom Use Duration")
        @Config.Comment(value={"Sets custom use durations for items like shields, affecting the maximum block time", "Syntax: modid:item:meta;duration;cooldown", "'meta' and 'cooldown' are optional and default to 0, 'duration' and 'cooldown' in ticks", "Examples -> minecraft:shield;69", "         -> custommod:customshield:1;42;69"})
        public String[] utCustomUseDurations = new String[0];
        @Config.Name(value="Super Hot Torch")
        @Config.Comment(value={"Enables one-time ignition of entities by hitting them with a torch"})
        public boolean utSuperHotTorchToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="XP Bottle Amount")
        @Config.Comment(value={"Sets the amount of experience spawned by bottles o' enchanting", "-1 for vanilla default"})
        public int utXPBottleAmount = -1;

        public static class ParryCategory {
            @Config.Name(value="[01] Shield Parry Toggle")
            @Config.Comment(value={"Allows parrying of projectiles with shields"})
            public boolean utParryToggle = false;
            @Config.Name(value="[02] Arrow Time Window")
            @Config.Comment(value={"Determines the amount of time an arrow can be parried after raising the shield", "Measured in ticks"})
            public int utParryArrowTimeWindow = 40;
            @Config.Name(value="[03] Fireball Time Window")
            @Config.Comment(value={"Determines the amount of time a fireball can be parried after raising the shield", "Measured in ticks"})
            public int utParryFireballTimeWindow = 40;
            @Config.Name(value="[04] Throwable Time Window")
            @Config.Comment(value={"Determines the amount of time a throwable can be parried after raising the shield", "Measured in ticks"})
            public int utParryThrowableTimeWindow = 40;
            @Config.Name(value="[05] Projectile List")
            @Config.Comment(value={"Syntax:  modid:entity", "Example: minecraft:arrow"})
            public String[] utParryProjectileList = new String[0];
            @Config.Name(value="[06] List Mode")
            @Config.Comment(value={"Blacklist Mode: Projectiles which can't be parried, others can be parried", "Whitelist Mode: Projectiles which can be parried, others can't be parried"})
            public EnumLists utParryProjectileListMode = EnumLists.BLACKLIST;
            @Config.Name(value="[07] Indication Sound")
            @Config.Comment(value={"Plays an indication sound effect when projectiles are parried"})
            public boolean utParrySound = false;
            @Config.Name(value="[08] Rebound Enchantment")
            @Config.Comment(value={"Adds the Rebound enchantment for extended parry time windows"})
            public boolean utParryReboundToggle = true;
            @Config.Name(value="[09] Rebound Treasure Enchantment")
            @Config.Comment(value={"Makes the Rebound enchantment exclusive to enchanted books as loot"})
            public boolean utParryReboundTreasure = false;
            @Config.Name(value="[10] Rebound Max Level")
            @Config.Comment(value={"Maximum enchantment level for the Rebound enchantment"})
            public int utParryReboundMaxLevel = 5;
            @Config.Name(value="[11] Rebound Multiplier")
            @Config.Comment(value={"Multiplier for the parry time windows"})
            public double utParryReboundMultiplier = 0.25;
            @Config.Name(value="[12] Require Rebound Enchantment")
            @Config.Comment(value={"Requires the rebound enchantment for parrying"})
            public boolean utParryReboundRequire = false;
        }

        public static class MendingCategory {
            @Config.Name(value="[1] Mending Toggle")
            @Config.Comment(value={"Implements modern mending behavior to only repair damaged equipment with XP"})
            public boolean utMendingToggle = true;
            @Config.Name(value="[2] Ratio")
            @Config.Comment(value={"Determines the amount of durability mending will repair, on average, per point of experience"})
            public double utMendingRatio = 2.0;
            @Config.Name(value="[3] Overpowered")
            @Config.Comment(value={"Repairs damaged items from the entire inventory with XP"})
            public boolean utMendingOPToggle = false;
        }

        public static class ItemEntitiesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Item Entities Toggle")
            @Config.Comment(value={"Enables the modification of item entity properties"})
            public boolean utItemEntitiesToggle = true;
            @Config.Name(value="[02] Physics")
            @Config.Comment(value={"Adds physical aspects such as collision boxes to item entities"})
            public boolean utIEPhysicsToggle = false;
            @Config.Name(value="[03] Automatic Pickup")
            @Config.Comment(value={"Item entities can be picked up automatically", "When disabled, item entities can be picked up by right-clicking (requires 'Physics' option)"})
            public boolean utIEAutomaticPickupToggle = true;
            @Config.Name(value="[04] Sneaking Pickup")
            @Config.Comment(value={"Item entities can only be picked up when sneaking"})
            public boolean utIESneakingPickupToggle = false;
            @Config.Name(value="[05] Collection Tool")
            @Config.Comment(value={"Tools which enable picking up items automatically", "Example -> minecraft:bucket"})
            public String[] utIECollectionTools = new String[0];
            @Config.Name(value="[06] Pickup Delay")
            @Config.Comment(value={"Determines the delay in ticks until item entities can be picked up", "-1 for vanilla default"})
            public int utIEPickupDelay = -1;
            @Config.Name(value="[07] Lifespan")
            @Config.Comment(value={"Determines the time in ticks until item entities get despawned", "-1 for vanilla default"})
            public int utIELifespan = -1;
            @Config.Name(value="[08] No Combination")
            @Config.Comment(value={"Stops combination of item entities"})
            public boolean utIENoCombinationToggle = false;
            @Config.Name(value="[09] Smart Combination")
            @Config.Comment(value={"Stops combination of item entities if their maximum stack size is reached"})
            public boolean utIESmartCombinationToggle = true;
            @Config.Name(value="[10] Smart Combination Radius")
            @Config.Comment(value={"The radius (in blocks) that dropped items should check around them for other dropped items to combine with", "Depends on the Smart Combination toggle"})
            public double utIESmartCombinationRadius = 2.0;
            @Config.Name(value="[11] Smart Combination Y-Axis Check")
            @Config.Comment(value={"Allows dropped items to also check above and below them for combination", "Depends on the Smart Combination toggle"})
            public boolean utIESmartCombinationYAxis = true;
            @Config.Name(value="[12] Rotation")
            @Config.Comment(value={"Enables the rotation effect"})
            public boolean utIERotationToggle = true;
            @Config.Name(value="[13] Bobbing")
            @Config.Comment(value={"Enables the bobbing effect"})
            public boolean utIEBobbingToggle = true;
            @Config.Name(value="[14] Clear Despawn")
            @Config.Comment(value={"Makes item entities flash when they're about to despawn"})
            public boolean utIEClearDespawnToggle = false;
            @Config.Name(value="[15] Clear Despawn: Flashing Time")
            @Config.Comment(value={"Determines the time in seconds item entities have left before despawn to start flashing"})
            public int utIEClearDespawnTime = 20;
            @Config.Name(value="[16] Clear Despawn: Urgent Flashing")
            @Config.Comment(value={"Makes item entities flash faster as they get closer to despawning"})
            public boolean utIEClearDespawnUrgentToggle = true;
        }

        public static class AttackCooldownCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] No Attack Cooldown Toggle")
            @Config.Comment(value={"Disables the 1.9 combat update attack cooldown"})
            public boolean utAttackCooldownToggle = false;
            @Config.Name(value="[2] Only Affect Swords")
            @Config.Comment(value={"Only removes the attack cooldown of swords to balance other weapons like axes"})
            public boolean utAttackCooldownSwords = false;
            @Config.Name(value="[3] Hide Attack Speed Tooltip")
            @Config.Comment(value={"Hides attack speed tooltips of weapons"})
            public boolean utAttackCooldownTooltips = true;
        }
    }

    public static class TweaksEntitiesCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.attributes")
        @Config.Name(value="Attributes")
        public final AttributesCategory ATTRIBUTES = new AttributesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.betterburning")
        @Config.Name(value="Better Burning")
        public final BetterBurningCategory BETTER_BURNING = new BetterBurningCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.collisiondamage")
        @Config.Name(value="Collision Damage")
        public final CollisionDamageCategory COLLISION_DAMAGE = new CollisionDamageCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.damagevelocity")
        @Config.Name(value="Damage Velocity")
        public final DamageVelocityCategory DAMAGE_VELOCITY = new DamageVelocityCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.easybreeding")
        @Config.Name(value="Easy Breeding")
        public final EasyBreedingCategory EASY_BREEDING = new EasyBreedingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.nogolems")
        @Config.Name(value="No Golems")
        public final NoGolemsCategory NO_GOLEMS = new NoGolemsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.playerspeed")
        @Config.Name(value="Player Speed")
        public final PlayerSpeedCategory PLAYER_SPEED = new PlayerSpeedCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.rallyhealth")
        @Config.Name(value="Rally Health")
        public final RallyHealthCategory RALLY_HEALTH = new RallyHealthCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.sleeping")
        @Config.Name(value="Sleeping")
        public final SleepingCategory SLEEPING = new SleepingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.spawncaps")
        @Config.Name(value="Spawn Caps")
        public final SpawnCapsCategory SPAWN_CAPS = new SpawnCapsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.undeadhorses")
        @Config.Name(value="Undead Horses")
        public final UndeadHorsesCategory UNDEAD_HORSES = new UndeadHorsesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.waterfalldamage")
        @Config.Name(value="Water Fall Damage")
        public final WaterFallDamageCategory WATER_FALL_DAMAGE = new WaterFallDamageCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="AI Replacement")
        @Config.Comment(value={"Replaces entity AI for improved server performance"})
        public boolean utAIReplacementToggle = true;
        @Config.Name(value="AI Removal")
        @Config.Comment(value={"Removes entity AI for improved server performance"})
        public boolean utAIRemovalToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Auto Jump Replacement")
        @Config.Comment(value={"Replaces auto jump with an increased step height (singleplayer only)"})
        public boolean utAutoJumpToggle = true;
        @Config.Name(value="Better Ignition")
        @Config.Comment(value={"Enables ignition of entities by right-clicking instead of awkwardly lighting the block under them"})
        public boolean utBetterIgnitionToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Boat Speed")
        @Config.Comment(value={"Sets the acceleration value for controlling boats"})
        public double utBoatSpeed = 0.04;
        @Config.RequiresMcRestart
        @Config.Name(value="Burning Baby Zombies")
        @Config.Comment(value={"Lets baby zombies burn in daylight as in Minecraft 1.13+"})
        public boolean utBurningBabyZombiesToggle = true;
        @Config.Name(value="Creeper Charged Spawning Chance")
        @Config.Comment(value={"Sets the chance for creepers to spawn charged"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utCreeperChargedChance = 0.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Creeper Confetti Spawning Chance")
        @Config.Comment(value={"Sets the chance to replace deadly creeper explosions with delightful confetti"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utCreeperConfettiChance = 0.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Critical Arrow Damage")
        @Config.Comment(value={"Sets the additional damage that critical arrows deal", "-1 for vanilla random default"})
        public int utCriticalArrowDamage = -1;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Creeper Music Discs")
        @Config.Comment(value={"Disables creepers dropping music discs when slain by skeletons"})
        public boolean utCreeperMusicDiscsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Villager Trade Leveling")
        @Config.Comment(value={"Disables leveling of villager careers, only allowing base level trades"})
        public boolean utVillagerTradeLevelingToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Wither Targeting AI")
        @Config.Comment(value={"Disables withers targeting animals"})
        public boolean utWitherAIToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Husk & Stray Spawning")
        @Config.Comment(value={"Lets husks and strays spawn underground like regular zombies and skeletons"})
        public boolean utHuskStraySpawningToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Mob Despawn Improvement")
        @Config.Comment(value={"Mobs carrying picked up items will drop their equipment and despawn properly"})
        public boolean utMobDespawnToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="No Saddled Wandering")
        @Config.Comment(value={"Stops horses wandering around when saddled"})
        public boolean utSaddledWanderingToggle = true;
        @Config.Name(value="Rabbit Killer Spawning Chance")
        @Config.Comment(value={"Sets the chance for rabbits to spawn as the killer bunny variant"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utRabbitKillerChance = 0.0;
        @Config.Name(value="Rabbit Toast Spawning Chance")
        @Config.Comment(value={"Sets the chance for rabbits to spawn as the Toast variant"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utRabbitToastChance = 0.0;

        public static class WaterFallDamageCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Water Fall Damage Toggle")
            @Config.Comment(value={"Re-implements an improved version of pre-1.4 fall damage in water"})
            public boolean utFallDamageToggle = false;
            @Config.Name(value="[2] Damage Reduction")
            @Config.Comment(value={"How much fall damage gets reduced by water per tick"})
            public double utFallDamageValue = 2.0;
        }

        public static class UndeadHorsesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Burning Undead Horses")
            @Config.Comment(value={"Lets untamed undead horses burn in daylight"})
            public boolean utBurningUndeadHorsesToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Taming Undead Horses")
            @Config.Comment(value={"Allows taming of undead horses"})
            public boolean utTamingUndeadHorsesToggle = true;
        }

        public static class SpawnCapsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Spawn Caps Toggle")
            @Config.Comment(value={"Sets maximum spawning limits for different entity types"})
            public boolean utSpawnCapsToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[2] Monster Cap")
            @Config.Comment(value={"Maximum amount of monsters (IMob)"})
            public int utSpawnCapsMonster = 70;
            @Config.RequiresMcRestart
            @Config.Name(value="[3] Creature Cap")
            @Config.Comment(value={"Maximum amount of creatures (EntityAnimal)"})
            public int utSpawnCapsCreature = 10;
            @Config.RequiresMcRestart
            @Config.Name(value="[4] Ambient Cap")
            @Config.Comment(value={"Maximum amount of ambients (EntityAmbientCreature)"})
            public int utSpawnCapsAmbient = 15;
            @Config.RequiresMcRestart
            @Config.Name(value="[5] Water Creature Cap")
            @Config.Comment(value={"Maximum amount of water creatures (EntityWaterMob)"})
            public int utSpawnCapsWaterCreature = 5;
        }

        public static class SleepingCategory {
            @Config.Name(value="Disable Sleeping")
            @Config.Comment(value={"Disables skipping night by using a bed while making it still able to set spawn"})
            public boolean utDisableSleepingToggle = false;
            @Config.Name(value="Sleeping Time")
            @Config.RangeInt(min=-1, max=23999)
            @Config.Comment(value={"Determines at which time of day sleeping is allowed in ticks (0 - 23999)", "-1 for vanilla default"})
            public int utSleepingTime = -1;
        }

        public static class RallyHealthCategory {
            @Config.Name(value="[1] Rally Health Toggle")
            @Config.Comment(value={"Adds Bloodborne's Rally system to Minecraft", "Regain lost health when attacking back within the risk time"})
            public boolean utRallyHealthToggle = false;
            @Config.Name(value="[2] Risk Time")
            @Config.Comment(value={"Determines the risk time in ticks"})
            public int utRallyHealthRiskTime = 60;
            @Config.Name(value="[3] Heal Chance")
            @Config.Comment(value={"Determines the chance to regain health in percent"})
            public int utRallyHealthHealChance = 80;
            @Config.Name(value="[4] Indication Sound")
            @Config.Comment(value={"Plays an indication sound effect when health is regained"})
            public boolean utRallyHealthSound = false;
        }

        public static class PlayerSpeedCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Player Speed Toggle")
            @Config.Comment(value={"Enables the modification of base and maximum player speeds"})
            public boolean utPlayerSpeedToggle = false;
            @Config.Name(value="[2] Walk Speed")
            @Config.Comment(value={"Determines the player's base walk speed"})
            public double utPlayerWalkSpeed = 0.1;
            @Config.Name(value="[3] Fly Speed")
            @Config.Comment(value={"Determines the player's base fly speed"})
            public double utPlayerFlySpeed = 0.05;
            @Config.Name(value="[4] Max Speed")
            @Config.Comment(value={"Determines the player's maximum speed", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerMaxSpeed = 100.0;
            @Config.Name(value="[5] Max Elytra Speed")
            @Config.Comment(value={"Determines the player's maximum speed when flying with elytra", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerMaxElytraSpeed = 300.0;
            @Config.Name(value="[6] Max Vehicle Speed")
            @Config.Comment(value={"Determines the player's maximum speed when riding a vehicle or mount", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerVehicleSpeed = 100.0;
        }

        public static class NoGolemsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Iron Golem Toggle")
            @Config.Comment(value={"Disables the manual creation of iron golems"})
            public boolean utNGIronGolemToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[2] Snow Golem Toggle")
            @Config.Comment(value={"Disables the manual creation of snow golems"})
            public boolean utNGSnowGolemToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[3] Wither Toggle")
            @Config.Comment(value={"Disables the manual creation of withers"})
            public boolean utNGWitherToggle = false;
        }

        public static class DamageVelocityCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Damage Velocity Toggle")
            @Config.Comment(value={"Enables the modification of damage sources that change the entity's velocity"})
            public boolean utDamageVelocityToggle = false;
            @Config.Name(value="[2] Damage Velocity List")
            @Config.Comment(value={"Syntax: damagetype"})
            public String[] utDamageVelocityList = new String[]{"inFire", "onFire"};
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Damage sources that don't change velocity, others do", "Whitelist Mode: Damage sources that change velocity, others don't"})
            public EnumLists utDamageVelocityListMode = EnumLists.BLACKLIST;
        }

        public static class CollisionDamageCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Collision Damage Toggle")
            @Config.Comment(value={"Applies horizontal collision damage to the player akin to elytra collision"})
            public boolean utCollisionDamageToggle = false;
            @Config.Name(value="[2] Damage Factor")
            @Config.Comment(value={"The damage factor that gets multiplied with the player speed", "Vanilla default for elytra damage is 10"})
            public int utCollisionDamageFactor = 10;
        }

        public static class EasyBreedingCategory {
            @Config.Name(value="[1] Easy Breeding Toggle")
            @Config.Comment(value={"Enables easy breeding of animals by tossing food on the ground"})
            public boolean utEasyBreedingToggle = false;
            @Config.Name(value="[2] Search Distance")
            @Config.Comment(value={"Determines the distance for animals to search for food"})
            public double utEasyBreedingDistance = 10.0;
        }

        public static class BetterBurningCategory {
            @Config.Name(value="[1] Cooked Items")
            @Config.Comment(value={"Fixes some edge cases where fire damage sources won't cause mobs to drop their cooked items"})
            public boolean utBBCookedToggle = true;
            @Config.Name(value="[2] Extinguishing")
            @Config.Comment(value={"If entities have fire resistance, they get extinguished right away when on fire"})
            public boolean utBBExtinguishToggle = true;
            @Config.Name(value="[3] Fire Overlay")
            @Config.Comment(value={"Prevents the fire animation overlay from being displayed when the player is immune to fire"})
            public boolean utBBOverlayToggle = true;
            @Config.Name(value="[4] Flaming Arrows")
            @Config.Comment(value={"Allows skeletons to shoot flaming arrows when on fire (30% chance * regional difficulty)"})
            public boolean utBBArrowsToggle = true;
            @Config.Name(value="[5] Spreading Fire")
            @Config.Comment(value={"Allows fire to spread from entity to entity (30% chance * regional difficulty)"})
            public boolean utBBSpreadingToggle = true;
        }

        public static class AttributesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Attributes Toggle")
            @Config.Comment(value={"Sets custom ranges for entity attributes"})
            public boolean utAttributesToggle = true;
            @Config.Name(value="[02] Max Health Min")
            public double utAttributeMaxHealthMin = -65536.0;
            @Config.Name(value="[03] Max Health Max")
            public double utAttributeMaxHealthMax = 65536.0;
            @Config.Name(value="[04] Follow Range Min")
            public double utAttributeFollowRangeMin = -65536.0;
            @Config.Name(value="[05] Follow Range Max")
            public double utAttributeFollowRangeMax = 65536.0;
            @Config.Name(value="[06] Knockback Resistance Min")
            public double utAttributeKnockbackResistanceMin = -65536.0;
            @Config.Name(value="[07] Knockback Resistance Max")
            public double utAttributeKnockbackResistanceMax = 65536.0;
            @Config.Name(value="[08] Movement Speed Min")
            public double utAttributeMovementSpeedMin = -65536.0;
            @Config.Name(value="[09] Movement Speed Max")
            public double utAttributeMovementSpeedMax = 65536.0;
            @Config.Name(value="[10] Flying Speed Min")
            public double utAttributeFlyingSpeedMin = -65536.0;
            @Config.Name(value="[11] Flying Speed Max")
            public double utAttributeFlyingSpeedMax = 65536.0;
            @Config.Name(value="[12] Attack Damage Min")
            public double utAttributeAttackDamageMin = -65536.0;
            @Config.Name(value="[13] Attack Damage Max")
            public double utAttributeAttackDamageMax = 65536.0;
            @Config.Name(value="[14] Attack Speed Min")
            public double utAttributeAttackSpeedMin = -65536.0;
            @Config.Name(value="[15] Attack Speed Max")
            public double utAttributeAttackSpeedMax = 65536.0;
            @Config.Name(value="[16] Armor Min")
            public double utAttributeArmorMin = -65536.0;
            @Config.Name(value="[17] Armor Max")
            public double utAttributeArmorMax = 65536.0;
            @Config.Name(value="[18] Armor Toughness Min")
            public double utAttributeArmorToughnessMin = -65536.0;
            @Config.Name(value="[19] Armor Toughness Max")
            public double utAttributeArmorToughnessMax = 65536.0;
            @Config.Name(value="[20] Luck Min")
            public double utAttributeLuckMin = -65536.0;
            @Config.Name(value="[21] Luck Max")
            public double utAttributeLuckMax = 65536.0;
        }
    }

    public static class TweaksBlocksCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.betterplacement")
        @Config.Name(value="Better Placement")
        public final BetterPlacementCategory BETTER_PLACEMENT = new BetterPlacementCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.blockdispenser")
        @Config.Name(value="Block Dispenser")
        public final BlockDispenserCategory BLOCK_DISPENSER = new BlockDispenserCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.breakablebedrock")
        @Config.Name(value="Breakable Bedrock")
        public final BreakableBedrockCategory BREAKABLE_BEDROCK = new BreakableBedrockCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.finitewater")
        @Config.Name(value="Finite Water")
        public final FiniteWaterCategory FINITE_WATER = new FiniteWaterCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Bed Obstruction Replacement")
        @Config.Comment(value={"Replaces bed obstruction checks with an improved version"})
        public boolean utBedObstructionToggle = true;
        @Config.Name(value="Better Harvest")
        @Config.Comment(value={"Prevents breaking lower parts of sugar cane and cacti as well as unripe crops, unless sneaking"})
        public boolean utBetterHarvestToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Block Hit Delay")
        @Config.Comment(value={"Sets the delay in ticks between breaking blocks"})
        public int utBlockHitDelay = 5;
        @Config.RequiresMcRestart
        @Config.Name(value="Cactus Size")
        @Config.Comment(value={"Determines how tall cacti can grow"})
        public int utCactusSize = 3;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast Leaf Decay")
        @Config.Comment(value={"Makes leaves decay faster when trees are chopped"})
        public boolean utLeafDecayToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fence/Wall Jump")
        @Config.Comment(value={"Allows the player to jump over fences and walls"})
        public boolean utFenceWallJumpToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Lenient Paths")
        @Config.Comment(value={"Allows the creation of grass paths everywhere (beneath fence gates, trapdoors, ...)"})
        public boolean utLenientPathsToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Sugar Cane Size")
        @Config.Comment(value={"Determines how tall sugar cane can grow"})
        public int utSugarCaneSize = 3;
        @Config.RequiresMcRestart
        @Config.Name(value="Vine Size")
        @Config.Comment(value={"Determines how long vines can grow", "0 = Infinite (vanilla default)"})
        public int utVineSize = 0;

        public static class FiniteWaterCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Finite Water Toggle")
            @Config.Comment(value={"Prevents creation of infinite water sources"})
            public boolean utFiniteWaterToggle = false;
            @Config.Name(value="[2] Allow Water Biomes")
            @Config.Comment(value={"Allows creation of infinite water sources in ocean and river biomes"})
            public boolean utFiniteWaterWaterBiomes = true;
            @Config.Name(value="[3] Minimum Altitude")
            @Config.Comment(value={"Inclusive minimum altitude at which water is infinite"})
            public int utFiniteWaterInfMin = 0;
            @Config.Name(value="[4] Maximum Altitude")
            @Config.Comment(value={"Inclusive maximum altitude at which water is infinite"})
            public int utFiniteWaterInfMax = 63;
        }

        public static class BreakableBedrockCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Breakable Bedrock Toggle")
            @Config.Comment(value={"Allows customizable mining of bedrock"})
            public boolean utBreakableBedrockToggle = false;
            @Config.Name(value="[2] Tool List")
            @Config.Comment(value={"List of tools concerning mining bedrock", "Behavior depends on the list mode", "Syntax: modid:tool"})
            public String[] utBreakableBedrockToolList = new String[0];
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Tools which can't mine bedrock, others can", "Whitelist Mode: Tools which can mine bedrock, others can't"})
            public EnumLists utBreakableBedrockToolListMode = EnumLists.BLACKLIST;
        }

        public static class BlockDispenserCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Block Dispenser Toggle")
            @Config.Comment(value={"Allows dispensers to place blocks"})
            public boolean utBlockDispenserToggle = true;
            @Config.Name(value="[2] Block List")
            @Config.Comment(value={"List of blocks concerning dispensing", "Behavior depends on the list mode", "Syntax: modid:block"})
            public String[] utBlockDispenserBlockList = new String[]{"minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:flowing_lava", "minecraft:fire", "minecraft:web", "botania:specialflower", "thermalexpansion:strongbox"};
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Blocks which can't be placed, others can", "Whitelist Mode: Blocks which can be placed, others can't"})
            public EnumLists utBlockDispenserBlockListMode = EnumLists.BLACKLIST;
        }

        public static class BetterPlacementCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Better Placement Toggle")
            @Config.Comment(value={"Removes the delay between placing blocks"})
            public boolean utBetterPlacementToggle = false;
            @Config.Name(value="[2] Force New Location")
            @Config.Comment(value={"If the cursor must be moved to a new location before placing another block"})
            public boolean utBetterPlacementNewLoc = true;
            @Config.Name(value="[3] Creative Mode Only")
            @Config.Comment(value={"Only affects block placement in creative mode"})
            public boolean utBetterPlacementCreative = false;
        }
    }

    public static class BugfixesWorldCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Chunk Saving")
        @Config.Comment(value={"Fixes loading of outdated chunks to prevent duplications, deletions and data corruption", "Incompatible with SpongeForge"})
        public boolean utChunkSavingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Frustum Culling")
        @Config.Comment(value={"Fixes invisible chunks in edge cases (small enclosed rooms at chunk borders)"})
        public boolean utFrustumCullingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Tile Entity Map")
        @Config.Comment(value={"Changes the data table of tile entities to resolve issues", "HASHMAP:                   Vanilla default", "LINKED_HASHMAP:            Keeps the loading order of tile entities to prevent issues during the first ticks of chunk loading", "CONCURRENT_HASHMAP:        Allows simultaneous access to tile entities to prevent concurrent modification exceptions", "CONCURRENT_LINKED_HASHMAP: Combines LINKED_HASHMAP and CONCURRENT_HASHMAP, may have random side effects"})
        public EnumMaps utTileEntityMap = EnumMaps.LINKED_HASHMAP;

        public static enum EnumMaps {
            HASHMAP,
            LINKED_HASHMAP,
            CONCURRENT_HASHMAP,
            CONCURRENT_LINKED_HASHMAP;

        }
    }

    public static class BugfixesMiscCategory {
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.misc.modelgap")
        @Config.Name(value="Model Gap")
        public final ModelGapCategory MODEL_GAP = new ModelGapCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Accurate Smooth Lighting")
        @Config.Comment(value={"Improves the accuracy of smooth lighting by checking for suffocation and light opacity"})
        public boolean utAccurateSmoothLighting = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Depth Mask")
        @Config.Comment(value={"Fixes entity and particle rendering issues by enabling depth buffer writing"})
        public boolean utDepthMaskToggle = true;
        @Config.Name(value="Help Command")
        @Config.Comment(value={"Replaces the help command, sorts and reports broken commands"})
        public boolean utHelpToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Locale Crash")
        @Config.Comment(value={"Prevents various crashes with Turkish locale"})
        public boolean utLocaleToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Packet Size")
        @Config.Comment(value={"Increases the packet size limit to account for large packets in modded environments", "Vanilla default is 0x200000", "Incompatible with SpongeForge and RandomPatches"})
        public int utPacketSize = 0x1000000;

        public static class ModelGapCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Model Gap Toggle")
            @Config.Comment(value={"Fixes transparent gaps in all 3D models of blocks and items"})
            public boolean utModelGapToggle = true;
            @Config.Name(value="[2] Recess Value")
            @Config.Comment(value={"Quad X/Y offset", "Moves the quad toward the center of the item", "Use to hide gaps, keep as close to 0 as possible"})
            public double utModelGapRecess = 0.007;
            @Config.Name(value="[3] Expansion Value")
            @Config.Comment(value={"Quad expansion increment", "Enlarges each quad", "Use to hide gaps, keep as close to 0 as possible"})
            public double utModelGapExpansion = 0.008;
        }
    }

    public static class BugfixesEntitiesCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Attack Radius")
        @Config.Comment(value={"Improves the attack radius of hostile mobs by checking the line of sight with raytracing"})
        public boolean utAttackRadiusToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Block Fire")
        @Config.Comment(value={"Prevents fire projectiles burning entities when blocking with shields"})
        public boolean utBlockFireToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Boat Riding Offset")
        @Config.Comment(value={"Fixes entities glitching through the bottom of boats"})
        public boolean utBoatOffsetToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Concurrent Entity AI Tasks")
        @Config.Comment(value={"Replaces linked entity AI task sets with concurrent sets to avoid mod exception concerning entity AI", "Only enable this if you're facing concurrent modification exceptions with entity AI tasks, for example Thaumcraft's Pechs"})
        public boolean utEntityAITasksToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Death Time")
        @Config.Comment(value={"Fixes corrupted entities exceeding the allowed death time"})
        public boolean utDeathTimeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Destroy Entity Packets")
        @Config.Comment(value={"Fixes lag caused by dead entities by sending additional packets when the player is not alive"})
        public boolean utDestroyPacketToggle = true;
        @Config.Name(value="Disconnect Dupe")
        @Config.Comment(value={"Fixes item duplications when players are dropping items and disconnecting"})
        public boolean utDisconnectDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Dimension Change Player States")
        @Config.Comment(value={"Fixes missing player states when changing dimensions by sending additional packets"})
        public boolean utDimensionChangeToggle = true;
        @Config.Name(value="Double Consumption")
        @Config.Comment(value={"Fixes consuming an item having a chance of also consuming a second item without any animation"})
        public boolean utDoubleConsumptionToggle = true;
        @Config.Name(value="Donkey/Mule Dupe")
        @Config.Comment(value={"Fixes a duplication exploit connected to the inventories of donkeys and mules"})
        public boolean utDonkeyMuleDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Elytra Deployment & Landing")
        @Config.Comment(value={"Relocate elytra deployment and landing to client side to prevent issues with high latencies"})
        public boolean utElytraDeploymentLandingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Bounding Box")
        @Config.Comment(value={"Saves entity bounding boxes to tags to prevent breakouts and suffocation"})
        public boolean utEntityAABBToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Desync")
        @Config.Comment(value={"Fixes entity motion desyncs most notable with arrows and thrown items"})
        public boolean utEntityDesyncToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity ID")
        @Config.Comment(value={"Fixes non-functional elytra firework boosting and guardian targeting if the entity ID is 0"})
        public boolean utEntityIDToggle = true;
        @Config.Name(value="Entity NaN Values")
        @Config.Comment(value={"Prevents corruption of entities caused by invalid health or damage values"})
        public boolean utEntityNaNToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Suffocation")
        @Config.Comment(value={"Pushes entities out of blocks when growing up to prevent suffocation"})
        public boolean utEntitySuffocationToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Entity Tracker")
        @Config.Comment(value={"Fixes entity tracker to prevent client-sided desyncs when teleporting or changing dimensions", "Incompatible with SpongeForge"})
        public boolean utEntityTrackerToggle = true;
        @Config.Name(value="Entity UUID")
        @Config.Comment(value={"Changes UUIDs of loaded entities in case their UUIDs are already assigned (and removes log spam)"})
        public boolean utEntityUUIDToggle = true;
        @Config.Name(value="Horse Falling")
        @Config.Comment(value={"Modifies falling logic of horses, listening to LivingFallEvent and taking jump boost into account"})
        public boolean utHorseFallingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Max Player Health")
        @Config.Comment(value={"Corrects maximum player health on joining by setting the last saved health value"})
        public boolean utMaxHealthToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Mount Desync")
        @Config.Comment(value={"Fixes mounts and boats sometimes disappearing after dismounting"})
        public boolean utMountDesyncToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Player Saturation")
        @Config.Comment(value={"Fixes saturation depleting in peaceful mode"})
        public boolean utExhaustionToggle = true;
        @Config.Name(value="Shear Mooshroom Dupe")
        @Config.Comment(value={"Fixes a duplication exploit connected to shearing mooshrooms"})
        public boolean utShearMooshroomDupeToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Skeleton Aim")
        @Config.Comment(value={"Fixes skeletons not looking at their targets when strafing"})
        public boolean utSkeletonAimToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Villager Mantle Hoods")
        @Config.Comment(value={"Returns missing hoods to villager mantles"})
        public boolean utVillagerMantleToggle = true;
    }

    public static class BugfixesBlocksCategory {
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.blocks.blockoverlay")
        @Config.Name(value="Block Overlay")
        public final BlockOverlayCategory BLOCK_OVERLAY = new BlockOverlayCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Banner Bounding Box")
        @Config.Comment(value={"Fixes rendering issues with banners by correctly sizing their render bounding boxes"})
        public boolean utBannerBoundingBoxToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Comparator Timing")
        @Config.Comment(value={"Fixes inconsistent delays of comparators to prevent redstone timing issues"})
        public boolean utComparatorTimingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Falling Block Entity Damage")
        @Config.Comment(value={"Only damage living entities hit by falling blocks, prevents killing items and XP"})
        public boolean utFallingBlockDamageToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Hopper Bounding Box")
        @Config.Comment(value={"Slims down the hopper bounding box for easier access of nearby blocks"})
        public boolean utDietHopperToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Hopper Insert Safety Check")
        @Config.Comment(value={"Prevents crashes when the destination tile entity becomes unavailable during the item insert process", "Mainly utilized to suppress edge case symptoms with Thaumcraft's Thaumatorium"})
        public boolean utHopperInsertToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Item Frame Void")
        @Config.Comment(value={"Prevents voiding held items when right + left clicking on an item frame simultaneously"})
        public boolean utItemFrameVoidToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Ladder Flying Slowdown")
        @Config.Comment(value={"Disables climbing movement when flying"})
        public boolean utLadderFlyingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Mining Glitch")
        @Config.Comment(value={"Avoids the need for multiple mining attempts by sending additional movement packets"})
        public boolean utMiningGlitchToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Piston Progress")
        @Config.Comment(value={"Properly saves the last state of pistons to tags"})
        public boolean utPistonTileToggle = true;

        public static class BlockOverlayCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Block Overlay Toggle")
            @Config.Comment(value={"Fixes x-ray when standing in non-suffocating blocks"})
            public boolean utBlockOverlayToggle = true;
            @Config.Name(value="[2] Blacklist")
            @Config.Comment(value={"Excludes blocks from the block overlay bugfix", "Syntax: modid:block"})
            public String[] utBlockOverlayBlacklist = new String[0];
            @Config.Name(value="[3] Whitelist")
            @Config.Comment(value={"Includes blocks in the block overlay bugfix", "Syntax: modid:block"})
            public String[] utBlockOverlayWhitelist = new String[0];
        }
    }

    public static enum EnumDifficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

    }

    public static enum EnumLists {
        WHITELIST,
        BLACKLIST;

    }
}

