/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.mining_enhancement;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IBlockBreakingModule;
import net.machinemuse.numina.common.module.IMiningEnhancementModule;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.common.utils.MusePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;

public class AOEPickUpgradeModule
extends PowerModuleBase
implements IMiningEnhancementModule {
    public AOEPickUpgradeModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)1));
        this.addBasePropertyDouble("aoeEnergyCon", 500.0, "RF");
        this.addTradeoffPropertyDouble("diameter", "aoeEnergyCon", 9500.0);
        this.addIntTradeoffProperty("diameter", "aoeMiningDiameter", 5, "m", 2, 1);
    }

    public boolean onBlockStartBreak(ItemStack itemStack, BlockPos posIn, EntityPlayer player) {
        Iterable posList;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        RayTraceResult rayTraceResult = MusePlayerUtils.raytraceBlocks(player.field_70170_p, player, true, 10.0);
        if (rayTraceResult == null) {
            return false;
        }
        int radius = (int)(ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "aoeMiningDiameter") - 1.0) / 2;
        if (radius == 0) {
            return false;
        }
        EnumFacing side = rayTraceResult.field_178784_b;
        switch (side) {
            case UP: 
            case DOWN: {
                posList = BlockPos.func_177980_a((BlockPos)posIn.func_177964_d(radius).func_177985_f(radius), (BlockPos)posIn.func_177970_e(radius).func_177965_g(radius));
                break;
            }
            case EAST: 
            case WEST: {
                posList = BlockPos.func_177980_a((BlockPos)posIn.func_177981_b(radius).func_177964_d(radius), (BlockPos)posIn.func_177979_c(radius).func_177970_e(radius));
                break;
            }
            case NORTH: 
            case SOUTH: {
                posList = BlockPos.func_177980_a((BlockPos)posIn.func_177981_b(radius).func_177985_f(radius), (BlockPos)posIn.func_177979_c(radius).func_177965_g(radius));
                break;
            }
            default: {
                posList = new ArrayList();
            }
        }
        int energyUsage = this.getEnergyUsage(itemStack);
        boolean harvested = false;
        block5: for (BlockPos blockPos : posList) {
            IBlockState state = player.field_70170_p.func_180495_p(blockPos).func_185899_b((IBlockAccess)player.field_70170_p, blockPos);
            Block block = state.func_177230_c();
            for (IPowerModule module : ModuleManager.INSTANCE.getModulesOfType(IBlockBreakingModule.class)) {
                int playerEnergy = ElectricItemUtils.getPlayerEnergy((EntityPlayer)player);
                if (!ModuleManager.INSTANCE.itemHasActiveModule(itemStack, module.getDataName()) || !((IBlockBreakingModule)module).canHarvestBlock(itemStack, state, player, blockPos, playerEnergy - energyUsage) || !block.removedByPlayer(state, player.field_70170_p, blockPos, player, true)) continue;
                if (posIn == blockPos) {
                    harvested = true;
                }
                block.func_176206_d(player.field_70170_p, blockPos, state);
                block.func_180657_a(player.field_70170_p, player, blockPos, state, player.field_70170_p.func_175625_s(blockPos), player.func_184614_ca());
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)(((IBlockBreakingModule)module).getEnergyUsage(itemStack) + energyUsage));
                continue block5;
            }
        }
        return harvested;
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "aoeEnergyCon");
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MINING_ENHANCEMENT;
    }

    public String getDataName() {
        return "aoePickUpgrade";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.aoePickUpgrade;
    }
}

