/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.network.packets;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.machinemuse.numina.common.network.MuseByteBufferUtils;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketTweakRequestDouble
implements IMessage {
    EntityPlayer player;
    int itemSlot;
    String moduleName;
    String tweakName;
    double tweakValue;

    public MusePacketTweakRequestDouble() {
    }

    public MusePacketTweakRequestDouble(EntityPlayer player, int itemSlot, String moduleName, String tweakName, double tweakValue) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.moduleName = moduleName;
        this.tweakName = tweakName;
        this.tweakValue = tweakValue;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemSlot = buf.readInt();
        this.moduleName = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
        this.tweakName = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
        this.tweakValue = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemSlot);
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleName);
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.tweakName);
        buf.writeDouble(this.tweakValue);
    }

    public static class Handler
    implements IMessageHandler<MusePacketTweakRequestDouble, IMessage> {
        public IMessage onMessage(MusePacketTweakRequestDouble message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    ItemStack stack;
                    NBTTagCompound itemTag;
                    int itemSlot = message.itemSlot;
                    String moduleName = message.moduleName;
                    String tweakName = message.tweakName;
                    double tweakValue = message.tweakValue;
                    if (moduleName != null && tweakName != null && (itemTag = MuseNBTUtils.getMuseItemTag((ItemStack)(stack = player.field_71071_by.func_70301_a(itemSlot)))) != null && ModuleManager.INSTANCE.tagHasModule(itemTag, moduleName)) {
                        MuseNBTUtils.removeMuseValuesTag((ItemStack)stack);
                        NBTTagCompound moduleTag = itemTag.func_74775_l(moduleName);
                        moduleTag.func_74780_a(tweakName, tweakValue);
                    }
                });
            }
            return null;
        }
    }
}

