/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.item.armor;

import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.heat.MuseHeatUtils;
import net.machinemuse.numina.common.item.IArmorTraits;
import net.machinemuse.powersuits.client.model.item.armor.ArmorModelInstance;
import net.machinemuse.powersuits.client.model.item.armor.IArmorModel;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.capabilities.MPSCapProvider;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.common.item.armor.ItemElectricArmor;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.common.utils.nbt.MPSNBTUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemPowerArmor
extends ItemElectricArmor
implements ISpecialArmor,
IArmorTraits {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};

    public ItemPowerArmor(String regName, String unlocalizedName, int renderIndex, EntityEquipmentSlot entityEquipmentSlot) {
        super(ItemArmor.ArmorMaterial.IRON, renderIndex, entityEquipmentSlot);
        this.setRegistryName(regName);
        this.func_77655_b("powersuits" + "." + unlocalizedName);
        this.func_77625_d(1);
        this.func_77637_a(MPSConfig.mpsCreativeTab);
        this.func_77656_e(0);
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == null || source == MuseHeatUtils.overheatDamage) {
            return false;
        }
        if (source.field_76373_n.equals("electricity") || source.field_76373_n.equals("radiation") || source.field_76373_n.equals("sulphuric_acid")) {
            return ModuleManager.INSTANCE.itemHasModule(armor, "hazmat");
        }
        if (source.func_76355_l().equals("pressure")) {
            if (slot == 3) {
                return ModuleManager.INSTANCE.itemHasModule(armor, "airtightSeal") && ModuleManager.INSTANCE.itemHasModule(armor, "hazmat");
            }
            return ModuleManager.INSTANCE.itemHasModule(armor, "hazmat");
        }
        if (source.func_76355_l().equals("cryotheum")) {
            return MuseHeatUtils.getPlayerHeat((EntityPlayer)((EntityPlayer)entity)) > 0.0;
        }
        return false;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            DamageSource overheatDamage = MuseHeatUtils.overheatDamage;
            if (source.func_76355_l().equals("cryotheum") && entity.field_70170_p.field_72995_K) {
                MuseHeatUtils.coolPlayer((EntityPlayer)player, (double)(damage * 10));
            }
            if (source.func_76347_k()) {
                MuseHeatUtils.heatPlayer((EntityPlayer)player, (double)(damage * 5));
            } else {
                double enerConsum = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "armorEnergyPerDamage");
                double drain = enerConsum * (double)damage;
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)((EntityPlayer)entity), (int)((int)drain));
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorbRatio = 0.25;
        int absorbMax = (int)(25.0 * damage);
        int priority = 0;
        if (source.func_76347_k() && !source.equals(MuseHeatUtils.overheatDamage)) {
            return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
        }
        if (ModuleManager.INSTANCE.itemHasModule(armor, "hazmat") && (source.field_76373_n.equals("electricity") || source.field_76373_n.equals("radiation") || source.field_76373_n.equals("sulphuric_acid"))) {
            return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
        }
        double armorDouble = player instanceof EntityPlayer ? this.getArmorDouble((EntityPlayer)player, armor) : 2.0;
        absorbMax = (int)armorDouble * 75;
        if (source.func_76363_c()) {
            absorbMax = 0;
            absorbRatio = 0.0;
        } else {
            absorbRatio = 0.04 * armorDouble;
        }
        return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], SharedMonsterAttributes.field_111266_c.func_111108_a(), 0.25, 0));
            if (ModuleManager.INSTANCE.itemHasActiveModule(stack, "diamondPlating") || ModuleManager.INSTANCE.itemHasActiveModule(stack, "energyShield")) {
                multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", 2.5, 0));
            }
        }
        return multimap;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)this.getArmorDouble(player, armor);
    }

    @Override
    public double getArmorDouble(EntityPlayer player, ItemStack stack) {
        double totalArmor = 0.0;
        double energy = ElectricItemUtils.getPlayerEnergy((EntityPlayer)player);
        double physArmor = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "armorPhysical");
        double enerArmor = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "armorEnergy");
        double enerConsum = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(stack, "armorEnergyPerDamage");
        totalArmor += physArmor;
        if (energy > enerConsum) {
            totalArmor += enerArmor;
        }
        totalArmor = Math.min(MPSConfig.INSTANCE.getMaximumArmorPerPiece(), totalArmor);
        return totalArmor;
    }

    @Optional.Method(modid="forestry")
    public boolean protectEntity(EntityLivingBase player, ItemStack armor, String cause, boolean doProtect) {
        if (ModuleManager.INSTANCE.itemHasActiveModule(armor, "apiaristArmor")) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)((EntityPlayer)player), (int)((int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(armor, "apiaristArmorEnergyCon")));
            return true;
        }
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int capacity = 0;
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            capacity = energyStorage.getMaxEnergyStored();
        }
        return capacity > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return 1.0f - (energyStorage != null ? (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored() : 0.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new MPSCapProvider(stack);
    }

    @Override
    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public String getArmorTexture(ItemStack armor, Entity entity, EntityEquipmentSlot slot, String type) {
        if (type == "overlay") {
            return "powersuits:textures/items/armor/blankarmor.png";
        }
        if (armor.func_77973_b() instanceof ItemPowerArmor) {
            if (slot == EntityEquipmentSlot.CHEST && ModuleManager.INSTANCE.itemHasActiveModule(armor, "invisibility") || ModuleManager.INSTANCE.itemHasActiveModule(armor, "transparentArmor")) {
                return "powersuits:textures/items/armor/blankarmor.png";
            }
            return MPSNBTUtils.getArmorTexture(armor, slot);
        }
        return "powersuits:textures/items/armor/blankarmor.png";
    }

    @Override
    public boolean hasOverlay(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack armor, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ItemStack chestPlate;
        if (!MPSNBTUtils.hasHighPolyModel(armor, armorSlot)) {
            return _default;
        }
        ModelBiped model = ArmorModelInstance.getInstance();
        ((IArmorModel)model).setVisibleSection(armorSlot);
        ItemStack itemStack = chestPlate = armorSlot == EntityEquipmentSlot.CHEST ? armor : entityLiving.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestPlate.func_77973_b() instanceof ItemPowerArmorChestplate && ModuleManager.INSTANCE.itemHasActiveModule(chestPlate, "transparentArmor") || armorSlot == EntityEquipmentSlot.CHEST && ModuleManager.INSTANCE.itemHasActiveModule(chestPlate, "invisibility")) {
            ((IArmorModel)model).setVisibleSection(null);
        } else {
            ((IArmorModel)model).setRenderSpec(MPSNBTUtils.getMuseRenderTag(armor, armorSlot));
        }
        return model;
    }
}

