/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.base;

import javax.annotation.Nonnull;
import net.machinemuse.powersuits.client.gui.cosmetic.CosmeticGui;
import net.machinemuse.powersuits.client.gui.crafting.PortableCraftingGui;
import net.machinemuse.powersuits.client.gui.keybinds.KeyConfigGui;
import net.machinemuse.powersuits.client.gui.module.selection.GuiModeSelector;
import net.machinemuse.powersuits.client.gui.module.tinker.GuiFieldTinker;
import net.machinemuse.powersuits.client.gui.module.tinker.GuiTinkerTable;
import net.machinemuse.powersuits.client.gui.scanner.ScannerGUI;
import net.machinemuse.powersuits.common.container.PortableCraftingContainer;
import net.machinemuse.powersuits.common.container.ScannerContainer;
import net.machinemuse.powersuits.common.item.tool.ItemPowerFist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum MPSGuiHandler implements IGuiHandler
{
    INSTANCE;


    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 4) {
            return new PortableCraftingContainer(player.field_71071_by, world, new BlockPos(x, y, z));
        }
        if (ID == 6) {
            return new ScannerContainer(player, this.getPlayerHand(player));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                return new GuiTinkerTable(player, x, y, z);
            }
            case 1: {
                return new KeyConfigGui(player, x, y, z);
            }
            case 2: {
                return new GuiFieldTinker(player);
            }
            case 3: {
                return new CosmeticGui(player, x, y, z);
            }
            case 4: {
                return new PortableCraftingGui(player, world, new BlockPos(x, y, z));
            }
            case 5: {
                return new GuiModeSelector(player);
            }
            case 6: {
                return new ScannerGUI(new ScannerContainer(player, this.getPlayerHand(player)));
            }
        }
        return null;
    }

    @Nonnull
    EnumHand getPlayerHand(EntityPlayer player) {
        EnumHand hand = player.func_184600_cs();
        if (hand == null) {
            ItemStack held = player.func_184614_ca();
            if (!held.func_190926_b() && held.func_77973_b() instanceof ItemPowerFist) {
                return EnumHand.MAIN_HAND;
            }
            return EnumHand.OFF_HAND;
        }
        return hand;
    }
}

