/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.module.tinker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.client.gui.clickable.ClickableItem;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.machinemuse.numina.common.nbt.propertymodifier.IPropertyModifier;
import net.machinemuse.numina.common.nbt.propertymodifier.PropertyModifierLinearAdditiveDouble;
import net.machinemuse.numina.common.string.MuseStringUtils;
import net.machinemuse.powersuits.client.gui.common.ClickableTinkerSlider;
import net.machinemuse.powersuits.client.gui.common.ItemSelectionFrame;
import net.machinemuse.powersuits.client.gui.module.tinker.ModuleSelectionFrame;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.network.MPSPackets;
import net.machinemuse.powersuits.common.network.packets.MusePacketTweakRequestDouble;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class ModuleTweakFrame
extends ScrollableFrame {
    protected static double SCALERATIO = 0.75;
    protected static int margin = 4;
    protected ItemSelectionFrame itemTarget;
    protected ModuleSelectionFrame moduleTarget;
    protected List<ClickableTinkerSlider> sliders;
    protected Map<String, Double> propertyStrings;
    protected ClickableTinkerSlider selectedSlider;
    protected EntityPlayerSP player;

    public ModuleTweakFrame(EntityPlayerSP player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame itemTarget, ModuleSelectionFrame moduleTarget) {
        super((IRect)new DrawableMuseRect(topleft.times(1.0 / SCALERATIO), bottomright.times(1.0 / SCALERATIO), borderColour, insideColour));
        this.itemTarget = itemTarget;
        this.moduleTarget = moduleTarget;
        this.player = player;
    }

    public void update(double mouseX, double mouseY) {
        mouseX /= SCALERATIO;
        if (this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ItemStack stack = this.itemTarget.getSelectedItem().getItem();
            IPowerModule module = this.moduleTarget.getSelectedModule().getModule();
            if (ModuleManager.INSTANCE.itemHasModule(this.itemTarget.getSelectedItem().getItem(), this.moduleTarget.getSelectedModule().getModule().getDataName())) {
                this.loadTweaks(stack, module);
            } else {
                this.sliders = null;
                this.propertyStrings = null;
            }
        } else {
            this.sliders = null;
            this.propertyStrings = null;
        }
        if (this.selectedSlider != null) {
            this.selectedSlider.setValueByX(mouseX);
        }
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        if (this.sliders != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)SCALERATIO, (double)SCALERATIO, (double)SCALERATIO);
            super.render(mouseX, mouseY, partialTicks);
            MuseRenderer.drawCenteredString((String)"Tinker", (double)((this.left() + this.right()) / 2.0), (double)(this.top() + 2.0));
            for (ClickableTinkerSlider slider : this.sliders) {
                slider.render(mouseX, mouseY, partialTicks);
            }
            int nexty = (int)((double)(this.sliders.size() * 20) + this.top() + 23.0);
            for (Map.Entry<String, Double> property : this.propertyStrings.entrySet()) {
                String formattedValue = MuseStringUtils.formatNumberFromUnits((double)property.getValue(), (String)PowerModuleBase.getUnit(property.getKey()));
                String name = property.getKey();
                double valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
                double allowedNameWidth = this.width() - valueWidth - (double)(margin * 2);
                List namesList = MuseStringUtils.wrapStringToVisualLength((String)I18n.func_135052_a((String)("powersuits.tradeoff." + name), (Object[])new Object[0]), (double)allowedNameWidth);
                for (int i = 0; i < namesList.size(); ++i) {
                    MuseRenderer.drawString((String)((String)namesList.get(i)), (double)(this.left() + (double)margin), (double)(nexty + 9 * i));
                }
                MuseRenderer.drawRightAlignedString((String)formattedValue, (double)(this.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
                nexty += 9 * namesList.size() + 1;
            }
            GL11.glPopMatrix();
        }
    }

    private void loadTweaks(ItemStack stack, IPowerModule module) {
        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag((ItemStack)stack);
        NBTTagCompound moduleTag = itemTag.func_74775_l(module.getDataName());
        this.propertyStrings = new HashMap<String, Double>();
        HashSet<String> tweaks = new HashSet<String>();
        Map propertyModifiers = module.getPropertyModifiers();
        for (Map.Entry property : propertyModifiers.entrySet()) {
            double currValue = 0.0;
            for (IPropertyModifier modifier : (List)property.getValue()) {
                currValue = (Double)modifier.applyModifier(moduleTag, currValue);
                if (!(modifier instanceof PropertyModifierLinearAdditiveDouble)) continue;
                tweaks.add(((PropertyModifierLinearAdditiveDouble)modifier).getTradeoffName());
            }
            this.propertyStrings.put((String)property.getKey(), currValue);
        }
        this.sliders = new LinkedList<ClickableTinkerSlider>();
        int y = 0;
        for (String tweak : tweaks) {
            MusePoint2D center = new MusePoint2D((this.left() + this.right()) / 2.0, this.top() + (double)(y += 20));
            ClickableTinkerSlider slider = new ClickableTinkerSlider(center, this.right() - this.left() - 8.0, moduleTag, tweak, I18n.func_135052_a((String)("powersuits.tradeoff." + tweak), (Object[])new Object[0]));
            this.sliders.add(slider);
            if (this.selectedSlider == null || !slider.containsPoint(center.getX(), center.getY())) continue;
            this.selectedSlider = slider;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        mouseX /= SCALERATIO;
        mouseY /= SCALERATIO;
        if (button == 0 && this.sliders != null) {
            for (ClickableTinkerSlider slider : this.sliders) {
                if (!slider.containsPoint(mouseX, mouseY)) continue;
                this.selectedSlider = slider;
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.selectedSlider != null && this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ClickableItem item = this.itemTarget.getSelectedItem();
            IPowerModule module = this.moduleTarget.getSelectedModule().getModule();
            MPSPackets.sendToServer((IMessage)new MusePacketTweakRequestDouble((EntityPlayer)this.player, item.inventorySlot, module.getDataName(), this.selectedSlider.id(), this.selectedSlider.getValue()));
            return true;
        }
        if (button == 0) {
            this.selectedSlider = null;
            return true;
        }
        return false;
    }
}

