/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.module.tinker;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.ClickableButton;
import net.machinemuse.numina.client.gui.clickable.ClickableItem;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.powersuits.client.gui.common.ClickableModule;
import net.machinemuse.powersuits.client.gui.common.ItemSelectionFrame;
import net.machinemuse.powersuits.client.gui.module.tinker.ModuleSelectionFrame;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.common.network.MPSPackets;
import net.machinemuse.powersuits.common.network.packets.MusePacketInstallModuleRequest;
import net.machinemuse.powersuits.common.network.packets.MusePacketSalvageModuleRequest;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InstallSalvageFrame
extends ScrollableFrame {
    protected ItemSelectionFrame targetItem;
    protected ModuleSelectionFrame targetModule;
    protected ClickableButton installButton;
    protected ClickableButton salvageButton;
    protected EntityPlayerSP player;

    public InstallSalvageFrame(EntityPlayerSP player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame targetItem, ModuleSelectionFrame targetModule) {
        super((IRect)new DrawableMuseRect(topleft, bottomright, borderColour, insideColour));
        this.player = player;
        this.targetItem = targetItem;
        this.targetModule = targetModule;
        double sizex = this.right() - this.left();
        double sizey = this.bottom() - this.top();
        this.installButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.install", (Object[])new Object[0]), new MusePoint2D(this.right() - sizex / 2.0, this.bottom() - sizey / 4.0), true);
        this.salvageButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.salvage", (Object[])new Object[0]), new MusePoint2D(this.left() + sizex / 2.0, this.top() + sizey / 4.0), true);
    }

    public void update(double mouseX, double mouseY) {
    }

    public List<String> getToolTip(double mouseX, double mouseY) {
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            double xoffset;
            ItemStack stack = this.targetItem.getSelectedItem().getItem();
            IPowerModule module = this.targetModule.getSelectedModule().getModule();
            NonNullList<ItemStack> itemsToCheck = ModuleManager.INSTANCE.getInstallCost(module.getDataName());
            double yoffset = !ModuleManager.INSTANCE.itemHasModule(stack, module.getDataName()) ? this.top() + 4.0 : this.bottom() - 20.0;
            if (yoffset + 16.0 > mouseY && yoffset < mouseY && (xoffset = -8.0 * (double)itemsToCheck.size() + (this.left() + this.right()) / 2.0) + (double)(16 * itemsToCheck.size()) > mouseX && xoffset < mouseX) {
                int index = (int)(mouseX - xoffset) / 16;
                return ((ItemStack)itemsToCheck.get(index)).func_82840_a((EntityPlayer)this.player, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            }
        }
        return null;
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            this.drawBackground(mouseX, mouseY, partialTicks);
            this.drawItems(mouseX, mouseY, partialTicks);
            this.drawButtons(mouseX, mouseY, partialTicks);
        }
    }

    private void drawBackground(double mouseX, double mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
    }

    private void drawItems(double mouseX, double mouseY, float partialTicks) {
        ItemStack stack = this.targetItem.getSelectedItem().getItem();
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        NonNullList<ItemStack> itemsToDraw = ModuleManager.INSTANCE.getInstallCost(module.getDataName());
        double yoffset = !ModuleManager.INSTANCE.itemHasModule(stack, module.getDataName()) ? this.top() + 4.0 : this.bottom() - 20.0;
        double xoffset = -8.0 * (double)itemsToDraw.size() + (this.left() + this.right()) / 2.0;
        int i = 0;
        for (ItemStack costItem : itemsToDraw) {
            MuseRenderer.drawItemAt((double)((double)(16 * i++) + xoffset), (double)yoffset, (ItemStack)costItem);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawButtons(double mouseX, double mouseY, float partialTicks) {
        block4: {
            block3: {
                stack = this.targetItem.getSelectedItem().getItem();
                if (ModuleManager.INSTANCE.itemHasModule(stack, (module = this.targetModule.getSelectedModule().getModule()).getDataName())) break block3;
                installedModulesOfType = ModuleManager.INSTANCE.getNumberInstalledModulesOfType(stack, module.getCategory());
                if (this.player.field_71075_bZ.field_75098_d) ** GOTO lbl-1000
                if (MuseItemUtils.hasInInventory(ModuleManager.INSTANCE.getInstallCost(module.getDataName()), (InventoryPlayer)this.player.field_71071_by)) {
                    ** if (installedModulesOfType >= MPSConfig.getMaxModulesOfType((EnumModuleCategory)module.getCategory())) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v0 = true;
                    ** GOTO lbl12
                }
lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
lbl12:
                // 2 sources

                this.installButton.setEnabled(v0);
                this.installButton.render(mouseX, mouseY, partialTicks);
                break block4;
            }
            this.salvageButton.render(mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ClickableItem selItem = this.targetItem.getSelectedItem();
        ClickableModule selModule = this.targetModule.getSelectedModule();
        if (selItem != null && selModule != null) {
            IPowerModule module;
            ItemStack stack = selItem.getItem();
            if (!ModuleManager.INSTANCE.itemHasModule(stack, (module = selModule.getModule()).getDataName())) {
                if (this.installButton.containsPoint(mouseX, mouseY)) {
                    this.doInstall();
                    return true;
                }
            } else if (this.salvageButton.containsPoint(mouseX, mouseY)) {
                this.doSalvage();
                return true;
            }
        }
        return false;
    }

    private void doSalvage() {
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        MPSPackets.sendToServer((IMessage)new MusePacketSalvageModuleRequest((EntityPlayer)this.player, this.targetItem.getSelectedItem().inventorySlot, module.getDataName()));
    }

    private void doInstall() {
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        if (this.player.field_71075_bZ.field_75098_d || MuseItemUtils.hasInInventory(ModuleManager.INSTANCE.getInstallCost(module.getDataName()), (InventoryPlayer)this.player.field_71071_by)) {
            Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_INSTALL, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, null);
            MPSPackets.sendToServer((IMessage)new MusePacketInstallModuleRequest((EntityPlayer)this.player, this.targetItem.getSelectedItem().inventorySlot, module.getDataName()));
        }
    }
}

