/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.module.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.machinemuse.numina.client.gui.frame.IGuiFrame;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.geometry.MuseRect;
import net.machinemuse.numina.client.gui.geometry.SpiralPointToPoint2D;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.common.item.IModeChangingItem;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.numina.common.network.packets.MusePacketModeChangeRequest;
import net.machinemuse.powersuits.client.gui.common.ClickableModule;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.network.MPSPackets;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RadialModeSelectionFrame<T extends IRect>
implements IGuiFrame {
    protected final long spawnTime;
    protected List<ClickableModule> modeButtons = new ArrayList<ClickableModule>();
    protected int selectedModuleOriginal = -1;
    protected int selectedModuleNew = -1;
    protected EntityPlayer player;
    protected double radius;
    protected ItemStack stack;
    T border;

    public RadialModeSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, EntityPlayer player) {
        this.spawnTime = System.currentTimeMillis();
        this.player = player;
        this.setRect((IRect)new MuseRect(topleft, bottomright));
        this.radius = Math.min(this.border.center().minus(topleft).getX(), this.border.center().minus(topleft).getY());
        this.stack = player.field_71071_by.func_70448_g();
        this.loadItems();
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() instanceof IModeChangingItem && this.modeButtons != null) {
            int i = 0;
            for (ClickableModule mode : this.modeButtons) {
                if (mode.getModule().getDataName().equals(((IModeChangingItem)this.stack.func_77973_b()).getActiveMode(this.stack))) {
                    this.selectedModuleOriginal = i;
                    break;
                }
                ++i;
            }
        }
    }

    public IRect getRect() {
        return this.border;
    }

    public void setRect(IRect rect) {
        this.border = rect;
    }

    public RadialModeSelectionFrame() {
        this.spawnTime = System.currentTimeMillis();
    }

    private boolean alreadyAdded(IRightClickModule module) {
        for (ClickableModule clickie : this.modeButtons) {
            if (!clickie.getModule().getDataName().equals(module.getDataName())) continue;
            return true;
        }
        return false;
    }

    private void loadItems() {
        if (this.player != null) {
            ArrayList<IRightClickModule> modes = new ArrayList<IRightClickModule>();
            for (IPowerModule module : ModuleManager.INSTANCE.getModulesOfType(IRightClickModule.class)) {
                if (!ModuleManager.INSTANCE.isValidForItem(this.stack, module) || !ModuleManager.INSTANCE.itemHasModule(this.stack, module.getDataName())) continue;
                modes.add((IRightClickModule)module);
            }
            int modeNum = 0;
            for (IRightClickModule module : modes) {
                if (this.alreadyAdded(module)) continue;
                ClickableModule clickie = new ClickableModule((IPowerModule)module, (MusePoint2D)new SpiralPointToPoint2D(this.border.center(), this.radius, 4.71238898038469 - Math.PI * 2 * (double)modeNum / (double)modes.size(), 250.0));
                this.modeButtons.add(clickie);
                ++modeNum;
            }
        }
    }

    private void selectModule(double x, double y) {
        if (this.modeButtons != null) {
            int i = 0;
            for (ClickableModule module : this.modeButtons) {
                if (module.containsPoint(x, y)) {
                    this.selectedModuleNew = i;
                    break;
                }
                ++i;
            }
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.modeButtons.size() > this.selectedModuleNew && this.selectedModuleNew != -1) {
            return this.modeButtons.get(this.selectedModuleNew);
        }
        return null;
    }

    public void update(double mouseX, double mouseY) {
        this.loadItems();
        if (System.currentTimeMillis() - this.spawnTime > 250L) {
            this.selectModule(mouseX, mouseY);
        }
        if (this.getSelectedModule() != null && this.selectedModuleOriginal != this.selectedModuleNew && !this.stack.func_190926_b() && this.stack.func_77973_b() instanceof IModeChangingItem) {
            this.selectedModuleOriginal = this.selectedModuleNew;
            ((IModeChangingItem)this.stack.func_77973_b()).setActiveMode(this.stack, this.getSelectedModule().getModule().getDataName());
            MPSPackets.sendToServer((IMessage)new MusePacketModeChangeRequest(this.player, this.getSelectedModule().getModule().getDataName(), this.player.field_71071_by.field_70461_c));
        }
    }

    public void drawSelection() {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            MusePoint2D pos = module.getPosition();
            MuseRenderer.drawCircleAround((double)pos.getX(), (double)pos.getY(), (double)10.0);
        }
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        for (ClickableModule mode : this.modeButtons) {
            mode.render(mouseX, mouseY, partialTicks);
        }
        this.drawSelection();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public List<String> getToolTip(double mouseX, double mouseY) {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            IPowerModule selectedModule = module.getModule();
            return Collections.singletonList(module.getLocalizedName(selectedModule));
        }
        return null;
    }
}

