/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.control;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.machinemuse.numina.common.base.MuseLogger;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.powersuits.client.control.MPSKeyBinding;
import net.machinemuse.powersuits.client.event.RenderEventHandler;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.input.Keyboard;

public enum KeybindManager {
    INSTANCE;

    static final String formatVersionKey = "formatVersion";
    static final String dataName = "dataName";
    static final String showOnHudKey = "showOnHud";
    static final String defaultKeyKey = "defaultKey";
    static final String currentKey = "currentKey";
    static final String keyModifier = "keyModifier";

    public void makeKeybinds() {
        ModuleManager.INSTANCE.getModuleMap().values().stream().filter(IToggleableModule.class::isInstance).map(IToggleableModule.class::cast).forEach(iToggleableModule -> this.registerKeyBindingFromModule((IPowerModule)iToggleableModule));
        this.readInKeybinds();
        this.writeOutKeybinds();
        RenderEventHandler.makeKBDisplayList();
    }

    File getLegacyKeyBindConfig() {
        return new File(Loader.instance().getConfigDir() + "/machinemuse/", "powersuits-keybinds.cfg");
    }

    File getKeyBindConfig() {
        return new File(Loader.instance().getConfigDir() + "/machinemuse/powersuits-keybinds.json");
    }

    public void writeOutKeybinds() {
        try {
            File file = this.getKeyBindConfig();
            if (!file.exists()) {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
                file.createNewFile();
            }
            JsonObject kbSettings = new JsonObject();
            kbSettings.addProperty(formatVersionKey, (Number)2);
            Arrays.stream(Minecraft.func_71410_x().field_71474_y.field_74324_K).filter(MPSKeyBinding.class::isInstance).map(MPSKeyBinding.class::cast).forEach(keyBinding -> {
                JsonObject jsonKBSetting = new JsonObject();
                jsonKBSetting.addProperty(dataName, keyBinding.dataName);
                jsonKBSetting.addProperty(showOnHudKey, Boolean.valueOf(keyBinding.showOnHud));
                jsonKBSetting.addProperty(currentKey, (Number)keyBinding.func_151463_i());
                if (keyBinding.getKeyModifier() != KeyModifier.NONE) {
                    jsonKBSetting.addProperty(keyModifier, keyBinding.getKeyModifier().toString());
                }
                kbSettings.add(keyBinding.func_151464_g(), (JsonElement)jsonKBSetting);
            });
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(kbSettings.toString());
            String prettyJsonString = gson.toJson(je);
            this.fileWriter(file, prettyJsonString, true);
        }
        catch (Exception e) {
            MuseLogger.logger.error("Problem writing out keyconfig :(");
            e.printStackTrace();
        }
    }

    public void fileWriter(File file, String string, boolean overwrite) {
        try {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            if (overwrite || !file.exists()) {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(string);
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readInKeybinds() {
        File file = this.getKeyBindConfig();
        if (!file.exists()) {
            this.readLegacyKeybinds();
            return;
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(file);){
            JsonElement object = jsonParser.parse((Reader)reader);
            if (object instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)object;
                Set elements = jsonObject.entrySet();
                if (jsonObject.has(formatVersionKey) && jsonObject.get(formatVersionKey).getAsInt() == 2) {
                    MuseLogger.logDebug((String)"loading keybind format 2.0");
                    for (Map.Entry entry : elements) {
                        IPowerModule module;
                        String name = (String)entry.getKey();
                        if (!(entry.getValue() instanceof JsonObject)) continue;
                        JsonObject data = ((JsonObject)entry.getValue()).getAsJsonObject();
                        KeyModifier modifier = KeyModifier.NONE;
                        boolean showOnHud = data.get(showOnHudKey).getAsBoolean();
                        int defaultKey = data.get(currentKey).getAsInt();
                        String moduleDataName = data.get(dataName).getAsString();
                        if (data.has(keyModifier)) {
                            modifier = KeyModifier.valueFromString((String)data.get(keyModifier).getAsString());
                        }
                        if ((module = ModuleManager.INSTANCE.getModule(moduleDataName)) == null) continue;
                        this.registerKeyBinding(module, false, showOnHud, defaultKey, modifier);
                    }
                } else {
                    MuseLogger.logDebug((String)"loading keybind format 1.2");
                }
            }
        }
        catch (Exception e) {
            MuseLogger.logger.error("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }

    public Stream<MPSKeyBinding> getMPSKeybinds() {
        return Arrays.stream(Minecraft.func_71410_x().field_71474_y.field_74324_K).filter(MPSKeyBinding.class::isInstance).map(MPSKeyBinding.class::cast);
    }

    public String parseName(KeyBinding keybind) {
        if (keybind.func_151463_i() < 0) {
            return "Mouse" + (keybind.func_151463_i() + 100);
        }
        return Keyboard.getKeyName((int)keybind.func_151463_i());
    }

    public void readLegacyKeybinds() {
        try {
            File file = this.getLegacyKeyBindConfig();
            if (!file.exists()) {
                MuseLogger.logError((String)"No powersuits keybind file found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            boolean displayOnHUD = false;
            boolean toggleval = false;
            int keyCode = 0;
            while (reader.ready()) {
                IPowerModule module;
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    keyCode = Integer.parseInt(exploded[0]);
                    displayOnHUD = exploded.length > 3 ? Boolean.parseBoolean(exploded[3]) : false;
                    if (exploded.length > 4) {
                        toggleval = Boolean.parseBoolean(exploded[4]);
                        continue;
                    }
                    toggleval = false;
                    continue;
                }
                if (!line.contains("~") || (module = ModuleManager.INSTANCE.getModule((exploded = line.split("~"))[0])) == null) continue;
                this.registerKeyBinding(module, toggleval, displayOnHUD, keyCode, KeyModifier.NONE);
            }
            reader.close();
        }
        catch (Exception e) {
            MuseLogger.logError((String)"Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }

    public void registerKeyBindingFromModule(IPowerModule module) {
        String keybindingName = module.getUnlocalizedName() + ".name";
        this.registerKeyBinding(module.getDataName(), keybindingName, 0, KeyModifier.NONE, "key.powersuits.category.moduleToggle", false, false);
    }

    public void registerKeyBinding(IPowerModule module, boolean toggleVal, boolean showOnHud, int keyCode, KeyModifier keyModifierIn) {
        String keybindingName = module.getUnlocalizedName() + ".name";
        this.registerKeyBinding(module.getDataName(), keybindingName, keyCode, keyModifierIn, "key.powersuits.category.moduleToggle", showOnHud, toggleVal);
    }

    public void registerKeyBinding(String moduleDataName, String keybindingName, int keyIn, KeyModifier keyModifierIn, String category, boolean showOnHud, boolean toggleVal) {
        List matches = this.getMPSKeybinds().filter(kb -> kb.func_151464_g().contains(keybindingName)).collect(Collectors.toList());
        if (matches.isEmpty()) {
            MPSKeyBinding keybinding = new MPSKeyBinding(moduleDataName, keybindingName, keyIn, category, showOnHud);
            keybinding.toggleval = toggleVal;
            MuseLogger.logDebug((String)("registering keybind for: " + moduleDataName));
            ClientRegistry.registerKeyBinding((KeyBinding)keybinding);
        } else {
            MuseLogger.logDebug((String)("updating keybinding for " + moduleDataName));
            matches.stream().filter(MPSKeyBinding.class::isInstance).map(MPSKeyBinding.class::cast).forEach(kb -> {
                kb.showOnHud = showOnHud;
                if (kb.func_151463_i() != keyIn || kb.getKeyModifier() != keyModifierIn) {
                    if (keyModifierIn != KeyModifier.NONE) {
                        kb.setKeyModifierAndCodeInternal(keyModifierIn, keyIn);
                    } else {
                        kb.setKeyInternal(keyIn);
                    }
                }
                kb.toggleval = toggleVal;
            });
        }
    }
}

