/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.forge.fml.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.bridge.fml.common.LoaderBridge;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import java.io.File;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Loader.class}, priority=1337, remap=false)
public abstract class LoaderMixin
implements LoaderBridge {
    @Shadow
    private ModClassLoader modClassLoader;
    @Shadow
    private List<ModContainer> mods;
    @Shadow
    private static File minecraftDir;
    private final List<Path> sledgehammer$candidates = Lists.newArrayList();
    private final Set<File> sledgehammer$files = Sets.newHashSet();
    private final Map<File, Set<String>> sledgehammer$mappings = Maps.newHashMap();

    @Inject(method={"identifyMods"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraftforge/fml/relauncher/libraries/LibraryManager;gatherLegacyCanidates(Ljava/io/File;)Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onGatherLegacyCanidates(List<String> additionalContainers, CallbackInfoReturnable<ModDiscoverer> callbackInfoReturnable, ModDiscoverer discoverer, List<Artifact> maven_canidates, List<File> file_canidates) {
        file_canidates.forEach(file -> this.sledgehammer$candidates.add(this.sledgehammer$toPath((File)file)));
        maven_canidates.forEach(artifact -> this.sledgehammer$candidates.add(this.sledgehammer$toPath(artifact.getFile())));
        block0: for (Map.Entry<File, Set<String>> entry : this.sledgehammer$mappings.entrySet()) {
            if (CoreModManager.getReparseableCoremods().contains(entry.getKey().getName())) continue;
            for (String id : entry.getValue()) {
                if (!MappingManager.getModMapping(id).isPresent()) continue;
                file_canidates.removeIf(entry.getKey()::equals);
                maven_canidates.removeIf(artifact -> ((File)entry.getKey()).equals(artifact.getFile()));
                continue block0;
            }
        }
        this.sledgehammer$files.clear();
        this.sledgehammer$mappings.clear();
    }

    @Inject(method={"identifyMods"}, at={@At(value="RETURN")})
    private void onIdentifyModsPost(List<String> additionalContainers, CallbackInfoReturnable<ModDiscoverer> callbackInfoReturnable) {
        if (Sledgehammer.getInstance().isDebug()) {
            Sledgehammer.getInstance().getLogger().debug("Mods Order Pre:");
            this.sledgehammer$printModsOrder();
        }
        this.mods.sort(Comparator.comparingInt(modContainer -> {
            if (!(modContainer instanceof FMLModContainer) || modContainer.getSource() == null) {
                return 0;
            }
            return this.sledgehammer$candidates.indexOf(this.sledgehammer$toPath(modContainer.getSource()));
        }));
        this.sledgehammer$candidates.clear();
        if (Sledgehammer.getInstance().isDebug()) {
            Sledgehammer.getInstance().getLogger().debug("Mods Order Post:");
            this.sledgehammer$printModsOrder();
        }
    }

    @Override
    public void bridge$addFile(File file) {
        try {
            if (this.modClassLoader.containsSource(file) || this.sledgehammer$files.contains(file)) {
                return;
            }
            this.modClassLoader.addFile(file);
            this.sledgehammer$files.add(file);
            Sledgehammer.getInstance().getLogger().info("Loaded {}", (Object)file.getName());
        }
        catch (MalformedURLException ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while adding {} to the classloader", (Object)file, (Object)ex);
        }
    }

    @Override
    public File bridge$getMinecraftDirectory() {
        return minecraftDir;
    }

    @Override
    public Map<File, Set<String>> bridge$getMappings() {
        return this.sledgehammer$mappings;
    }

    private void sledgehammer$printModsOrder() {
        for (int index = 0; index < this.mods.size(); ++index) {
            ModContainer modContainer = this.mods.get(index);
            if (modContainer.getSource() == null) continue;
            Sledgehammer.getInstance().getLogger().debug("{}: {}", (Object)index, (Object)modContainer.getSource().getName());
        }
    }

    private Path sledgehammer$toPath(File file) {
        return file.toPath().toAbsolutePath().normalize();
    }
}

