/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.GeneralCategory;
import io.github.lxgaming.sledgehammer.util.Locale;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import io.github.lxgaming.sledgehammer.util.text.adapter.TextAdapter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public final class LocaleManager {
    public static final String PLACEHOLDER_START = "{";
    public static final String PLACEHOLDER_END = "}";
    private static final Map<String, String> LOCALE = Maps.newHashMap();

    public static void prepare() {
        if (LocaleManager.loadLocale("en_us")) {
            Sledgehammer.getInstance().getLogger().info("Loaded default locale");
        } else {
            Sledgehammer.getInstance().getLogger().warn("Failed to load default locale");
        }
        GeneralCategory generalCategory = Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).orElseThrow(NullPointerException::new);
        if (!generalCategory.getLocale().equals("en_us")) {
            if (LocaleManager.loadLocale(generalCategory.getLocale())) {
                Sledgehammer.getInstance().getLogger().info("Loaded {} locale", (Object)generalCategory.getLocale());
            } else {
                Sledgehammer.getInstance().getLogger().warn("Failed to load {} locale", (Object)generalCategory.getLocale());
            }
        }
        for (Map.Entry<String, List<String>> entry : generalCategory.getLocaleOverrides().entrySet()) {
            LOCALE.put(entry.getKey(), String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)entry.getValue()));
        }
    }

    public static ITextComponent serialize(Locale locale, Object ... arguments) {
        return LocaleManager.serialize(locale.getKey(), arguments);
    }

    public static ITextComponent serialize(String key, Object ... arguments) {
        String format;
        String translation = LocaleManager.getTranslation(key);
        if (translation == null) {
            return new TextComponentString("Failed to translate message").func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        int matches = StringUtils.countMatches((CharSequence)translation, (CharSequence)"{}");
        if (matches != arguments.length) {
            Sledgehammer.getInstance().getLogger().warn("Incorrect Arguments for {}. Expected {}, got {}", (Object)key, (Object)matches, (Object)arguments.length);
        }
        if (StringUtils.isEmpty((CharSequence)(format = LocaleManager.format(translation, arguments)))) {
            return new TextComponentString("Failed to format message").func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        }
        return TextAdapter.serializeLegacyWithLinks(format);
    }

    private static String format(String format, Object ... arguments) {
        StringBuilder stringBuilder = new StringBuilder(format);
        int startIndex = 0;
        int endIndex = 0;
        int argumentIndex = 0;
        while ((startIndex = stringBuilder.indexOf(PLACEHOLDER_START, startIndex)) != -1 && (endIndex = stringBuilder.indexOf(PLACEHOLDER_END, endIndex)) != -1) {
            int length = stringBuilder.length();
            if (endIndex - startIndex == PLACEHOLDER_START.length()) {
                if (argumentIndex >= arguments.length) {
                    startIndex = endIndex += PLACEHOLDER_END.length();
                    continue;
                }
                stringBuilder.replace(startIndex, endIndex + PLACEHOLDER_END.length(), StringUtils.toString(arguments[argumentIndex]));
                ++argumentIndex;
            } else {
                String key = stringBuilder.substring(startIndex + PLACEHOLDER_START.length(), endIndex);
                String value = LocaleManager.getTranslation(key);
                if (value != null) {
                    stringBuilder.replace(startIndex, endIndex + PLACEHOLDER_END.length(), value);
                } else {
                    stringBuilder.delete(startIndex + PLACEHOLDER_START.length(), endIndex);
                }
            }
            int difference = stringBuilder.length() - length;
            startIndex += difference;
            endIndex += difference;
        }
        return stringBuilder.toString();
    }

    private static boolean loadLocale(String name) {
        Map<String, String> locale = LocaleManager.deserializeLocaleFile(String.format("/assets/%s/locale/%s.json", "sledgehammer", name));
        if (locale != null) {
            LOCALE.putAll(locale);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> deserializeLocaleFile(String name) {
        InputStream inputStream = LocaleManager.class.getResourceAsStream(name);
        if (inputStream == null) {
            Sledgehammer.getInstance().getLogger().warn("Resource {} doesn't exist", (Object)name);
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193839_a((Gson)new GsonBuilder().create(), (Reader)reader, JsonObject.class);
            if (jsonObject == null) {
                throw new JsonParseException(String.format("Failed to parse locale %s", name));
            }
            HashMap translations = Maps.newHashMap();
            for (Map.Entry entry : jsonObject.entrySet()) {
                translations.put(entry.getKey(), StringUtils.toString((JsonElement)entry.getValue()));
            }
            HashMap hashMap = translations;
            return hashMap;
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while deserializing {}", (Object)name, (Object)ex);
            return null;
        }
    }

    private static String getTranslation(String key) {
        String translation = LOCALE.get(key);
        if (translation == null) {
            Sledgehammer.getInstance().getLogger().warn("Missing translation for {}", (Object)key);
            return null;
        }
        return translation;
    }
}

