/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.reactive;

import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Disposable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.ExecutePublisher;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.MappedProcessor;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.PublisherCached;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Subscriber;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.TransactionFailedException;
import io.github.lxgaming.sledgehammer.lib.configurate.util.CheckedFunction;
import io.github.lxgaming.sledgehammer.lib.configurate.util.CheckedSupplier;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public interface Publisher<V> {
    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action) {
        return Publisher.execute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action, Executor executor) {
        return new ExecutePublisher<V>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(executor, "executor"));
    }

    public Disposable subscribe(Subscriber<? super V> var1);

    public boolean hasSubscribers();

    default public <R> Publisher<R> map(CheckedFunction<? super V, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<V, R>(mapper, this);
    }

    default public Cached<V> cache() {
        return this.cache(null);
    }

    default public Cached<V> cache(@Nullable V initialValue) {
        return new PublisherCached<V>(this, initialValue);
    }

    public Executor getExecutor();

    public static interface Cached<V>
    extends Publisher<V> {
        public V get();

        public void submit(V var1);
    }
}

