/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize.TypeSerializer;
import java.net.MalformedURLException;
import java.net.URL;

class URLSerializer
implements TypeSerializer<URL> {
    URLSerializer() {
    }

    @Override
    public URL deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        URL url;
        String plainUrl = value.getString();
        if (plainUrl == null) {
            throw new ObjectMappingException("No value present in node " + value);
        }
        try {
            url = new URL(plainUrl);
        }
        catch (MalformedURLException e) {
            throw new ObjectMappingException("Invalid URL string provided for " + value.getKey() + ": got " + plainUrl);
        }
        return url;
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable URL obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        value.setValue(obj.toString());
    }
}

