/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.command;

import io.github.lxgaming.sledgehammer.command.Command;
import io.github.lxgaming.sledgehammer.manager.CommandManager;
import io.github.lxgaming.sledgehammer.util.Locale;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import io.github.lxgaming.sledgehammer.util.text.EmptyTextComponent;
import io.github.lxgaming.sledgehammer.util.text.adapter.LocaleAdapter;
import io.github.lxgaming.sledgehammer.util.text.adapter.TextAdapter;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class HelpCommand
extends Command {
    @Override
    public boolean prepare() {
        this.addAlias("Help");
        this.addAlias("?");
        return true;
    }

    @Override
    public void execute(ICommandSender commandSender, List<String> arguments) throws Exception {
        LocaleAdapter.sendFeedback(commandSender, Locale.GENERAL_PREFIX, new Object[0]);
        for (Command command : CommandManager.COMMANDS) {
            if (command == this || StringUtils.isNotBlank((CharSequence)command.getPermission()) && !commandSender.func_70003_b(4, command.getPermission())) continue;
            EmptyTextComponent rootTextComponent = new EmptyTextComponent();
            rootTextComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sledgehammer " + String.join((CharSequence)" ", command.getPath()).toLowerCase()));
            rootTextComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.buildDescription(command)));
            rootTextComponent.func_150257_a(new TextComponentString("> ").func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
            rootTextComponent.func_150257_a(new TextComponentString("/sledgehammer " + String.join((CharSequence)" ", command.getPath()).toLowerCase()).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            if (StringUtils.isNotBlank((CharSequence)command.getUsage())) {
                rootTextComponent.func_150257_a(new TextComponentString(" " + command.getUsage()).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
            TextAdapter.sendFeedback(commandSender, (ITextComponent)rootTextComponent);
        }
    }

    private ITextComponent buildDescription(Command command) {
        EmptyTextComponent rootTextComponent = new EmptyTextComponent();
        rootTextComponent.func_150257_a(new TextComponentString("Command: ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        rootTextComponent.func_150257_a(new TextComponentString(command.getPrimaryAlias().orElse("unknown")).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
        rootTextComponent.func_150257_a((ITextComponent)new TextComponentString("\n"));
        rootTextComponent.func_150257_a(new TextComponentString("Description: ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        rootTextComponent.func_150257_a(new TextComponentString((String)StringUtils.defaultIfEmpty((CharSequence)command.getDescription(), (CharSequence)"No description provided")).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
        rootTextComponent.func_150257_a((ITextComponent)new TextComponentString("\n"));
        rootTextComponent.func_150257_a(new TextComponentString("Usage: ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        rootTextComponent.func_150257_a(new TextComponentString("/sledgehammer " + String.join((CharSequence)" ", command.getPath()).toLowerCase()).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
        if (StringUtils.isNotBlank((CharSequence)command.getUsage())) {
            rootTextComponent.func_150257_a(new TextComponentString(" " + command.getUsage()).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
        }
        rootTextComponent.func_150257_a((ITextComponent)new TextComponentString("\n"));
        rootTextComponent.func_150257_a(new TextComponentString("Permission: ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        rootTextComponent.func_150257_a(new TextComponentString((String)StringUtils.defaultIfEmpty((CharSequence)command.getPermission(), (CharSequence)"None")).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
        rootTextComponent.func_150257_a((ITextComponent)new TextComponentString("\n"));
        rootTextComponent.func_150257_a((ITextComponent)new TextComponentString("\n"));
        rootTextComponent.func_150257_a(new TextComponentString("Click to auto-complete.").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        return rootTextComponent;
    }
}

