/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.command;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.command.Command;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.GeneralCategory;
import io.github.lxgaming.sledgehammer.util.Locale;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import io.github.lxgaming.sledgehammer.util.text.adapter.LocaleAdapter;
import java.util.List;
import net.minecraft.command.ICommandSender;
import org.apache.commons.lang3.BooleanUtils;

public class DebugCommand
extends Command {
    @Override
    public boolean prepare() {
        this.addAlias("Debug");
        this.description("For debugging purposes");
        this.permission("sledgehammer.debug.base");
        this.usage("[State]");
        return true;
    }

    @Override
    public void execute(ICommandSender commandSender, List<String> arguments) throws Exception {
        Boolean state;
        GeneralCategory generalCategory = Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).orElse(null);
        if (generalCategory == null) {
            LocaleAdapter.sendFeedback(commandSender, Locale.CONFIGURATION_ERROR, new Object[0]);
            return;
        }
        if (!arguments.isEmpty()) {
            String argument = arguments.remove(0);
            if (StringUtils.isNotBlank((CharSequence)argument)) {
                state = BooleanUtils.toBooleanObject((String)argument);
                if (state == null) {
                    LocaleAdapter.sendFeedback(commandSender, Locale.PARSE_BOOLEAN_ERROR, argument);
                }
            } else {
                state = null;
            }
        } else {
            state = null;
        }
        if (state != null) {
            generalCategory.setDebug(state);
        } else {
            generalCategory.setDebug(!generalCategory.isDebug());
        }
        if (generalCategory.isDebug()) {
            LocaleAdapter.sendFeedback(commandSender, Locale.COMMAND_DEBUG_ENABLE, new Object[0]);
        } else {
            LocaleAdapter.sendFeedback(commandSender, Locale.COMMAND_DEBUG_DISABLE, new Object[0]);
        }
    }
}

