/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.manager.CommandManager;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.ICommandSender;

public abstract class Command {
    private final Set<String> aliases = Sets.newLinkedHashSet();
    private final Set<Command> children = Sets.newLinkedHashSet();
    private Command parentCommand;
    private String description;
    private String permission;
    private String usage;

    public abstract boolean prepare();

    public abstract void execute(ICommandSender var1, List<String> var2) throws Exception;

    public final Optional<String> getPrimaryAlias() {
        for (String alias : this.getAliases()) {
            if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
            return Optional.of(alias);
        }
        return Optional.empty();
    }

    public final List<String> getPath() {
        ArrayList paths = Lists.newArrayList();
        if (this.parentCommand != null) {
            paths.addAll(this.parentCommand.getPath());
        }
        this.getPrimaryAlias().ifPresent(paths::add);
        return paths;
    }

    protected final void addAlias(String alias) {
        CommandManager.registerAlias(this, alias);
    }

    public final Set<String> getAliases() {
        return this.aliases;
    }

    protected final void addChild(Class<? extends Command> commandClass) {
        CommandManager.registerCommand(this, commandClass);
    }

    public final Set<Command> getChildren() {
        return this.children;
    }

    public final Command getParentCommand() {
        return this.parentCommand;
    }

    public final void parentCommand(Command parentCommand) {
        Preconditions.checkState((this.parentCommand == null ? 1 : 0) != 0, (Object)"ParentCommand is already set");
        this.parentCommand = parentCommand;
    }

    public final String getDescription() {
        return this.description;
    }

    protected final void description(String description) {
        Preconditions.checkState((this.description == null ? 1 : 0) != 0, (Object)"Description is already set");
        this.description = description;
    }

    public final String getPermission() {
        return this.permission;
    }

    protected final void permission(String permission) {
        Preconditions.checkState((this.permission == null ? 1 : 0) != 0, (Object)"Permission is already set");
        this.permission = permission;
    }

    public final String getUsage() {
        return this.usage;
    }

    protected final void usage(String usage) {
        Preconditions.checkState((this.usage == null ? 1 : 0) != 0, (Object)"Usage is already set");
        this.usage = usage;
    }
}

