/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import com.google.common.base.Strings;
import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.tile.ITeleporterTarget;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.block.machine.high.TileEntityTeleporter;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricTeleporter
extends ItemIC2
implements IDamagelessElectricItem,
ICustomItemCameraTransform {
    public ItemElectricTeleporter() {
        this.func_77625_d(1);
        this.setTranslationKey(Ic2ItemLang.portableTeleporter);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.teleportPlayer.getLocalized());
        ctrlTip.add("");
        ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.teleportTargetSet.getLocalized());
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74767_n("TargetSet")) {
            List<String> altList = sortedTooltip.get((Object)ToolTipType.Alt);
            int dim = nbt.func_74762_e("TargetDim");
            int[] array = nbt.func_74759_k("TargetPos");
            if (nbt.func_74764_b("TargetName")) {
                altList.add(Ic2InfoLang.freqTransmitterDim.getLocalizedFormatted(dim) + ", " + Ic2InfoLang.freqTransmitterX.getLocalizedFormatted(array[0]) + ", " + Ic2InfoLang.freqTransmitterY.getLocalizedFormatted(array[1]) + ", " + Ic2InfoLang.freqTransmitterZ.getLocalizedFormatted(array[2]));
                tooltip.add(Ic2InfoLang.teleporterTargetName.getLocalizedFormatted(nbt.func_74779_i("TargetName")));
            } else {
                tooltip.add(Ic2InfoLang.freqTransmitterDim.getLocalizedFormatted(dim) + ", " + Ic2InfoLang.freqTransmitterX.getLocalizedFormatted(array[0]) + ", " + Ic2InfoLang.freqTransmitterY.getLocalizedFormatted(array[1]) + ", " + Ic2InfoLang.freqTransmitterZ.getLocalizedFormatted(array[2]));
            }
            BlockPos pos = new BlockPos(array[0], array[1], array[2]);
            int distance = (int)Math.sqrt(pos.func_177951_i((Vec3i)player.func_180425_c()));
            altList.add(Ic2InfoLang.euReaderTeleporterHubTargetDistance.getLocalizedFormatted(distance));
            int energyCost = (int)((double)TileEntityTeleporter.getWeightOfUser((Entity)player) * Math.pow((double)distance + 10.0, dim != player.field_70170_p.field_73011_w.getDimension() ? 0.9 : 0.7) * 6.0);
            altList.add(Ic2InfoLang.euReaderTeleporterHubTargetCost.getLocalizedFormatted(energyCost));
        }
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 5.0E7;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 4;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 25000.0;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 179;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating() && !playerIn.func_70093_af()) {
            NBTTagCompound nbt = StackUtil.getNbtData(stack);
            if (nbt.func_74767_n("TargetSet")) {
                WorldServer targetWorld = IC2.platform.getServer().func_71218_a(nbt.func_74762_e("TargetDim"));
                if (targetWorld != null) {
                    int[] posArray = nbt.func_74759_k("TargetPos");
                    BlockPos targetPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                    TileEntity otherTele = targetWorld.func_175625_s(targetPos);
                    if (TileEntityTeleporter.isTeleporter(otherTele)) {
                        if (TileEntityTeleporter.isSameType(otherTele, ITeleporterTarget.TeleportType.Entity)) {
                            this.teleportEntity(playerIn, (ITeleporterTarget)otherTele, stack);
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                    this.clearTarget(stack, playerIn, true);
                } else {
                    this.clearTarget(stack, playerIn, true);
                }
            } else {
                IC2.platform.messagePlayer(playerIn, Ic2InfoLang.noTeleportTarget);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile;
        if (IC2.platform.isSimulating() && player.func_70093_af() && TileEntityTeleporter.isSameType(tile = world.func_175625_s(pos), ITeleporterTarget.TeleportType.Entity)) {
            this.setTarget((ITeleporterTarget)tile, player.func_184586_b(hand), player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void setTarget(ITeleporterTarget target, ItemStack stack, EntityPlayer player) {
        this.clearTarget(stack, player, false);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        nbt.func_74757_a("TargetSet", true);
        nbt.func_74768_a("TargetDim", target.getWorldObj().field_73011_w.getDimension());
        BlockPos pos = target.getPosition();
        nbt.func_74783_a("TargetPos", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        String name = this.getName(target);
        if (!Strings.isNullOrEmpty((String)name)) {
            nbt.func_74778_a("TargetName", name);
        }
        IC2.platform.messagePlayer(player, Ic2InfoLang.teleporterTargetSet);
    }

    private String getName(ITeleporterTarget target) {
        IWorldNameable name;
        if (target instanceof IWorldNameable && (name = (IWorldNameable)target).func_145818_k_()) {
            return name.func_70005_c_();
        }
        return ITeleporterTarget.TeleporterNameRegistry.getName(new ITeleporterTarget.TeleporterTarget(target));
    }

    public void clearTarget(ItemStack stack, EntityPlayer player, boolean notify) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        nbt.func_82580_o("TargetSet");
        nbt.func_82580_o("TargetDim");
        nbt.func_82580_o("TargetPos");
        nbt.func_82580_o("TargetName");
        if (notify) {
            IC2.platform.messagePlayer(player, Ic2InfoLang.clearedTeleporterTarget);
        }
    }

    public void teleportEntity(EntityPlayer player, ITeleporterTarget target, ItemStack stack) {
        boolean dimSwitch;
        int weight = TileEntityTeleporter.getWeightOfUser((Entity)player);
        if (weight == 0) {
            return;
        }
        double distance = Math.sqrt(player.func_180425_c().func_177951_i((Vec3i)target.getPosition()));
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, (dimSwitch = player.field_70170_p.field_73011_w.getDimension() != target.getWorldObj().field_73011_w.getDimension()) ? 0.9 : 0.7) * 6.0);
        if (!ElectricItem.manager.use(stack, energyCost, (EntityLivingBase)player)) {
            return;
        }
        player.func_184210_p();
        player.func_184226_ay();
        IC2.achievements.issueStat(player, "distanceTeleported", (int)distance);
        if (distance >= 1000.0) {
            IC2.achievements.issueStat(player, "teleportFarAway");
        }
        BlockPos targetPos = target.getPosition();
        EnumFacing side = target.getTeleporterFacing();
        double x = (float)(targetPos.func_177958_n() + side.func_82601_c()) + 0.5f;
        double y = (float)(targetPos.func_177956_o() + side.func_96559_d()) + 0.5f + player.func_70047_e();
        double z = (float)(targetPos.func_177952_p() + side.func_82599_e()) + 0.5f;
        if (side.func_176740_k().func_176720_b()) {
            y = side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)targetPos.func_177956_o() - 2.5 : (double)((float)targetPos.func_177956_o() + player.func_70047_e());
        }
        if (!IC2.config.getFlag("TeleporterInventory")) {
            player.field_71071_by.func_70436_m();
        }
        if (dimSwitch) {
            player.func_70080_a(x, y, z, player.field_70177_z, player.field_70125_A);
        } else {
            player.func_70634_a(x, y, z);
        }
        if (dimSwitch) {
            TileEntityTeleporter.transferPlayerToDimension((EntityPlayerMP)player, target.getWorldObj().field_73011_w.func_186058_p().func_186068_a());
        }
    }
}

