/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.api.classic.item.ICoinItem;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemIC2Coin
extends ItemIC2
implements ICoinItem,
IBootable {
    public ItemIC2Coin() {
        this.func_77627_a(true);
        this.setTranslationKey(Ic2ItemLang.coins);
    }

    @Override
    public void onLoad() {
        Ic2Items.industrialCoin = new ItemStack((Item)this, 1, 0);
        Ic2Items.industrialCoinX8 = new ItemStack((Item)this, 1, 1);
        Ic2Items.industrialCoinX64 = new ItemStack((Item)this, 1, 2);
        Ic2Items.industrialCoinX512 = new ItemStack((Item)this, 1, 3);
        Ic2Items.industrialCoinX4096 = new ItemStack((Item)this, 1, 4);
        Ic2Items.industrialCoinX32768 = new ItemStack((Item)this, 1, 5);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int money = this.getMoneyValue(stack);
        tooltip.add(Ic2InfoLang.coinValue.getLocalizedFormatted(money));
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.coin;
            }
            case 1: {
                return Ic2ItemLang.coinX1;
            }
            case 2: {
                return Ic2ItemLang.coinX2;
            }
            case 3: {
                return Ic2ItemLang.coinX3;
            }
            case 4: {
                return Ic2ItemLang.coinX4;
            }
            case 5: {
                return Ic2ItemLang.coinX5;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5);
    }

    @Override
    public int getMoneyValue(ItemStack stack) {
        return ItemIC2Coin.getAmountFromMeta(stack.func_77960_j());
    }

    private static int getAmountFromMeta(int meta) {
        switch (meta) {
            case 0: {
                return 1;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 64;
            }
            case 3: {
                return 512;
            }
            case 4: {
                return 4096;
            }
            case 5: {
                return 32768;
            }
        }
        return 0;
    }

    @Override
    public int getTextureEntry(int meta) {
        return 192 + meta;
    }

    public static List<ItemStack> generateCoins(int amount) {
        if (amount <= 0) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> lists = new ArrayList<ItemStack>();
        while (amount > 0) {
            int meta = ItemIC2Coin.getMetaFromAmount(amount);
            int count = ItemIC2Coin.getCountFromMeta(meta, amount);
            amount -= ItemIC2Coin.getAmountFromMeta(meta) * count;
            lists.add(new ItemStack(Ic2Items.industrialCoin.func_77973_b(), count, meta));
        }
        return lists;
    }

    private static int getCountFromMeta(int meta, int amount) {
        return amount / ItemIC2Coin.getAmountFromMeta(meta);
    }

    private static int getMetaFromAmount(int amount) {
        if (amount >= 32768) {
            return 5;
        }
        if (amount >= 4096) {
            return 4;
        }
        if (amount >= 512) {
            return 3;
        }
        if (amount >= 64) {
            return 2;
        }
        if (amount >= 8) {
            return 1;
        }
        return 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }
}

