/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.api.classic.util.IWorldTickCallback;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropSeed;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.inventory.base.IC2ItemInventory;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.inv.container.ContainerCropAnalyzer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.world.World;

public class CropAnalyzerInventory
extends IC2ItemInventory
implements IWorldTickCallback {
    public static int[] neededEnergy = new int[]{10, 90, 900, 9000};
    public static String[] tiers = new String[]{"0", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI"};
    public boolean open = true;
    EntityPlayer openPlayer;

    public CropAnalyzerInventory(EntityPlayer player, IHandHeldInventory inv, ItemStack item) {
        super(player, inv, item);
        IC2.callbacks.addCallback(player.func_130014_f_(), this, 5);
        this.openPlayer = player;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCropAnalyzer(this, this.getID(), player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        this.open = false;
        super.onGuiClosed(player);
    }

    @Override
    public ActionResult<Integer> tickCallback(World world) {
        int needed;
        if (!this.open) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)0);
        }
        if (!((ItemStack)this.inventory.get(2)).func_190926_b() && (needed = (int)ElectricItem.manager.charge(this.getInventoryStack(), ElectricItem.manager.getCharge((ItemStack)this.inventory.get(2)), 1, true, false)) > 0) {
            ElectricItem.manager.discharge((ItemStack)this.inventory.get(2), needed, Integer.MAX_VALUE, true, false, false);
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b() && ((ItemStack)this.inventory.get(0)).func_77973_b() instanceof ICropSeed) {
            ICropSeed seed = (ICropSeed)((ItemStack)this.inventory.get(0)).func_77973_b();
            int lvl = seed.getScannedFromStack((ItemStack)this.inventory.get(0));
            if (lvl == 4) {
                this.inventory.set(1, this.inventory.get(0));
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            } else if (ElectricItem.manager.use(this.getInventoryStack(), neededEnergy[lvl], (EntityLivingBase)this.openPlayer)) {
                seed.incrementScannedFromStack((ItemStack)this.inventory.get(0));
                this.inventory.set(1, this.inventory.get(0));
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)5);
    }

    public int getScannedLevel() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return -1;
        }
        return ((ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b()).getScannedFromStack((ItemStack)this.inventory.get(1));
    }

    public CropCard getCrop() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return null;
        }
        return ((ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b()).getCropFromStack((ItemStack)this.inventory.get(1));
    }

    public String getSeedName() {
        return Ic2Crops.instance.getCropName((ItemStack)this.inventory.get(1)).getLocalized();
    }

    public String getSeedDiscovered() {
        CropCard card = this.getCrop();
        if (card == null) {
            return null;
        }
        return card.getDiscoveredBy();
    }

    public String getSeedDesc(int i) {
        CropCard card = this.getCrop();
        if (card == null) {
            return null;
        }
        return card.desc(i);
    }

    public int getSeedGrowth() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return -1;
        }
        return ((ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b()).getGrowthFromStack((ItemStack)this.inventory.get(1));
    }

    public int getSeedGain() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return -1;
        }
        return ((ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b()).getGainFromStack((ItemStack)this.inventory.get(1));
    }

    public int getSeedResistence() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return -1;
        }
        return ((ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b()).getResistanceFromStack((ItemStack)this.inventory.get(1));
    }

    public String getSeedTier() {
        CropCard card = this.getCrop();
        if (card == null) {
            return tiers[0];
        }
        int tier = card.getProperties().getTier();
        if (tier >= tiers.length) {
            tier = 0;
        }
        return tiers[tier];
    }
}

