/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.crop;

import ic2.core.IC2;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMugBooze
extends ItemIC2
implements IBootable,
IAdvancedTexturedItem {
    public PotionEffect[] effects = new PotionEffect[]{new PotionEffect(MobEffects.field_76431_k, 1200, 0), new PotionEffect(MobEffects.field_76440_q, 2400, 0), new PotionEffect(MobEffects.field_76436_u, 2400, 0), new PotionEffect(MobEffects.field_76436_u, 200, 2)};
    public ModelResourceLocation[] textures = new ModelResourceLocation[8];
    public Potion[] beerEffects = new Potion[]{MobEffects.field_76420_g, MobEffects.field_76421_d, MobEffects.field_76429_m, MobEffects.field_76431_k};
    public String[] statLvls = new String[]{"lightDrunk", "medDrunk", "badDrunk", "deadlyDrunk"};
    public int[] baseDuration = new int[]{600, 900, 1200, 1600, 2000, 2400, 2800};
    public float[] baseIntensity = new float[]{0.4f, 0.75f, 1.0f, 1.5f, 2.0f};
    public static float rumStackability = 2.0f;
    public static int rumDuration = 2400;

    public ItemMugBooze() {
        this.func_77627_a(true);
        this.setTranslationKey(Ic2ItemLang.beerItem);
        this.func_77625_d(16);
    }

    @Override
    public void onLoad() {
        Ic2Items.mugBooze = new ItemStack((Item)this, 1, 0);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);
    }

    @Override
    public int getTextureEntry(int meta) {
        if (meta < 2) {
            return 180;
        }
        return 179 + meta;
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        int meta = stack.func_77960_j();
        String name = stack.func_77977_a();
        ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this);
        this.textures[meta] = new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1) + meta, "inventory");
        return this.textures[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        ByteShifter shifter = new ByteShifter(stack.func_77960_j());
        int meta = shifter.readInt(2);
        if (meta == 1) {
            return this.textures[1 + shifter.readInt(3)];
        }
        if (meta == 2) {
            return this.textures[7];
        }
        return this.textures[0];
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        ByteShifter shifter = new ByteShifter(stack.func_77960_j());
        int type = shifter.readInt(2);
        if (type == 1) {
            int time = shifter.readInt(3);
            if (time == 5) {
                return Ic2ItemLang.beerBlack;
            }
            return Ic2ItemLang.beerBuilder;
        }
        if (type == 2) {
            return Ic2ItemLang.beerRum;
        }
        return Ic2ItemLang.beerZero;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        ByteShifter shifter = new ByteShifter(stack.func_77960_j());
        int type = shifter.readInt(2);
        if (type == 1) {
            int time = shifter.readInt(3);
            if (time == 5) {
                return super.func_77653_i(stack);
            }
            int hops = shifter.readInt(3);
            int solid = shifter.readInt(3);
            return Ic2ItemLang.beerBuilder.getLocalizedFormatted(ItemMugBooze.getSolidComp(solid), ItemMugBooze.getHopsComp(hops), ItemMugBooze.getTimeComp(time));
        }
        return super.func_77653_i(stack);
    }

    public static LocaleComp getSolidComp(int type) {
        switch (type) {
            case 0: {
                return Ic2ItemLang.beerSolidWatery;
            }
            case 1: {
                return Ic2ItemLang.beerSolidClear;
            }
            case 2: {
                return Ic2ItemLang.beerSolidLite;
            }
            case 4: {
                return Ic2ItemLang.beerSolidStrong;
            }
            case 5: {
                return Ic2ItemLang.beerSolidThick;
            }
            case 6: {
                return Ic2ItemLang.beerSolidStodge;
            }
            case 7: {
                return Ic2ItemLang.beerX;
            }
        }
        return Ic2Lang.nullKey;
    }

    public static LocaleComp getHopsComp(int type) {
        switch (type) {
            case 0: {
                return Ic2ItemLang.beerHopsSoup;
            }
            case 1: {
                return Ic2ItemLang.beerHopsAlcfree;
            }
            case 2: {
                return Ic2ItemLang.beerHopsWhite;
            }
            case 4: {
                return Ic2ItemLang.beerHopsDark;
            }
            case 5: {
                return Ic2ItemLang.beerHopsFull;
            }
            case 6: {
                return Ic2ItemLang.beerHopsBlack;
            }
            case 7: {
                return Ic2ItemLang.beerX;
            }
        }
        return Ic2Lang.nullKey;
    }

    public static LocaleComp getTimeComp(int type) {
        switch (type) {
            case 0: {
                return Ic2ItemLang.beerTimeBrew;
            }
            case 1: {
                return Ic2ItemLang.beerTimeYoungster;
            }
            case 2: {
                return Ic2ItemLang.beerTimeBeer;
            }
            case 3: {
                return Ic2ItemLang.beerTimeAle;
            }
            case 4: {
                return Ic2ItemLang.beerTimeDragonblood;
            }
        }
        return Ic2ItemLang.beerX;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer) || worldIn.field_72995_K) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        ByteShifter shifter = new ByteShifter(stack.func_77960_j());
        int type = shifter.readInt(2);
        if (type == 0) {
            stack.func_190918_g(1);
            this.addMugToPlayer(player);
            return stack;
        }
        if (type == 1) {
            int time = shifter.readInt(3);
            if (time == 5) {
                return this.drinkBlackStuff(stack, player);
            }
            int hops = shifter.readInt(3);
            int solid = shifter.readInt(3);
            int duration = this.baseDuration[solid];
            float intensity = this.baseIntensity[time];
            player.func_71024_bL().func_75122_a(6 - hops, (float)solid * 0.15f);
            int max = (int)(intensity * ((float)hops * 0.5f));
            PotionEffect effect = player.func_70660_b(MobEffects.field_76419_f);
            int lvl = effect != null ? effect.func_76458_c() : -1;
            this.amplifyEffect(player, MobEffects.field_76419_f, max, intensity, duration);
            int i = 0;
            while (lvl > -1) {
                int realMax = this.getMax(i, max);
                if (i > 3) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, player.field_70170_p.field_73012_v.nextInt(3)));
                    IC2.achievements.issueStat(player, "deadlyDrunk");
                } else if (i <= 3) {
                    this.amplifyEffect(player, this.beerEffects[i], realMax, intensity, duration);
                    if (i > 0) {
                        IC2.achievements.issueStat(player, this.statLvls[i - 1]);
                    }
                }
                --lvl;
                ++i;
            }
            stack.func_190918_g(1);
            this.addMugToPlayer(player);
            return stack;
        }
        if (type == 2) {
            int progress = shifter.readInt(7);
            if (progress < 100) {
                return this.drinkBlackStuff(stack, player);
            }
            this.amplifyEffect(player, MobEffects.field_76426_n, 0, rumStackability, rumDuration);
            PotionEffect effect = player.func_70660_b(MobEffects.field_76429_m);
            int lvl = effect != null ? effect.func_76458_c() : -1;
            this.amplifyEffect(player, MobEffects.field_76429_m, 2, rumStackability, rumDuration);
            if (lvl >= 0) {
                this.amplifyEffect(player, MobEffects.field_76440_q, 0, rumStackability, rumDuration);
            }
            if (lvl >= 1) {
                this.amplifyEffect(player, MobEffects.field_76431_k, 0, rumStackability, rumDuration);
            }
            stack.func_190918_g(1);
            this.addMugToPlayer(player);
            return stack;
        }
        return stack;
    }

    public int getMax(int lvl, int max) {
        switch (lvl) {
            case 1: {
                return max / 2;
            }
            case 2: {
                return max - 1;
            }
            case 3: {
                return 0;
            }
        }
        return max;
    }

    public void amplifyEffect(EntityPlayer player, Potion potion, int max, float intensity, int duration) {
        PotionEffect eff = player.func_70660_b(potion);
        if (eff == null) {
            player.func_70690_d(new PotionEffect(potion, duration, 0));
        } else {
            int newdur = eff.func_76459_b();
            int maxnewdur = (int)((float)duration * (1.0f + intensity * 2.0f) - (float)newdur) / 2;
            if (maxnewdur < 0) {
                maxnewdur = 0;
            }
            if (maxnewdur < duration) {
                duration = maxnewdur;
            }
            newdur += duration;
            int newamp = eff.func_76458_c();
            if (newamp < max) {
                ++newamp;
            }
            player.func_70690_d(new PotionEffect(potion, newdur, newamp));
        }
    }

    public void addMugToPlayer(EntityPlayer player) {
        if (player.field_71071_by.func_70441_a(Ic2Items.emptyMug.func_77946_l())) {
            player.field_71070_bA.func_75142_b();
        } else {
            player.func_71019_a(Ic2Items.emptyMug.func_77946_l(), false);
        }
    }

    public ItemStack drinkBlackStuff(ItemStack stack, EntityPlayer entity) {
        int rand = entity.field_70170_p.field_73012_v.nextInt(6);
        if (rand == 5) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, entity.field_70170_p.field_73012_v.nextInt(4)));
        } else if (rand != 0) {
            entity.func_70690_d(new PotionEffect(this.effects[rand - 1]));
        }
        if (!stack.func_190926_b()) {
            stack.func_190918_g(1);
        }
        this.addMugToPlayer(entity);
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != CreativeTabs.field_78027_g) {
            return;
        }
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                for (int z = 0; z < 6; ++z) {
                    items.add((Object)this.createStack(x, y, z));
                }
            }
        }
    }

    private ItemStack createStack(int x, int y, int z) {
        ItemStack stack = Ic2Items.mugBooze.func_77946_l();
        ByteShifter shifter = new ByteShifter();
        shifter.writeInteger(x, 3);
        shifter.writeInteger(y, 3);
        shifter.writeInteger(z, 3);
        shifter.writeInteger(1, 2);
        stack.func_77964_b(shifter.getEncodedData());
        return stack;
    }
}

