/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import ic2.core.item.armor.base.ItemIC2ShieldBase;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ItemNanoShield
extends ItemIC2ShieldBase
implements IDamagelessElectricItem {
    public ItemNanoShield() {
        this.func_77656_e(0);
        this.setTranslationKey(Ic2ItemLang.nanoShield);
    }

    @Override
    public boolean canBlock(ItemStack item, EntityLivingBase base) {
        return ElectricItem.manager.canUse(item, 50.0);
    }

    @Override
    public void damageShield(ItemStack stack, int amount, EntityLivingBase base) {
        ElectricItem.manager.use(stack, amount * 50, base);
    }

    @Override
    public ResourceLocation getTexture(ItemStack stack) {
        return Ic2Resources.nanoShield;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 100000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 300.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subItems.add((Object)empty);
        subItems.add((Object)full);
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }
}

