/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityMagnetizer
extends TileEntityElecMachine
implements IClickable,
ITickable,
IBitLevelOverride {
    @NetworkField(index=7)
    public boolean upgraded;
    public int ticker = 0;

    public TileEntityMagnetizer() {
        super(0, 32);
        this.maxEnergy = 100;
        this.addNetworkFields("upgraded");
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit16;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.upgraded = nbt.func_74767_n("Upgraded");
        if (this.upgraded) {
            this.maxEnergy = 10000;
            this.maxInput = 128;
            this.tier = 2;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Upgraded", this.upgraded);
        return nbt;
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        ItemStack stack;
        if (!this.upgraded && StackUtil.isStackEqual(stack = player.func_184586_b(hand), Ic2Items.overClockerUpgrade)) {
            if (side == Side.CLIENT) {
                return true;
            }
            stack.func_190918_g(1);
            player.field_71069_bz.func_75142_b();
            this.upgraded = true;
            this.setMaxEnergy(10000);
            this.setTier(2);
            this.getNetwork().updateTileEntityField(this, "upgraded");
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> list = super.getDrops();
        if (this.upgraded) {
            list.add(Ic2Items.overClockerUpgrade.func_77946_l());
        }
        return list;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        int needed;
        int meta;
        IBlockState state;
        BlockPos targetPos;
        if (this.energy <= 0 || this.ticker-- > 0) {
            return;
        }
        this.handleRedstone();
        if (this.isRedstonePowered()) {
            this.ticker = 20;
            return;
        }
        boolean change = false;
        int y = this.field_174879_c.func_177956_o();
        int i = 1;
        while (this.isInRange(i, false)) {
            targetPos = this.func_174877_v().func_177979_c(i);
            state = this.field_145850_b.func_180495_p(targetPos);
            meta = state.func_177230_c().func_176201_c(state);
            needed = 15 - meta;
            if (needed > 0) {
                if (this.upgraded) {
                    needed *= 10;
                }
                change = true;
                if (needed > this.energy) {
                    needed = this.energy;
                }
                this.field_145850_b.func_175656_a(targetPos, state.func_177230_c().func_176203_a(meta + (this.upgraded ? needed / 10 : needed)));
                this.getNetwork().announceBlockUpdate(this.field_145850_b, targetPos);
                this.energy -= needed;
            }
            ++i;
        }
        i = 1;
        while (this.isInRange(i, true)) {
            targetPos = this.func_174877_v().func_177981_b(i);
            state = this.field_145850_b.func_180495_p(targetPos);
            meta = state.func_177230_c().func_176201_c(state);
            needed = 15 - meta;
            if (needed > 0) {
                if (this.upgraded) {
                    needed *= 10;
                }
                change = true;
                if (needed > this.energy) {
                    needed = this.energy;
                }
                this.field_145850_b.func_175656_a(targetPos, state.func_177230_c().func_176203_a(meta + (this.upgraded ? needed / 10 : needed)));
                this.getNetwork().announceBlockUpdate(this.field_145850_b, targetPos);
                this.energy -= needed;
            }
            ++i;
        }
        if (!change) {
            this.ticker = 20;
        } else {
            this.getNetwork().updateTileGuiField(this, "energy");
        }
    }

    public boolean isInRange(int i, boolean up) {
        if (!this.upgraded && i > 20) {
            return false;
        }
        if (this.energy < (this.upgraded ? 10 : 1)) {
            return false;
        }
        if (up) {
            if (this.field_174879_c.func_177956_o() + i < this.field_145850_b.field_73011_w.getHeight()) {
                return this.field_145850_b.func_180495_p(this.func_174877_v().func_177981_b(i)).func_177230_c() == Ic2States.ironFence.func_177230_c();
            }
        } else if (this.field_174879_c.func_177956_o() - i > 0) {
            return this.field_145850_b.func_180495_p(this.func_174877_v().func_177979_c(i)).func_177230_c() == Ic2States.ironFence.func_177230_c();
        }
        return false;
    }
}

