/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.audio;

import ic2.api.classic.audio.AudioPosition;
import ic2.api.classic.audio.IAudioPosition;
import ic2.api.classic.audio.ISoundModifier;
import ic2.api.classic.audio.ISoundProvider;
import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.audio.AudioManager;
import ic2.core.audio.AudioSource;
import ic2.core.audio.AudioSourceClient;
import ic2.core.audio.ISoundTracker;
import ic2.core.audio.SoundWrapperEntity;
import ic2.core.audio.SoundWrapperTileEntity;
import ic2.core.item.sounds.BatteryClickHandler;
import ic2.core.item.sounds.ChainsawHandler;
import ic2.core.item.sounds.JetpackTrackHandler;
import ic2.core.item.sounds.NanoSaberTracker;
import ic2.core.util.obj.IMetaSoundBlock;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import paulscode.sound.SoundSystem;

public class AudioManagerClient
extends AudioManager
implements IResourceManagerReloadListener {
    private boolean enabled = true;
    private boolean lateInitDone = false;
    private SoundSystem soundSystem = null;
    private SoundHandler handler = null;
    private float masterVolume = 0.5f;
    private float blockMasterVolume = 1.0f;
    private float currentItemMasterVolume = 1.0f;
    private float currentBackpackMasterVolume = 1.0f;
    private int nextID = 0;
    private boolean tick = false;
    public boolean markForRemoving = false;
    private Map<ISoundProvider, List<AudioSource>> objectToAudioSourceMap = new LinkedHashMap<ISoundProvider, List<AudioSource>>();
    private Set<ISoundProvider> soundsToRemove = new LinkedHashSet<ISoundProvider>();
    private List<ISoundTracker> trackers = new LinkedList<ISoundTracker>();
    private List<ISoundModifier> modifiers = new LinkedList<ISoundModifier>();

    public AudioManagerClient() {
        this.defaultVolume = 1.0f;
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initialize() {
        this.updateConfig();
    }

    public void updateConfig() {
        this.enabled = IC2.config.getFlag("enableSounds");
        this.masterVolume = IC2.config.getFloat("masterVolume");
        this.blockMasterVolume = IC2.config.getFloat("blockMasterVolume");
        this.currentItemMasterVolume = IC2.config.getFloat("currentItemMasterVolume");
        this.currentBackpackMasterVolume = IC2.config.getFloat("currentBackpackMasterVolume");
    }

    public void updateSound(float f) {
        boolean lastEnabled = this.enabled;
        this.masterVolume = f;
        IC2.config.setValue("masterVolume", this.masterVolume);
        if (this.masterVolume <= 0.0f) {
            this.enabled = false;
        } else if (this.masterVolume > 0.0f) {
            this.enabled = true;
        }
        if (lastEnabled != this.enabled) {
            IC2.config.setValue("enableSounds", this.enabled);
        }
    }

    public void updateSoundType(float f, PositionSpec type) {
        switch (type) {
            case Backpack: {
                this.currentBackpackMasterVolume = f;
                IC2.config.setValue("currentBackpackMasterVolume", this.masterVolume);
                break;
            }
            case Center: {
                this.blockMasterVolume = f;
                IC2.config.setValue("blockMasterVolume", this.masterVolume);
                break;
            }
            case Hand: {
                this.currentItemMasterVolume = f;
                IC2.config.setValue("currentItemMasterVolume", this.masterVolume);
            }
        }
    }

    @Override
    public void addModifier(ISoundModifier mod) {
        if (mod == null) {
            return;
        }
        this.modifiers.add(mod);
    }

    @Override
    public void removeModifier(ISoundModifier mod) {
        if (mod == null) {
            return;
        }
        this.modifiers.remove(mod);
    }

    @Override
    public void playOnce(Object obj, ResourceLocation soundFile) {
        this.playOnce(obj, PositionSpec.Center, soundFile, false, this.getDefaultVolume());
    }

    @Override
    public void playOnce(Object obj, PositionSpec positionSpec, ResourceLocation soundFile, boolean priorized, float volume) {
        URL url;
        if (!this.enabled) {
            return;
        }
        if (this.getMasterVolume() <= 0.0f || this.getVolumeForType(positionSpec) <= 0.0f) {
            return;
        }
        if (this.soundSystem == null || this.soundSystem.randomNumberGenerator == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return;
        }
        IAudioPosition audioPos = AudioPosition.getFrom(obj, positionSpec);
        if (audioPos == null) {
            return;
        }
        if (this.isMinecraftSound(soundFile)) {
            soundFile = this.fixMinecraftSound(soundFile);
        }
        if ((url = AudioManagerClient.getURLForSoundResource(soundFile)) == null) {
            IC2.log.warn("Invalid sound file: " + soundFile);
            return;
        }
        volume *= this.getMasterVolume();
        Vec3d pos = audioPos.getPosition();
        String sourceName = this.soundSystem.quickPlay(priorized, url, soundFile.toString(), false, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, 2, 16.0f * Math.max(volume *= this.getVolumeForType(positionSpec), 0.2f));
        this.soundSystem.setVolume(sourceName, volume);
    }

    @Override
    public void removeSources(Object obj) {
        if (this.soundSystem == null) {
            return;
        }
        ISoundProvider provider = this.createProvider(obj, PositionSpec.Center);
        if (provider == null) {
            return;
        }
        if (this.tick) {
            this.soundsToRemove.add(provider);
            return;
        }
        List<AudioSource> source = this.objectToAudioSourceMap.remove(provider);
        if (source != null) {
            for (AudioSource entry : source) {
                entry.remove();
            }
        }
    }

    @Override
    public AudioSource createSource(Object obj, ResourceLocation soundFile) {
        return this.createSource(obj, PositionSpec.Center, soundFile, false, false, this.getDefaultVolume());
    }

    @Override
    public AudioSource createSource(Object obj, PositionSpec positionSpec, ResourceLocation soundFile, boolean loop, boolean priorized, float volume) {
        URL url;
        if (!this.enabled) {
            return null;
        }
        if (this.getMasterVolume() <= 0.0f || this.getVolumeForType(positionSpec) <= 0.0f) {
            return null;
        }
        if (this.soundSystem == null || this.soundSystem.randomNumberGenerator == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return null;
        }
        if (this.isMinecraftSound(soundFile)) {
            soundFile = this.fixMinecraftSound(soundFile);
        }
        if ((url = AudioManagerClient.getURLForSoundResource(soundFile)) == null) {
            IC2.log.warn("Invalid sound file: " + soundFile);
            return null;
        }
        ISoundProvider provider = this.createProvider(obj, positionSpec);
        if (provider == null) {
            return null;
        }
        volume *= this.getMasterVolume();
        String id = "ic2_cls" + this.nextID;
        ++this.nextID;
        AudioSourceClient audioSource = new AudioSourceClient(this, this.soundSystem, id, provider, positionSpec, url, soundFile, loop, priorized, volume *= this.getVolumeForType(positionSpec), this.getDefaultPitch());
        List<AudioSource> source = this.objectToAudioSourceMap.get(provider);
        if (source == null) {
            source = new LinkedList<AudioSource>();
            this.objectToAudioSourceMap.put(provider, source);
        }
        source.add(audioSource);
        return audioSource;
    }

    public void updateModifiers(World world) {
        if (world == null) {
            return;
        }
        Iterator<ISoundModifier> modIter = this.modifiers.iterator();
        while (modIter.hasNext()) {
            ISoundModifier mod = modIter.next();
            if (mod.isModifierValid(world)) {
                mod.onAudioTick(world);
                continue;
            }
            modIter.remove();
        }
    }

    @Override
    public void onTick() {
        this.updateModifiers((World)Minecraft.func_71410_x().field_71441_e);
        if (!this.enabled || this.soundSystem == null) {
            return;
        }
        if (this.soundSystem.randomNumberGenerator == null) {
            return;
        }
        EntityPlayer player = IC2.platform.getPlayerInstance();
        if (player == null || this.markForRemoving || Minecraft.func_71410_x().func_147113_T()) {
            this.tick = false;
            ArrayList<ISoundProvider> providers = new ArrayList<ISoundProvider>(this.objectToAudioSourceMap.keySet());
            for (ISoundProvider obj : providers) {
                this.removeSources(obj);
            }
            if (player == null) {
                this.modifiers.clear();
                this.trackers.clear();
            }
            this.markForRemoving = false;
        } else {
            this.tick = true;
            World world = player.field_70170_p;
            List<AudioSource> sounds = new LinkedList<AudioSource>();
            for (Map.Entry<ISoundProvider, List<AudioSource>> entry : this.objectToAudioSourceMap.entrySet()) {
                try {
                    ISoundProvider prov = entry.getKey();
                    if (!prov.isValid(world)) {
                        this.removeSources(prov);
                        continue;
                    }
                    Iterator<AudioSource> soundIter = entry.getValue().iterator();
                    while (soundIter.hasNext()) {
                        AudioSource audio = soundIter.next();
                        if (audio.isRemoved()) {
                            soundIter.remove();
                            continue;
                        }
                        audio.updatePosition();
                        audio.updateVolume(player);
                        if (!audio.isEnabled() || !this.matchDimension(world, audio.getPosition())) continue;
                        sounds.add(audio);
                    }
                    if (!entry.getValue().isEmpty()) continue;
                    this.removeSources(prov);
                }
                catch (Exception prov) {}
            }
            sounds = this.sortAudioList(sounds);
            int counter = 0;
            for (AudioSource source : sounds) {
                if (counter < 20) {
                    source.enable();
                } else {
                    source.dissable();
                }
                ++counter;
            }
            this.tick = false;
            for (ISoundProvider prov : this.soundsToRemove) {
                this.removeSources(prov);
            }
            this.soundsToRemove.clear();
        }
    }

    public List<AudioSource> sortAudioList(List<AudioSource> sounds) {
        float minValue = Float.MAX_VALUE;
        float maxValue = 0.0f;
        LinkedList<AudioSource> resultList = new LinkedList<AudioSource>();
        block0: for (AudioSource source : sounds) {
            float volume = source.getRealVolume();
            if (resultList.isEmpty()) {
                resultList.add(source);
                minValue = volume;
                maxValue = volume;
                continue;
            }
            if (volume > maxValue) {
                resultList.addFirst(source);
                maxValue = volume;
                continue;
            }
            if (volume < minValue) {
                resultList.addLast(source);
                minValue = volume;
                continue;
            }
            ListIterator<AudioSource> soundIter = resultList.listIterator();
            while (soundIter.hasNext()) {
                AudioSource sound = (AudioSource)soundIter.next();
                if (!(sound.getRealVolume() < volume)) continue;
                soundIter.add(source);
                continue block0;
            }
        }
        return resultList;
    }

    @Override
    public void onPostTick() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Iterator<ISoundTracker> iterator = this.trackers.iterator();
        while (iterator.hasNext()) {
            ISoundTracker tracker = iterator.next();
            if (tracker.isValid((World)world)) {
                tracker.onTick();
                continue;
            }
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void onSoundPlays(PlaySoundEvent event) {
        SoundType metaSound;
        World world;
        IBlockState state;
        ISound sound = event.getSound();
        if (sound == null) {
            return;
        }
        String name = event.getName();
        int type = -1;
        if (name.endsWith(".break")) {
            type = 1;
        } else if (name.endsWith(".step")) {
            type = 2;
        }
        if (type != -1 && (state = (world = IC2.platform.getClientWorld()).func_180495_p(new BlockPos((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()))) != null && state.func_177230_c() instanceof IMetaSoundBlock && (metaSound = ((IMetaSoundBlock)state.func_177230_c()).getSoundFromState(state)) != null) {
            SoundEvent resultSound = type == 1 ? metaSound.func_185845_c() : metaSound.func_185844_d();
            event.setResultSound(null);
            AudioPosition pos = new AudioPosition(world, sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
            this.playOnce(pos, resultSound.func_187503_a());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (IC2.platform.isSimulating()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.trackers.add(new BatteryClickHandler(player));
            this.trackers.add(new JetpackTrackHandler(player));
            this.trackers.add(new NanoSaberTracker(player));
        }
        if (entity instanceof EntityLivingBase) {
            this.trackers.add(new ChainsawHandler((EntityLivingBase)entity));
        }
    }

    public void addSoundTracker(ISoundTracker tracker) {
        if (tracker == null) {
            return;
        }
        this.trackers.add(tracker);
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    @Override
    public float getDefaultVolume() {
        return 1.2f;
    }

    @Override
    public float getDefaultPitch() {
        return 1.0f;
    }

    @Override
    public float getVolumeForType(PositionSpec type) {
        switch (type) {
            case Backpack: {
                return this.currentBackpackMasterVolume;
            }
            case Center: {
                return this.blockMasterVolume;
            }
            case Hand: {
                return this.currentItemMasterVolume;
            }
        }
        return 0.0f;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        for (ISoundProvider prov : new LinkedHashSet<ISoundProvider>(this.objectToAudioSourceMap.keySet())) {
            this.removeSources(prov);
        }
        this.soundSystem = null;
        this.handler = null;
    }

    private void getSoundSystem() {
        this.func_110549_a(null);
        try {
            SoundManager manager = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (int)5);
            this.handler = manager.field_148622_c;
            this.soundSystem = (SoundSystem)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)manager, (int)5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isMinecraftSound(ResourceLocation par1) {
        if (this.handler == null) {
            return false;
        }
        return this.handler.func_184398_a(par1) != null;
    }

    private ResourceLocation fixMinecraftSound(ResourceLocation par1) {
        if (this.handler == null) {
            return par1;
        }
        SoundEventAccessor accessor = this.handler.func_184398_a(par1);
        if (accessor == null) {
            return par1;
        }
        Sound sound = accessor.func_148720_g();
        if (sound == null) {
            return par1;
        }
        return sound.func_188721_b();
    }

    private boolean matchDimension(World world, IAudioPosition source) {
        DimensionType ownerType = this.getDimensionID(source.getWorld());
        DimensionType playerType = this.getDimensionID(world);
        if (ownerType == null || playerType == null) {
            return false;
        }
        return ownerType.func_186068_a() == playerType.func_186068_a();
    }

    private DimensionType getDimensionID(World world) {
        if (world == null) {
            return null;
        }
        return world.field_73011_w.func_186058_p();
    }

    private ISoundProvider createProvider(Object obj, PositionSpec spec) {
        if (obj instanceof ISoundProvider) {
            return (ISoundProvider)obj;
        }
        if (obj instanceof TileEntity) {
            return new SoundWrapperTileEntity((TileEntity)obj);
        }
        if (obj instanceof Entity) {
            return new SoundWrapperEntity(spec, (Entity)obj);
        }
        return null;
    }

    static URL getURLForSoundResource(final ResourceLocation p_148612_0_) {
        try {
            Minecraft.func_71410_x().func_110442_L().func_110536_a(p_148612_0_);
        }
        catch (Exception e) {
            return null;
        }
        String s = String.format("%s:%s:%s", "mcsounddomain", p_148612_0_.func_110624_b(), p_148612_0_.func_110623_a());
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL p_openConnection_1_) {
                return new URLConnection(p_openConnection_1_){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Minecraft.func_71410_x().func_110442_L().func_110536_a(p_148612_0_).func_110527_b();
                    }
                };
            }
        };
        try {
            return new URL((URL)null, s, urlstreamhandler);
        }
        catch (MalformedURLException var4) {
            return null;
        }
    }

    public List<ISoundModifier> getModifiers() {
        return this.modifiers;
    }
}

