/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.schematics;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.transform.Mover;
import ivorius.ivtoolkit.transform.PosTransformer;
import ivorius.ivtoolkit.util.IvStreams;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.temp.RCMover;
import ivorius.reccomplex.temp.RCPosTransformer;
import ivorius.reccomplex.utils.accessor.RCAccessorEntity;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SchematicFile {
    public final List<NBTTagCompound> entityCompounds = new ArrayList<NBTTagCompound>();
    public final List<NBTTagCompound> tileEntityCompounds = new ArrayList<NBTTagCompound>();
    public short width;
    public short height;
    public short length;
    public Short weOriginX;
    public Short weOriginY;
    public Short weOriginZ;
    public IBlockState[] blockStates;

    public SchematicFile() {
    }

    public SchematicFile(short width, short height, short length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.blockStates = new IBlockState[width * height * length];
    }

    public SchematicFile(NBTTagCompound tagCompound) throws UnsupportedSchematicFormatException {
        DataFixer fixer = DataFixesManager.func_188279_a();
        String materials = tagCompound.func_74779_i("Materials");
        if (!materials.equals("Alpha")) {
            throw new UnsupportedSchematicFormatException(materials);
        }
        this.width = tagCompound.func_74765_d("Width");
        this.height = tagCompound.func_74765_d("Height");
        this.length = tagCompound.func_74765_d("Length");
        if (tagCompound.func_150297_b("WEOriginX", 2)) {
            this.weOriginX = tagCompound.func_74765_d("WEOriginX");
        }
        if (tagCompound.func_150297_b("WEOriginY", 2)) {
            this.weOriginY = tagCompound.func_74765_d("WEOriginY");
        }
        if (tagCompound.func_150297_b("WEOriginZ", 2)) {
            this.weOriginZ = tagCompound.func_74765_d("WEOriginZ");
        }
        byte[] metadatas = tagCompound.func_74770_j("Data");
        byte[] blockIDs = tagCompound.func_74770_j("Blocks");
        byte[] addBlocks = tagCompound.func_74770_j("AddBlocks");
        SchematicMapping schematicMapping = tagCompound.func_150297_b("SchematicaMapping", 10) ? new SchematicMapping(tagCompound.func_74775_l("SchematicaMapping")) : null;
        this.blockStates = new IBlockState[blockIDs.length];
        for (int i = 0; i < blockIDs.length; ++i) {
            int blockID = blockIDs[i] & 0xFF;
            if (addBlocks.length >= (blockIDs.length + 1) / 2) {
                boolean lowerNybble = (i & 1) == 0;
                blockID |= lowerNybble ? (addBlocks[i >> 1] & 0xF) << 8 : (addBlocks[i >> 1] & 0xF0) << 4;
            }
            byte metadata = metadatas[i];
            try {
                Block block = schematicMapping != null ? schematicMapping.blockFromID(blockID) : Block.func_149729_e((int)blockID);
                this.blockStates[i] = BlockStates.fromMetadata((Block)block, (int)metadata);
                continue;
            }
            catch (Exception ex) {
                RecurrentComplex.logger.error("Invalid metadata in schematic file: " + blockID + ":" + metadata, (Throwable)ex);
                this.blockStates[i] = Blocks.field_150350_a.func_176223_P();
            }
        }
        NBTTagList entities = tagCompound.func_150295_c("Entities", 10);
        for (int i = 0; i < entities.func_74745_c(); ++i) {
            this.entityCompounds.add(fixer.func_188257_a((IFixType)FixTypes.ENTITY, entities.func_150305_b(i)));
        }
        NBTTagList tileEntities = tagCompound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            this.tileEntityCompounds.add(fixer.func_188257_a((IFixType)FixTypes.BLOCK_ENTITY, tileEntities.func_150305_b(i)));
        }
    }

    public int getBlockIndex(BlockPos pos) {
        return pos.func_177958_n() + (pos.func_177956_o() * this.length + pos.func_177952_p()) * this.width;
    }

    public IBlockState getBlockState(BlockPos coord) {
        if (coord.func_177958_n() < 0 || coord.func_177956_o() < 0 || coord.func_177952_p() < 0 || coord.func_177958_n() >= this.width || coord.func_177956_o() >= this.height || coord.func_177952_p() >= this.length) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.blockStates[this.getBlockIndex(coord)];
    }

    public boolean setBlockState(BlockPos coord, IBlockState state) {
        if (coord.func_177958_n() < 0 || coord.func_177956_o() < 0 || coord.func_177952_p() < 0 || coord.func_177958_n() >= this.width || coord.func_177956_o() >= this.height || coord.func_177952_p() >= this.length) {
            return false;
        }
        this.blockStates[this.getBlockIndex((BlockPos)coord)] = state;
        return true;
    }

    public boolean shouldRenderSide(BlockPos coord, EnumFacing side) {
        return !this.getBlockState(coord.func_177972_a(side)).func_185914_p();
    }

    public void generate(World world, BlockPos pos) {
        this.generate(world, pos, AxisAlignedTransform2D.ORIGINAL);
    }

    public void generate(World world, BlockPos origin, AxisAlignedTransform2D transform) {
        int[] areaSize = new int[]{this.width, this.height, this.length};
        HashMap<BlockPos, TileEntity> tileEntities = new HashMap<BlockPos, TileEntity>();
        for (NBTTagCompound nBTTagCompound : this.tileEntityCompounds) {
            BlockPos src;
            BlockPos dest;
            NBTTagCompound nBTTagCompound2 = RCMover.setTileEntityPos(nBTTagCompound, dest = transform.apply(src = RCMover.getTileEntityPos(nBTTagCompound), areaSize).func_177971_a((Vec3i)origin));
            TileEntity tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)nBTTagCompound2);
            if (tileEntity == null) continue;
            tileEntities.put(src, tileEntity);
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (BlockPos sourcePos : this.area()) {
                int index = this.getBlockIndex(sourcePos);
                IBlockState blockState = PosTransformer.transformBlockState((IBlockState)this.blockStates[index], (AxisAlignedTransform2D)transform);
                if (blockState == null || this.getPass(blockState) != pass) continue;
                BlockPos worldPos = origin.func_177971_a((Vec3i)transform.apply(sourcePos, areaSize));
                world.func_180501_a(worldPos, blockState, 2);
                TileEntity tileEntity = (TileEntity)tileEntities.get(sourcePos);
                if (tileEntity == null) continue;
                world.func_180501_a(worldPos, blockState, 2);
                RCPosTransformer.transformAdditionalData(tileEntity, transform, areaSize);
                RCMover.moveAdditionalData(tileEntity, origin);
                world.func_175690_a(worldPos, tileEntity);
                tileEntity.func_145836_u();
            }
        }
        for (NBTTagCompound nBTTagCompound : this.entityCompounds) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)nBTTagCompound, (World)world);
            if (entity == null) continue;
            RCAccessorEntity.setEntityUniqueID(entity, UUID.randomUUID());
            PosTransformer.transformEntityPos((Entity)entity, (AxisAlignedTransform2D)transform, (int[])areaSize);
            Mover.moveEntity((Entity)entity, (BlockPos)origin);
            world.func_72838_d(entity);
        }
    }

    @Nonnull
    public BlockArea area() {
        return BlockArea.areaFromSize((BlockPos)BlockPos.field_177992_a, (int[])new int[]{this.width, this.height, this.length});
    }

    private int getPass(IBlockState blockState) {
        return blockState.func_185915_l() || blockState.func_185904_a() == Material.field_151579_a ? 0 : 1;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Materials", "Alpha");
        tagCompound.func_74777_a("Width", this.width);
        tagCompound.func_74777_a("Height", this.height);
        tagCompound.func_74777_a("Length", this.length);
        if (this.weOriginX != null) {
            tagCompound.func_74777_a("WEOriginX", this.weOriginX.shortValue());
        }
        if (this.weOriginY != null) {
            tagCompound.func_74777_a("WEOriginY", this.weOriginY.shortValue());
        }
        if (this.weOriginZ != null) {
            tagCompound.func_74777_a("WEOriginZ", this.weOriginZ.shortValue());
        }
        tagCompound.func_74773_a("Data", IvStreams.toByteArray((IntStream)Stream.of(this.blockStates).mapToInt(BlockStates::toMetadata)));
        byte[] blockIDs = new byte[this.blockStates.length];
        byte[] addBlocks = new byte[(this.blockStates.length + 1) / 2];
        SchematicMapping schematicMapping = new SchematicMapping();
        for (int i = 0; i < this.blockStates.length; ++i) {
            Block block = this.blockStates[i].func_177230_c();
            int blockID = this.getBlockID(block);
            schematicMapping.putBlock(blockID, block);
            blockIDs[i] = (byte)(blockID & 0xFF);
            boolean lowerNybble = (i & 1) == 0;
            int n = i >> 1;
            addBlocks[n] = (byte)(addBlocks[n] | (lowerNybble ? (byte)(blockID >> 8 & 0xF) : (byte)(blockID >> 4 & 0xF0)));
        }
        tagCompound.func_74773_a("Blocks", blockIDs);
        tagCompound.func_74773_a("AddBlocks", addBlocks);
        tagCompound.func_74782_a("SchematicaMapping", (NBTBase)schematicMapping.writeToNBT());
        NBTTagList entities = new NBTTagList();
        this.entityCompounds.forEach(arg_0 -> ((NBTTagList)entities).func_74742_a(arg_0));
        tagCompound.func_74782_a("Entities", (NBTBase)entities);
        NBTTagList tileEntitites = new NBTTagList();
        this.tileEntityCompounds.forEach(arg_0 -> ((NBTTagList)entities).func_74742_a(arg_0));
        tagCompound.func_74782_a("TileEntities", (NBTBase)tileEntitites);
    }

    private int getBlockID(Block block) {
        return Block.field_149771_c.func_148757_b((Object)block);
    }

    public static class UnsupportedSchematicFormatException
    extends Exception {
        public final String format;

        public UnsupportedSchematicFormatException(Throwable cause, String format) {
            super("Unsupported Schematic Format: " + format, cause);
            this.format = format;
        }

        public UnsupportedSchematicFormatException(String format) {
            this.format = format;
        }
    }
}

