/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellPresetAction;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableCells {
    public static Float toFloat(Double value) {
        return value != null ? Float.valueOf((float)value.doubleValue()) : null;
    }

    public static Double toDouble(Float value) {
        return value != null ? Double.valueOf(value.floatValue()) : null;
    }

    public static void reloadExcept(TableDelegate delegate, String ... cellIDs) {
        for (String cell : cellIDs) {
            delegate.setLocked(cell, true);
        }
        delegate.reloadData();
        for (String cell : cellIDs) {
            delegate.setLocked(cell, false);
        }
    }

    @Nonnull
    public static TableCellButton edit(boolean enabled, TableNavigator navigator, TableDelegate tableDelegate, Supplier<TableDataSource> table) {
        TableCellButton edit = new TableCellButton(null, "edit", IvTranslations.get((String)"reccomplex.gui.edit"), enabled){

            @Override
            public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
                super.draw(screen, mouseX, mouseY, partialTicks);
                int color = 0xE0E0E0;
                if (!this.enabled) {
                    color = 0xA0A0A0;
                } else if (this.button != null && this.button.func_146115_a()) {
                    color = 0xFFFFA0;
                }
                String right = "...";
                int rightWidth = this.getFontRenderer().func_78256_a(right);
                this.getFontRenderer().func_175065_a(right, (float)(this.bounds().getMaxX() - 8 - rightWidth), (float)(this.bounds().getCenterY() - 4), color, true);
            }
        };
        edit.addAction(() -> navigator.pushTable(new GuiTable(tableDelegate, (TableDataSource)table.get())));
        return edit;
    }

    @Nonnull
    public static List<TableCellButton> addManyWithBase(Collection<String> ids, String baseKey, boolean enabled) {
        return TableCellPresetAction.sorted(ids.stream().map(type -> TableCells.add(enabled, type, IvTranslations.get((String)(baseKey + type)), TableCells.getTooltip(baseKey, type)))).collect(Collectors.toList());
    }

    @Nonnull
    public static List<String> getTooltip(String baseKey, String type) {
        return IvTranslations.formatLines((String)(baseKey + type + ".tooltip"), (Object[])new Object[0]);
    }

    @Nonnull
    public static TableCellButton add(boolean enabled, String id, String title, List<String> tooltip) {
        return new TableCellButton(id, id, title, (List)tooltip, enabled){

            @Override
            public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
                super.draw(screen, mouseX, mouseY, partialTicks);
                int color = 3462470;
                if (!this.enabled) {
                    color = 8952462;
                } else if (this.button != null && this.button.func_146115_a()) {
                    color = 3928912;
                }
                String plus = "+";
                int plusWidth = this.getFontRenderer().func_78256_a(plus);
                this.getFontRenderer().func_175065_a(plus, (float)(this.bounds().getMinX() + 6), (float)(this.bounds().getCenterY() - 4), color, true);
                this.getFontRenderer().func_175065_a(plus, (float)(this.bounds().getMaxX() - 6 - plusWidth), (float)(this.bounds().getCenterY() - 4), color, true);
            }
        };
    }
}

