/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.client.rendering;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.rendering.grid.GridQuadCache;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.client.rendering.OperationRenderer;
import ivorius.reccomplex.gui.GuiHider;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class SelectionQuadCache {

    public static class Visualizer
    implements GuiHider.Visualizer {
        public static final String NULL_PLACEHOLDER = "_null_";
        protected GridQuadCache<?> quadCache;
        protected BlockPos lowerCoord;

        public Visualizer(Selection selection, MazeVisualizationContext context) {
            Selection realWorldSelection = context.mapSelection(selection);
            this.lowerCoord = BlockPositions.fromIntArray((int[])realWorldSelection.boundsLower());
            Map<MazeRoom, String> compiled = realWorldSelection.compile(true);
            Map<BlockPos, String> coords = compiled.entrySet().stream().collect(Collectors.toMap(e -> BlockPositions.fromIntArray((int[])((MazeRoom)e.getKey()).getCoordinates()).func_177973_b((Vec3i)this.lowerCoord), e -> e.getValue() != null ? (String)e.getValue() : NULL_PLACEHOLDER));
            this.quadCache = GridQuadCache.createQuadCache((int[])realWorldSelection.boundsSize(), (float[])new float[]{1.0f, 1.0f, 1.0f}, input -> {
                BlockPos coord = (BlockPos)input.getLeft();
                EnumFacing direction = (EnumFacing)input.getRight();
                String cur = (String)coords.get(coord);
                return cur != null && !Objects.equals(coords.get(coord.func_177972_a(direction)), cur) ? cur : null;
            });
        }

        @Override
        public void draw(Entity renderEntity, float partialTicks) {
            GlStateManager.func_179124_c((float)0.8f, (float)0.75f, (float)0.5f);
            OperationRenderer.renderGridQuadCache(this.quadCache, AxisAlignedTransform2D.ORIGINAL, this.lowerCoord, renderEntity.field_70173_aa, partialTicks);
        }
    }
}

