/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.capability;

import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.capability.SelectionOwner;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class CapabilitySelection
implements NBTCompoundObject,
PartialUpdateHandler,
SelectionOwner {
    public static final String CAPABILITY_KEY = "rc_selection";
    @CapabilityInject(value=CapabilitySelection.class)
    public static Capability<CapabilitySelection> CAPABILITY;
    private boolean hasChanges;
    public BlockPos selectedPoint1;
    public BlockPos selectedPoint2;

    @Nullable
    public static CapabilitySelection get(ICapabilityProvider provider, @Nullable EnumFacing facing) {
        return (CapabilitySelection)provider.getCapability(CAPABILITY, null);
    }

    public CapabilitySelection() {
    }

    public CapabilitySelection(BlockPos selectedPoint1, BlockPos selectedPoint2) {
        this.selectedPoint1 = selectedPoint1;
        this.selectedPoint2 = selectedPoint2;
    }

    @Override
    @Nullable
    public BlockPos getSelectedPoint1() {
        return this.selectedPoint1;
    }

    @Override
    public void setSelectedPoint1(@Nullable BlockPos pos) {
        this.selectedPoint1 = pos;
        this.hasChanges = true;
    }

    @Override
    @Nullable
    public BlockPos getSelectedPoint2() {
        return this.selectedPoint2;
    }

    @Override
    public void setSelectedPoint2(@Nullable BlockPos pos) {
        this.selectedPoint2 = pos;
        this.hasChanges = true;
    }

    public void sendSelectionToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)CAPABILITY_KEY, null, (String)"selection", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        BlockPositions.writeToNBT((String)"selectedPoint1", (BlockPos)this.selectedPoint1, (NBTTagCompound)compound);
        BlockPositions.writeToNBT((String)"selectedPoint2", (BlockPos)this.selectedPoint2, (NBTTagCompound)compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.selectedPoint1 = BlockPositions.readFromNBT((String)"selectedPoint1", (NBTTagCompound)compound);
        this.selectedPoint2 = BlockPositions.readFromNBT((String)"selectedPoint2", (NBTTagCompound)compound);
        this.hasChanges = true;
    }

    public void update(Entity entity) {
        if (this.hasChanges) {
            this.sendChanges(entity);
        }
    }

    public void sendChanges(Entity entity) {
        this.hasChanges = false;
        this.sendSelectionToClients(entity);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("selection".equals(context)) {
            BlockPositions.maybeWriteToBuffer((BlockPos)this.selectedPoint1, (ByteBuf)buffer);
            BlockPositions.maybeWriteToBuffer((BlockPos)this.selectedPoint2, (ByteBuf)buffer);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("selection".equals(context)) {
            this.selectedPoint1 = BlockPositions.maybeReadFromBuffer((ByteBuf)buffer);
            this.selectedPoint2 = BlockPositions.maybeReadFromBuffer((ByteBuf)buffer);
        }
    }
}

