/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.compat;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.api.BindingEvent;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.core.util.compat.CompatibilityPlugin;
import info.tehnut.soulshardsrespawn.core.util.compat.ICompatibilityPlugin;
import info.tehnut.soulshardsrespawn.item.ItemSoulShard;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@CompatibilityPlugin(value="chickens")
public class ChickensCompatibilityPlugin
implements ICompatibilityPlugin {
    private static final Class<? extends EntityChicken> CHICKEN_CLASS;
    private static final DataParameter<?> TYPE_PARAMETER;
    private static final Map<ResourceLocation, Object> CHICKEN_REGISTRY;
    private static final MethodHandle NAME_GETTER;
    private boolean enabled;

    @Override
    public void preInit() {
        if (this.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void handleConfiguration(Configuration configuration) {
        this.enabled = configuration.getBoolean("differentiateBetweenChickens", "compat.chickens", true, "Runs some horribly hacky code to differentiate between the different chicken types.");
    }

    @SubscribeEvent
    public void getEntityName(BindingEvent.GetEntityName event) {
        if (event.getEntity().getClass() == CHICKEN_CLASS) {
            String chickenType = (String)event.getEntity().func_184212_Q().func_187225_a(TYPE_PARAMETER);
            event.setEntityId(new ResourceLocation(chickenType));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ItemSoulShard) {
            Binding binding = Binding.fromNBT(event.getItemStack());
            if (binding == null || binding.getBoundEntity() == null) {
                return;
            }
            if (!binding.getBoundEntity().func_110624_b().equals("chickens")) {
                return;
            }
            try {
                Object chickenThing = CHICKEN_REGISTRY.get(binding.getBoundEntity());
                if (chickenThing == null) {
                    event.getToolTip().add(1, I18n.func_135052_a((String)"tooltip.soulshardsrespawn.bound", (Object[])new Object[]{binding.getBoundEntity().toString()}));
                } else {
                    event.getToolTip().add(1, I18n.func_135052_a((String)"tooltip.soulshardsrespawn.bound", (Object[])new Object[]{I18n.func_135052_a((String)("entity." + NAME_GETTER.bindTo(chickenThing).invoke() + ".name"), (Object[])new Object[0])}));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            SoulShards.LOGGER.info("[ChickensCompat] Beginning some spicy hacks to let shards know there's different kinds of Chickens chickens \ud83d\udc40");
            CHICKEN_CLASS = Class.forName("com.setycz.chickens.entity.EntityChickensChicken");
            Field typeParameterField = CHICKEN_CLASS.getDeclaredField("CHICKEN_TYPE");
            typeParameterField.setAccessible(true);
            TYPE_PARAMETER = (DataParameter)typeParameterField.get(null);
            Class<?> chickenRegistryClass = Class.forName("com.setycz.chickens.registry.ChickensRegistry");
            Field registryField = chickenRegistryClass.getDeclaredField("items");
            registryField.setAccessible(true);
            CHICKEN_REGISTRY = (Map)registryField.get(null);
            Class<?> chickenRegistryItemClass = Class.forName("com.setycz.chickens.registry.ChickensRegistryItem");
            Method entityNameMethod = chickenRegistryItemClass.getMethod("getEntityName", new Class[0]);
            NAME_GETTER = MethodHandles.lookup().unreflect(entityNameMethod);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get required internals of Chickens mod even though it's loaded.", e);
        }
    }
}

