/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ThreadSafeCache {
    private static final long REFRESH_DELAY = 30000L;
    private static final ThreadSafeCache INSTANCE = new ThreadSafeCache();
    private Set<UUID> onlineIds = Collections.emptySet();
    private long lastRefresh = 0L;

    public Set<UUID> getOnlineIds() {
        return this.onlineIds;
    }

    @SubscribeEvent
    public void tickStart(TickEvent event) {
        long now = System.currentTimeMillis();
        if (now - this.lastRefresh > 30000L) {
            HashSet<UUID> onlineIds = new HashSet<UUID>();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null || server.func_184103_al() == null) {
                return;
            }
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                if (player == null) continue;
                onlineIds.add(player.func_110124_au());
            }
            this.onlineIds = new CopyOnWriteArraySet<UUID>(onlineIds);
            this.lastRefresh = now;
        }
    }

    public static ThreadSafeCache getInstance() {
        return INSTANCE;
    }
}

