/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.ess3.api.IUser;
import net.ess3.api.events.NickChangeEvent;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandnick
extends EssentialsLoopCommand {
    public Commandnick() {
        super("nick");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        if (args.length > 1 && user.isAuthorized("essentials.nick.others")) {
            this.loopOfflinePlayers(server, user.getSource(), false, true, args[0], this.formatNickname(user, args[1]).split(" "));
            user.sendMessage(I18n.tl("nickChanged", new Object[0]));
        } else {
            this.updatePlayer(server, user.getSource(), user, this.formatNickname(user, args[0]).split(" "));
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        this.loopOfflinePlayers(server, sender, false, true, args[0], this.formatNickname(null, args[1]).split(" "));
        sender.sendMessage(I18n.tl("nickChanged", new Object[0]));
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User target, String[] args) throws NotEnoughArgumentsException {
        String nick = args[0];
        if ("off".equalsIgnoreCase(nick)) {
            this.setNickname(server, sender, target, null);
            target.sendMessage(I18n.tl("nickNoMore", new Object[0]));
        } else if (target.getName().equalsIgnoreCase(nick)) {
            this.setNickname(server, sender, target, nick);
            if (!target.getDisplayName().equalsIgnoreCase(target.getDisplayName())) {
                target.sendMessage(I18n.tl("nickNoMore", new Object[0]));
            }
            target.sendMessage(I18n.tl("nickSet", this.ess.getSettings().changeDisplayName() ? target.getDisplayName() : nick));
        } else {
            if (this.nickInUse(target, nick)) {
                throw new NotEnoughArgumentsException(I18n.tl("nickInUse", new Object[0]));
            }
            this.setNickname(server, sender, target, nick);
            target.sendMessage(I18n.tl("nickSet", this.ess.getSettings().changeDisplayName() ? target.getDisplayName() : nick));
        }
    }

    private String formatNickname(User user, String nick) throws Exception {
        String newNick;
        String string = newNick = user == null ? FormatUtil.replaceFormat(nick) : FormatUtil.formatString(user, "essentials.nick", nick);
        if (!newNick.matches("^[a-zA-Z_0-9\u00a7]+$") && user != null && !user.isAuthorized("essentials.nick.allowunsafe")) {
            throw new Exception(I18n.tl("nickNamesAlpha", new Object[0]));
        }
        if (this.getNickLength(newNick) > this.ess.getSettings().getMaxNickLength()) {
            throw new Exception(I18n.tl("nickTooLong", new Object[0]));
        }
        if (FormatUtil.stripFormat(newNick).length() < 1) {
            throw new Exception(I18n.tl("nickNamesAlpha", new Object[0]));
        }
        if (user != null && user.isAuthorized("essentials.nick.changecolors") && !user.isAuthorized("essentials.nick.changecolors.bypass") && !FormatUtil.stripFormat(newNick).equals(user.getName()) && !nick.equalsIgnoreCase("off")) {
            throw new Exception(I18n.tl("nickNamesOnlyColorChanges", new Object[0]));
        }
        if (user != null && !user.isAuthorized("essentials.nick.blacklist.bypass") && this.isNickBanned(newNick)) {
            throw new Exception(I18n.tl("nickNameBlacklist", nick));
        }
        return newNick;
    }

    private boolean isNickBanned(String newNick) {
        for (Predicate<String> predicate : this.ess.getSettings().getNickBlacklist()) {
            if (!predicate.test(newNick)) continue;
            return true;
        }
        return false;
    }

    private int getNickLength(String nick) {
        return this.ess.getSettings().ignoreColorsInMaxLength() ? ChatColor.stripColor((String)nick).length() : nick.length();
    }

    private boolean nickInUse(User target, String nick) {
        String lowerNick = FormatUtil.stripFormat(nick.toLowerCase(Locale.ENGLISH));
        for (User onlinePlayer : this.ess.getOnlineUsers()) {
            String matchNick;
            if (target.getBase().getName().equals(onlinePlayer.getName()) || ((matchNick = FormatUtil.stripFormat(onlinePlayer.getNickname())) == null || matchNick.isEmpty() || !lowerNick.equals(matchNick.toLowerCase(Locale.ENGLISH))) && !lowerNick.equals(onlinePlayer.getName().toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        User fetchedUser = this.ess.getUser(lowerNick);
        return fetchedUser != null && fetchedUser != target;
    }

    private void setNickname(Server server, CommandSource sender, User target, String nickname) {
        NickChangeEvent nickEvent = new NickChangeEvent(sender.getUser(this.ess), (IUser)target, nickname);
        server.getPluginManager().callEvent((Event)nickEvent);
        if (!nickEvent.isCancelled()) {
            target.setNickname(nickname);
            target.setDisplayNick();
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 && sender.isAuthorized("essentials.nick.others", this.ess)) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

