/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world.fortresses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraft.world.gen.structure.StructureStart;
import org.dimdev.dimdoors.shared.world.fortresses.ComponentNetherGateway;

public class DDStructureNetherBridgeStart
extends StructureStart {
    public static final int MAX_GATEWAY_GENERATION_CHANCE = 100;
    private boolean hasGateway;
    private int minX;
    private int minY;
    private int minZ;

    public DDStructureNetherBridgeStart() {
    }

    public DDStructureNetherBridgeStart(World world, Random random, int chunkX, int chunkZ) {
        super(chunkX, chunkZ);
        this.hasGateway = false;
        ArrayList<StructureNetherBridgePieces.Throne> spawnerRooms = new ArrayList<StructureNetherBridgePieces.Throne>();
        for (StructureComponent component : this.field_75075_a) {
            if (!(component instanceof StructureNetherBridgePieces.Throne)) continue;
            spawnerRooms.add((StructureNetherBridgePieces.Throne)component);
        }
        if (!spawnerRooms.isEmpty()) {
            StructureComponent component;
            this.hasGateway = true;
            component = (StructureComponent)spawnerRooms.get(random.nextInt(spawnerRooms.size()));
            StructureBoundingBox bounds = component.func_74874_b();
            this.minX = bounds.field_78897_a;
            this.minY = bounds.field_78895_b;
            this.minZ = bounds.field_78896_c;
        }
    }

    public NBTTagCompound func_143021_a(int chunkX, int chunkZ) {
        NBTTagCompound fortressTag = super.func_143021_a(chunkX, chunkZ);
        NBTTagCompound dimensionalTag = new NBTTagCompound();
        dimensionalTag.func_74757_a("HasGateway", this.hasGateway);
        if (this.hasGateway) {
            dimensionalTag.func_74768_a("GatewayMinX", this.minX);
            dimensionalTag.func_74768_a("GatewayMinY", this.minY);
            dimensionalTag.func_74768_a("GatewayMinZ", this.minZ);
        }
        fortressTag.func_74782_a("DimensionalDoors", (NBTBase)dimensionalTag);
        return fortressTag;
    }

    public void func_143020_a(World world, NBTTagCompound fortressTag) {
        super.func_143020_a(world, fortressTag);
        NBTTagCompound dimensionalTag = fortressTag.func_74775_l("DimensionalDoors");
        if (dimensionalTag != null) {
            this.hasGateway = dimensionalTag.func_74767_n("HasGateway");
            if (this.hasGateway) {
                this.minX = dimensionalTag.func_74762_e("GatewayMinX");
                this.minY = dimensionalTag.func_74762_e("GatewayMinY");
                this.minZ = dimensionalTag.func_74762_e("GatewayMinZ");
            }
        }
    }

    public void func_75068_a(World world, Random random, StructureBoundingBox generationBounds) {
        if (this.hasGateway) {
            Iterator iterator = this.field_75075_a.iterator();
            while (iterator.hasNext()) {
                StructureComponent component = (StructureComponent)iterator.next();
                StructureBoundingBox bounds = component.func_74874_b();
                if (!bounds.func_78884_a(generationBounds)) continue;
                if (bounds.field_78897_a == this.minX && bounds.field_78895_b == this.minY && bounds.field_78896_c == this.minZ) {
                    component = ComponentNetherGateway.createFromComponent(component, random);
                }
                if (component.func_74875_a(world, random, generationBounds)) continue;
                iterator.remove();
            }
        } else {
            super.func_75068_a(world, random, generationBounds);
        }
    }
}

