/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.tileentities;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.RGBA;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.BlockDimensionalDoor;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;

public class TileEntityEntranceRift
extends TileEntityRift {
    protected boolean leaveRiftOnBreak = false;
    protected boolean closeAfterPassThrough = false;
    public EnumFacing orientation;
    @SideOnly(value=Side.CLIENT)
    public double extendUp;
    @SideOnly(value=Side.CLIENT)
    public double extendDown;
    @SideOnly(value=Side.CLIENT)
    public double extendLeft;
    @SideOnly(value=Side.CLIENT)
    public double extendRight;
    @SideOnly(value=Side.CLIENT)
    public double pushIn;
    @SideOnly(value=Side.CLIENT)
    public byte lockStatus;

    public TileEntityEntranceRift() {
        if (DimDoors.proxy.isClient()) {
            this.extendRight = 0.5;
            this.extendLeft = 0.5;
            this.extendDown = 0.5;
            this.extendUp = 0.5;
            this.pushIn = 0.01;
            this.lockStatus = 0;
        }
    }

    @Override
    public void copyFrom(TileEntityRift oldRift) {
        super.copyFrom(oldRift);
        if (oldRift instanceof TileEntityEntranceRift) {
            TileEntityEntranceRift oldEntranceRift = (TileEntityEntranceRift)oldRift;
            this.closeAfterPassThrough = oldEntranceRift.closeAfterPassThrough;
        }
        this.leaveRiftOnBreak = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        return NBTUtils.writeToNBT(this, nbt);
    }

    public void setLeaveRiftOnBreak(boolean leaveRiftOnBreak) {
        this.leaveRiftOnBreak = leaveRiftOnBreak;
        this.func_70296_d();
    }

    public void setLockStatus(byte lockStatus) {
        this.lockStatus = lockStatus;
        this.func_70296_d();
    }

    public void setCloseAfterPassThrough(boolean closeAfterPassThrough) {
        this.closeAfterPassThrough = closeAfterPassThrough;
        this.func_70296_d();
    }

    @Override
    public boolean teleport(Entity entity) {
        boolean status = super.teleport(entity);
        if (this.riftStateChanged && !this.alwaysDelete) {
            this.leaveRiftOnBreak = true;
            this.func_70296_d();
        }
        return status;
    }

    @Override
    public boolean receiveEntity(Entity entity, float relativeYaw, float relativePitch) {
        Vec3d targetPos = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.0, 0.5).func_178787_e(new Vec3d(this.orientation.func_176730_m()).func_186678_a(ModConfig.general.teleportOffset + 0.5));
        if (this.relativeRotation) {
            float yaw = this.getDestinationYaw(entity.field_70177_z) + entity.field_70177_z - relativeYaw;
            float pitch = entity instanceof EntityLiving ? entity.field_70125_A : this.getDestinationPitch(entity.field_70125_A) + entity.field_70125_A - relativePitch;
            TeleportUtils.teleport(entity, WorldUtils.getDim(this.field_145850_b), targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, yaw, pitch);
        } else {
            TeleportUtils.teleport(entity, WorldUtils.getDim(this.field_145850_b), targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, this.orientation.func_185119_l(), 0.0f);
        }
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        newSate = world.func_180495_p(pos);
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public RGBA[] getColors(int count) {
        Random rand = new Random(31100L);
        RGBA[] colors = new RGBA[count];
        for (int i = 0; i < count; ++i) {
            colors[i] = this.getEntranceRenderColor(rand);
        }
        return colors;
    }

    @SideOnly(value=Side.CLIENT)
    protected RGBA getEntranceRenderColor(Random rand) {
        float blue;
        float green;
        float red;
        switch (this.field_145850_b.field_73011_w.getDimension()) {
            case -1: {
                red = rand.nextFloat() * 0.5f + 0.4f;
                green = rand.nextFloat() * 0.05f;
                blue = rand.nextFloat() * 0.05f;
                break;
            }
            default: {
                red = rand.nextFloat() * 0.5f + 0.1f;
                green = rand.nextFloat() * 0.4f + 0.4f;
                blue = rand.nextFloat() * 0.6f + 0.5f;
            }
        }
        return new RGBA(red, green, blue, 1.0f);
    }

    @Override
    public boolean isFloating() {
        return false;
    }

    @Override
    public float getSourceYaw(float entityYaw) {
        return this.orientation.func_176734_d().func_185119_l();
    }

    @Override
    public float getSourcePitch(float entityPitch) {
        return this.orientation.func_176734_d().func_96559_d() * 90;
    }

    @Override
    public float getDestinationYaw(float entityYaw) {
        return this.orientation.func_185119_l();
    }

    @Override
    public float getDestinationPitch(float entityPitch) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Block block = this.func_145838_q();
        if (block instanceof BlockDimensionalDoor) {
            return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
        }
        return super.getRenderBoundingBox();
    }

    public boolean isLeaveRiftOnBreak() {
        return this.leaveRiftOnBreak;
    }

    public boolean isCloseAfterPassThrough() {
        return this.closeAfterPassThrough;
    }
}

