/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.registry;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.nbt.INBTStorable;
import org.dimdev.ddutils.nbt.NBTUtils;

public class LinkProperties
implements INBTStorable {
    public float floatingWeight;
    public float entranceWeight;
    public Set<Integer> groups;
    public int linksRemaining;
    public boolean oneWay;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return NBTUtils.writeToNBT(this, nbt);
    }

    private static float $default$floatingWeight() {
        return 1.0f;
    }

    private static float $default$entranceWeight() {
        return 1.0f;
    }

    private static Set<Integer> $default$groups() {
        return new HashSet<Integer>();
    }

    private static int $default$linksRemaining() {
        return 1;
    }

    private static boolean $default$oneWay() {
        return false;
    }

    public static LinkPropertiesBuilder builder() {
        return new LinkPropertiesBuilder();
    }

    public LinkPropertiesBuilder toBuilder() {
        return new LinkPropertiesBuilder().floatingWeight(this.floatingWeight).entranceWeight(this.entranceWeight).groups(this.groups).linksRemaining(this.linksRemaining).oneWay(this.oneWay);
    }

    public LinkProperties(float floatingWeight, float entranceWeight, Set<Integer> groups, int linksRemaining, boolean oneWay) {
        this.floatingWeight = floatingWeight;
        this.entranceWeight = entranceWeight;
        this.groups = groups;
        this.linksRemaining = linksRemaining;
        this.oneWay = oneWay;
    }

    public LinkProperties() {
        this.floatingWeight = LinkProperties.$default$floatingWeight();
        this.entranceWeight = LinkProperties.$default$entranceWeight();
        this.groups = LinkProperties.$default$groups();
        this.linksRemaining = LinkProperties.$default$linksRemaining();
        this.oneWay = LinkProperties.$default$oneWay();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkProperties)) {
            return false;
        }
        LinkProperties other = (LinkProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.floatingWeight, other.floatingWeight) != 0) {
            return false;
        }
        if (Float.compare(this.entranceWeight, other.entranceWeight) != 0) {
            return false;
        }
        Set<Integer> this$groups = this.groups;
        Set<Integer> other$groups = other.groups;
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        if (this.linksRemaining != other.linksRemaining) {
            return false;
        }
        return this.oneWay == other.oneWay;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.floatingWeight);
        result = result * 59 + Float.floatToIntBits(this.entranceWeight);
        Set<Integer> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        result = result * 59 + this.linksRemaining;
        result = result * 59 + (this.oneWay ? 79 : 97);
        return result;
    }

    public String toString() {
        return "LinkProperties(floatingWeight=" + this.floatingWeight + ", entranceWeight=" + this.entranceWeight + ", groups=" + this.groups + ", linksRemaining=" + this.linksRemaining + ", oneWay=" + this.oneWay + ")";
    }

    public static class LinkPropertiesBuilder {
        private boolean floatingWeight$set;
        private float floatingWeight;
        private boolean entranceWeight$set;
        private float entranceWeight;
        private boolean groups$set;
        private Set<Integer> groups;
        private boolean linksRemaining$set;
        private int linksRemaining;
        private boolean oneWay$set;
        private boolean oneWay;

        LinkPropertiesBuilder() {
        }

        public LinkPropertiesBuilder floatingWeight(float floatingWeight) {
            this.floatingWeight = floatingWeight;
            this.floatingWeight$set = true;
            return this;
        }

        public LinkPropertiesBuilder entranceWeight(float entranceWeight) {
            this.entranceWeight = entranceWeight;
            this.entranceWeight$set = true;
            return this;
        }

        public LinkPropertiesBuilder groups(Set<Integer> groups) {
            this.groups = groups;
            this.groups$set = true;
            return this;
        }

        public LinkPropertiesBuilder linksRemaining(int linksRemaining) {
            this.linksRemaining = linksRemaining;
            this.linksRemaining$set = true;
            return this;
        }

        public LinkPropertiesBuilder oneWay(boolean oneWay) {
            this.oneWay = oneWay;
            this.oneWay$set = true;
            return this;
        }

        public LinkProperties build() {
            float floatingWeight = this.floatingWeight;
            if (!this.floatingWeight$set) {
                floatingWeight = LinkProperties.$default$floatingWeight();
            }
            float entranceWeight = this.entranceWeight;
            if (!this.entranceWeight$set) {
                entranceWeight = LinkProperties.$default$entranceWeight();
            }
            Set groups = this.groups;
            if (!this.groups$set) {
                groups = LinkProperties.$default$groups();
            }
            int linksRemaining = this.linksRemaining;
            if (!this.linksRemaining$set) {
                linksRemaining = LinkProperties.$default$linksRemaining();
            }
            boolean oneWay = this.oneWay;
            if (!this.oneWay$set) {
                oneWay = LinkProperties.$default$oneWay();
            }
            return new LinkProperties(floatingWeight, entranceWeight, groups, linksRemaining, oneWay);
        }

        public String toString() {
            return "LinkProperties.LinkPropertiesBuilder(floatingWeight=" + this.floatingWeight + ", entranceWeight=" + this.entranceWeight + ", groups=" + this.groups + ", linksRemaining=" + this.linksRemaining + ", oneWay=" + this.oneWay + ")";
        }
    }
}

