/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.entities;

import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLoots;

public class DTEntityTowerGuardian
extends AbstractSkeleton {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(DTEntityTowerGuardian.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private boolean isBreakDoorsTaskSet;
    private float guardianWidth = 0.6f;
    private float guardianHeight = 1.99f;
    private int angerLevel;
    private int randomSoundDelay;
    private UUID angerTargetUUID;
    private BlockPos homePosition = BlockPos.field_177992_a;
    private float maximumHomeDistance = -1.0f;

    public DTEntityTowerGuardian(World worldIn) {
        super(worldIn);
        this.func_70105_a(this.guardianWidth, this.guardianHeight);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{DTEntityTowerGuardian.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySpider.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            if (!iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
            if (this.angerLevel <= 0) {
                this.removeChallengeAI();
            }
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_184185_a(SoundEvents.field_187854_fc, this.func_70599_aP() * 2.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.func_70643_av() == null) {
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    protected void applyChallengeAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void removeChallengeAI() {
        this.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            if (!(this.isAngry() || stack != null && stack.func_77973_b() instanceof ItemSword)) {
                if (DungeonTactics.samhain && DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Tower Guardian: Greetings and happy Samhain, Adventurer."));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + player.func_70005_c_() + ": Trick or Treat?"));
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Tower Guardian: Explosions are treats, right?"));
                    player.func_70099_a(new ItemStack(DTItems.BAG_SAMHAIN), 1.0f);
                    return true;
                }
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Ready your weapon, Adventurer."));
                return true;
            }
            if (!this.isAngry() && stack != null && stack.func_77973_b() instanceof ItemSword) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "I accept your challenge, Mortal."));
                this.func_70604_c((EntityLivingBase)player);
                this.angerLevel = 2400;
                this.applyChallengeAI();
                return true;
            }
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public boolean isBreakDoorsTaskSet() {
        return this.isBreakDoorsTaskSet;
    }

    public void setBreakDoorsAItask(boolean enabled) {
        if (this.isBreakDoorsTaskSet != enabled) {
            this.isBreakDoorsTaskSet = enabled;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
            if (enabled) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return super.func_70693_a(player);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            float f;
            if (this.func_110175_bO() && this.func_110175_bO() && !this.func_110173_bK()) {
                this.field_70143_R = 0.0f;
                this.func_70634_a(this.getArenaPosition().func_177958_n(), this.getArenaPosition().func_177956_o(), this.getArenaPosition().func_177952_p());
            }
            if (this.field_70170_p.func_72935_r() && this.shouldBurnInDay() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
                boolean flag = true;
                ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_70669_a(itemstack);
                            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        boolean handled = false;
        if (this.func_110175_bO()) {
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 4.0f, (1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f) * 0.7f);
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0);
            List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, axisalignedbb);
            if (!list.isEmpty() && this.field_70718_bc > 0) {
                for (EntityPlayer player : list) {
                    player.func_70634_a((double)((float)this.func_180486_cf().func_177958_n() + 0.5f), (double)((float)this.func_180486_cf().func_177956_o() + 0.5f), (double)((float)this.func_180486_cf().func_177952_p() - 1.5f));
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, (double)this.func_180486_cf().func_177958_n(), (double)this.func_180486_cf().func_177956_o(), (double)this.func_180486_cf().func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    handled = true;
                }
                if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82736_K().func_82766_b("doMobLoot") && this.func_130014_f_().func_175623_d(this.func_180486_cf().func_177984_a()) && this.field_70718_bc > 0) {
                    int j;
                    this.func_130014_f_().func_180501_a(this.func_180486_cf().func_177984_a(), Blocks.field_150486_ae.func_176458_f(this.func_130014_f_(), this.func_180486_cf().func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
                    TileEntity chest = this.func_130014_f_().func_175625_s(this.func_180486_cf().func_177984_a());
                    if (chest instanceof TileEntityChest) {
                        ((TileEntityChest)chest).func_189404_a(DTLoots.TOWERGUARDIAN_LOOT, this.field_70146_Z.nextLong());
                    }
                    int i = this.func_70693_a(this.field_70717_bb);
                    for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), (double)((float)this.func_180486_cf().func_177958_n() + 0.5f), (double)((float)this.func_180486_cf().func_177956_o() + 0.5f), (double)((float)this.func_180486_cf().func_177952_p() - 1.5f), j));
                    }
                }
            }
            this.clearRoom(this.func_130014_f_(), this.func_180486_cf());
        } else if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82736_K().func_82766_b("doMobLoot") && this.field_70718_bc > 0) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v - 0.5, j));
            }
        }
        super.func_70645_a(cause);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            if (this.angerLevel <= 0 && !this.func_130014_f_().field_72995_K) {
                ((EntityPlayer)entity).func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "On guard, honourless Naive."));
            }
            this.func_70604_c((EntityLivingBase)entity);
            this.angerLevel = 2400;
            this.applyChallengeAI();
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float d = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entityIn.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL || entityIn.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
            entityIn.func_70097_a(DamageSource.field_76376_m, d / 3.0f);
            entityIn.field_70172_ad = 0;
        }
        if (flag = super.func_70652_k(entityIn)) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    private void becomeAngryAt(Entity attacker) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        this.randomSoundDelay = this.field_70146_Z.nextInt(40);
        if (attacker instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)attacker);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.func_190727_o(), 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return DTLoots.TOWERGUARDIAN_LOOT;
    }

    protected boolean func_146066_aG() {
        return !this.func_110175_bO();
    }

    public void func_180481_a(DifficultyInstance difficulty) {
        int e = this.field_70146_Z.nextInt(4);
        int w = this.field_70146_Z.nextInt(3);
        int q = this.field_70146_Z.nextInt(2);
        if (e == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151171_ah));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151149_ai));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151151_aj));
            if (w == 0) {
                if (q == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.GOLDEN_CUTLASS));
                }
            } else if (w == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.GOLDEN_HAMMER));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.GOLDEN_KNIFE));
            }
        } else if (e == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151163_ad));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151173_ae));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151175_af));
            if (w == 0) {
                if (q == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.DIAMOND_CUTLASS));
                }
            } else if (w == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.DIAMOND_HAMMER));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.DIAMOND_KNIFE));
            }
        } else {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151167_ab));
            if (w == 0) {
                if (q == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_CUTLASS));
                }
            } else if (w == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_HAMMER));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_KNIFE));
            }
        }
    }

    public static void registerFixesSkeleton(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, DTEntityTowerGuardian.class);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("CanBreakDoors", this.isBreakDoorsTaskSet());
        compound.func_74777_a("Anger", (short)this.angerLevel);
        compound.func_74768_a("homeX", this.homePosition.func_177958_n());
        compound.func_74768_a("homeY", this.homePosition.func_177956_o());
        compound.func_74768_a("homeZ", this.homePosition.func_177952_p());
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBreakDoorsAItask(compound.func_74767_n("CanBreakDoors"));
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        int homeX = compound.func_74762_e("homeX");
        int homeY = compound.func_74762_e("homeY");
        int homeZ = compound.func_74762_e("homeZ");
        this.func_175449_a(new BlockPos(homeX, homeY, homeZ), 30);
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
    }

    public float func_70047_e() {
        return 1.74f;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_184218_aH() ? false : super.func_175448_a(stack);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setBreakDoorsAItask(this.field_70146_Z.nextFloat() < f * 0.1f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.setBreakDoorsAItask(true);
        }
        return livingdata;
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.guardianWidth > 0.0f && this.guardianHeight > 0.0f;
        this.guardianWidth = width;
        this.guardianHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.guardianWidth * size, this.guardianHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    protected ItemStack getSkullDrop() {
        return new ItemStack(Items.field_151144_bL, 1, 0);
    }

    public boolean func_110173_bK() {
        return this.func_180485_d(new BlockPos((Entity)this));
    }

    public boolean func_180485_d(BlockPos pos) {
        if (this.maximumHomeDistance == -1.0f) {
            return true;
        }
        return this.getArenaPosition().func_177951_i((Vec3i)pos) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void func_175449_a(BlockPos pos, int distance) {
        this.homePosition = pos;
        this.maximumHomeDistance = distance;
    }

    public BlockPos func_180486_cf() {
        return this.homePosition;
    }

    public BlockPos getArenaPosition() {
        float y = this.field_70170_p.func_72800_K() - 9;
        BlockPos pos = new BlockPos((double)this.homePosition.func_177958_n(), (double)y, (double)this.homePosition.func_177952_p());
        return pos;
    }

    public float func_110174_bM() {
        return this.maximumHomeDistance;
    }

    public void func_110177_bN() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean func_110175_bO() {
        return this.maximumHomeDistance != -1.0f;
    }

    public boolean clearRoom(World world, BlockPos pos) {
        if (this.func_110175_bO()) {
            float y = world.func_72800_K() - 10;
            BlockPos buildPos = new BlockPos((double)pos.func_177958_n(), (double)y, (double)pos.func_177952_p()).func_177982_a(-9, 0, -9);
            for (int horX = 0; horX < 19; ++horX) {
                for (int horZ = 0; horZ < 19; ++horZ) {
                    for (int vert = 0; vert < 9; ++vert) {
                        world.func_175698_g(buildPos.func_177981_b(vert).func_177970_e(horZ).func_177965_g(horX));
                    }
                }
            }
            return true;
        }
        return false;
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AITargetAggressor(DTEntityTowerGuardian entityTowerGuardian) {
            super((EntityCreature)entityTowerGuardian, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return ((DTEntityTowerGuardian)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(DTEntityTowerGuardian creatureIn) {
            super((EntityCreature)creatureIn, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            super.func_179446_a(creatureIn, entityLivingBaseIn);
            if (creatureIn instanceof DTEntityTowerGuardian) {
                ((DTEntityTowerGuardian)creatureIn).becomeAngryAt((Entity)entityLivingBaseIn);
            }
        }
    }
}

