/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockOre;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import pegbeard.dungeontactics.blocks.DTBlockGeneric;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLoots;

public class DTGrinderBlock
extends DTBlockGeneric {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public DTGrinderBlock(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultDirection(world, pos, state);
    }

    private void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean flag = world.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean flag1 = world.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && flag && !flag1) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && flag1 && !flag) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean flag2 = world.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean flag3 = world.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && flag2 && !flag3) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && flag3 && !flag2) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public int func_149738_a(World world) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos frontPos = new BlockPos(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
        float f1 = 0.5f + (rand.nextFloat() - rand.nextFloat());
        float f3 = 5.0f;
        double x = (float)frontPos.func_177958_n() + f1;
        double y = (float)frontPos.func_177956_o() + f1;
        double z = (float)frontPos.func_177952_p() + f1;
        if (!world.isSideSolid(frontPos, facing.func_176734_d(), false) && world.func_175687_A(pos) > 0) {
            if (facing == EnumFacing.NORTH) {
                z = pos.func_177952_p();
            }
            if (facing == EnumFacing.SOUTH) {
                z = frontPos.func_177952_p();
            }
            if (facing == EnumFacing.WEST) {
                x = pos.func_177958_n();
            }
            if (facing == EnumFacing.EAST) {
                x = frontPos.func_177958_n();
            }
            if (facing == EnumFacing.UP) {
                y = pos.func_177956_o();
            }
            if (facing == EnumFacing.DOWN) {
                y = frontPos.func_177956_o();
            }
            world.func_175688_a(EnumParticleTypes.CRIT, x, y, z, (double)((float)facing.func_82601_c() / f3), (double)((float)facing.func_96559_d() / f3), (double)((float)facing.func_82599_e() / f3), new int[0]);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        IBlockState target;
        boolean b = world.func_175640_z(pos);
        world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(b)), 2);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos frontPos = new BlockPos(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
        BlockPos backPos = new BlockPos(pos.func_177958_n() + facing.func_176734_d().func_82601_c(), pos.func_177956_o() + facing.func_176734_d().func_96559_d(), pos.func_177952_p() + facing.func_176734_d().func_82599_e());
        if ((b || world.func_175687_A(pos) > 0) && this.validTarget((target = world.func_180495_p(frontPos)).func_177230_c())) {
            this.harvestBlock(world, frontPos, backPos, facing, target);
        }
    }

    public boolean harvestBlock(World world, BlockPos frontPos, BlockPos backPos, EnumFacing facing, IBlockState target) {
        Block block = target.func_177230_c();
        IInventory destination = this.getInventoryAtPosition(world, backPos.func_177958_n(), backPos.func_177956_o(), backPos.func_177952_p());
        if (block.isAir(target, (IBlockAccess)world, frontPos)) {
            return false;
        }
        NonNullList drops = NonNullList.func_191196_a();
        this.swapDrops((NonNullList<ItemStack>)drops, (IBlockAccess)world, block);
        if (destination != null) {
            if (this.isInventoryFull(destination, facing, ItemStack.field_190927_a)) {
                return false;
            }
            if (world.func_175625_s(backPos) instanceof TileEntityFurnace) {
                facing = EnumFacing.UP;
            }
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack1 = (ItemStack)drops.get(i);
                if (!this.isInventoryFull(destination, facing, stack1)) {
                    this.putStackInInventoryAllSlots(world, backPos, destination, stack1, facing);
                    continue;
                }
                this.dropItem(world, backPos, null, stack1);
            }
        } else {
            this.dropItem(world, backPos, (NonNullList<ItemStack>)drops, ItemStack.field_190927_a);
        }
        world.func_175718_b(2001, frontPos, Block.func_176210_f((IBlockState)target));
        return world.func_180501_a(frontPos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public boolean validTarget(Block block) {
        ItemStack itemDrop = new ItemStack(Item.func_150898_a((Block)block));
        return block instanceof BlockOre || block == Blocks.field_150348_b || block == Blocks.field_150347_e || block == Blocks.field_150351_n || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockCoal"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockIron"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockSilver"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockGold"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockSteel"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockDiamond"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockMithril"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockTin"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockCopper"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockAluminium"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockAluminum"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockNickle"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockLead"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockPlatinum"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockTungsten"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockTitanium"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockOsmium"), (ItemStack[])new ItemStack[]{itemDrop});
    }

    public void swapDrops(NonNullList<ItemStack> drops, IBlockAccess world, Block block) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int chance = rand.nextInt(100);
        int count = 1;
        if (this.validTarget(block)) {
            count = 9;
        }
        if (block instanceof BlockOre) {
            count = 1 + rand.nextInt(3);
        }
        ItemStack itemDrop = new ItemStack(Item.func_150898_a((Block)block));
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreCoal"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockCoal"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_COAL, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreIron"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockIron"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_IRON, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreSilver"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockSilver"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_SILVER, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreGold"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockGold"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_GOLD, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockSteel"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_STEEL, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreDiamond"), (ItemStack[])new ItemStack[]{itemDrop})) {
            count = 9 + rand.nextInt(5);
            drops.add((Object)new ItemStack(DTItems.CUT_DIAMOND, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockDiamond"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.CUT_DIAMOND, 64));
            drops.add((Object)new ItemStack(DTItems.CUT_DIAMOND, 17));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreMithril"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockMithril"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_MITHRIL, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreTin"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockTin"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_TIN, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreCopper"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockCopper"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_COPPER, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreAluminium"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockAluminium"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreAluminum"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockAluminum"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreBauxite"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockBauxite"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_ALUMINIUM, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreNickel"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockNickel"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_NICKEL, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreLead"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockLead"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_LEAD, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"orePlatinum"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockPlatinum"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreSheldonite"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockSheldonite"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_PLATINUM, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreTungsten"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockTungsten"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_TUNGSTEN, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreTitanium"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockTitanium"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_TITANIUM, count));
        }
        if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"oreOsmium"), (ItemStack[])new ItemStack[]{itemDrop}) || OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"blockOsmium"), (ItemStack[])new ItemStack[]{itemDrop})) {
            drops.add((Object)new ItemStack(DTItems.DUST_OSMIUM, count));
        }
        if (block == Blocks.field_150348_b) {
            drops.add((Object)new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1));
            if (chance < 70) {
                drops.add((Object)new ItemStack(Items.field_151145_ak, 1));
            }
        }
        if (block == Blocks.field_150347_e) {
            drops.add((Object)new ItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), 1));
            if (chance < 70) {
                drops.add((Object)new ItemStack(Items.field_151145_ak, 1));
            }
        }
        if (block == Blocks.field_150351_n) {
            if (DTConfigHandler.configuration.get("1-Feature", "Use Crushing Loot Table", false).getBoolean(false)) {
                drops.add((Object)new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 1));
                LootContext.Builder build = new LootContext.Builder((WorldServer)world);
                for (ItemStack stack : ((World)world).func_184146_ak().func_186521_a(DTLoots.CRUSHING_LOOT).func_186462_a(rand, build.func_186471_a())) {
                    if (stack.func_190926_b()) continue;
                    drops.add((Object)stack.func_77946_l());
                }
            } else {
                count = 1 + rand.nextInt(3);
                drops.add((Object)new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 1));
                if (chance < 50) {
                    drops.add((Object)new ItemStack(Items.field_151145_ak, count));
                }
                if (chance >= 45 && chance < 80) {
                    drops.add((Object)new ItemStack(Items.field_151137_ax, count));
                }
                if (chance >= 70) {
                    chance = rand.nextInt(3);
                    if (chance == 0 && !OreDictionary.getOres((String)"ingotTin").isEmpty()) {
                        drops.add((Object)new ItemStack(DTItems.CLUSTER_TIN, count));
                    }
                    if (chance == 1) {
                        if (!OreDictionary.getOres((String)"ingotCopper").isEmpty()) {
                            drops.add((Object)new ItemStack(DTItems.CLUSTER_COPPER, count));
                        }
                    } else {
                        drops.add((Object)new ItemStack(DTItems.CLUSTER_IRON, count));
                    }
                }
            }
        }
    }

    public void dropItem(World world, BlockPos pos, NonNullList<ItemStack> drops, ItemStack stack) {
        if (!world.field_72995_K) {
            if (drops != null) {
                for (ItemStack drop : drops) {
                    DTGrinderBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
                }
            } else if (!stack.func_190926_b()) {
                DTGrinderBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public ItemStack putStackInInventoryAllSlots(World world, BlockPos pos, IInventory destination, ItemStack stack, @Nullable EnumFacing direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory isidedinventory = (ISidedInventory)destination;
            int[] aint = isidedinventory.func_180463_a(direction);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = this.insertStack(world, pos, destination, stack, aint[k], direction);
            }
        } else {
            int i = destination.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = this.insertStack(world, pos, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private ItemStack insertStack(World world, BlockPos pos, IInventory destination, ItemStack stack, int index, EnumFacing direction) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (this.canInsertItemInSlot(destination, stack, index, direction)) {
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
            } else if (this.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
            }
            if (stack.func_190916_E() > 0 && index + 1 == destination.func_70302_i_()) {
                this.dropItem(world, pos, null, stack);
                stack = ItemStack.field_190927_a;
            }
            destination.func_70296_d();
        }
        if (!stack.func_190926_b() && stack.func_190916_E() > 0 && index == destination.func_70302_i_()) {
            this.dropItem(world, pos, null, stack);
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public IInventory getInventoryAtPosition(World world, double x, double y, double z) {
        TileEntity tileentity;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.func_76128_c((double)x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z));
        IBlockState state = world.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state) && (tileentity = world.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof TileEntityChest && block instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_189418_a(world, blockpos, true);
        }
        return iinventory;
    }

    private boolean isInventoryFull(IInventory inventory, EnumFacing side, ItemStack stack) {
        if (inventory instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack slotStack = isidedinventory.func_70301_a(k);
                if (slotStack.func_190926_b()) {
                    return false;
                }
                if (slotStack.func_190916_E() == slotStack.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventory.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack slotStack = inventory.func_70301_a(j);
                if (slotStack.func_190926_b()) {
                    return false;
                }
                if (slotStack.func_190916_E() == slotStack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canInsertItemInSlot(IInventory inventory, ItemStack stack, int index, EnumFacing side) {
        if (!inventory.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180462_a(index, stack, side);
    }

    private boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

