/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dynmap.Color;
import org.dynmap.Log;
import org.dynmap.snakeyaml.DumperOptions;
import org.dynmap.snakeyaml.Yaml;
import org.dynmap.snakeyaml.constructor.SafeConstructor;
import org.dynmap.snakeyaml.error.YAMLException;
import org.dynmap.snakeyaml.introspector.Property;
import org.dynmap.snakeyaml.nodes.CollectionNode;
import org.dynmap.snakeyaml.nodes.MappingNode;
import org.dynmap.snakeyaml.nodes.Node;
import org.dynmap.snakeyaml.nodes.NodeTuple;
import org.dynmap.snakeyaml.nodes.SequenceNode;
import org.dynmap.snakeyaml.nodes.Tag;
import org.dynmap.snakeyaml.reader.UnicodeReader;
import org.dynmap.snakeyaml.representer.Represent;
import org.dynmap.snakeyaml.representer.Representer;

public class ConfigurationNode
implements Map<String, Object> {
    public Map<String, Object> entries;
    private File f;
    private Yaml yaml;

    public ConfigurationNode() {
        this.entries = new LinkedHashMap<String, Object>();
    }

    private void initparse() {
        if (this.yaml == null) {
            DumperOptions options = new DumperOptions();
            options.setIndent(4);
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            options.setVersion(DumperOptions.Version.V1_1);
            this.yaml = new Yaml(new SafeConstructor(), new EmptyNullRepresenter(), options);
        }
    }

    public ConfigurationNode(File f) {
        this.f = f;
        this.entries = new LinkedHashMap<String, Object>();
    }

    public ConfigurationNode(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.entries = map;
    }

    public ConfigurationNode(InputStream in) {
        this.load(in);
    }

    public boolean load(InputStream in) {
        this.initparse();
        Object o = this.yaml.load(new UnicodeReader(in));
        if (o != null && o instanceof Map) {
            this.entries = (Map)o;
        }
        return this.entries != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        this.initparse();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.f);
            Object o = this.yaml.load(new UnicodeReader(fis));
            if (o != null && o instanceof Map) {
                this.entries = (Map)o;
            }
            fis.close();
        }
        catch (YAMLException e) {
            Log.severe("Error parsing " + this.f.getPath() + ". Use http://yamllint.com to debug the YAML syntax.");
            throw e;
        }
        catch (IOException iox) {
            Log.severe("Error reading " + this.f.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.entries != null;
    }

    public boolean save() {
        return this.save(this.f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(File file) {
        this.initparse();
        FileOutputStream stream = null;
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            stream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            this.yaml.dump(this.entries, writer);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public Object getObject(String path) {
        Map submap;
        if (path.isEmpty()) {
            return this.entries;
        }
        int separator = path.indexOf(47);
        if (separator < 0) {
            return this.get(path);
        }
        String localKey = path.substring(0, separator);
        Object subvalue = this.get(localKey);
        if (subvalue == null) {
            return null;
        }
        if (!(subvalue instanceof Map)) {
            return null;
        }
        try {
            submap = (Map)subvalue;
        }
        catch (ClassCastException e) {
            return null;
        }
        String subpath = path.substring(separator + 1);
        return new ConfigurationNode(submap).getObject(subpath);
    }

    public Object getObject(String path, Object def) {
        Object o = this.getObject(path);
        if (o == null) {
            return def;
        }
        return o;
    }

    public <T> T getGeneric(String path, T def) {
        Object o = this.getObject(path, def);
        try {
            return (T)o;
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public int getInteger(String path, int def) {
        return Integer.parseInt(this.getObject(path, def).toString());
    }

    public double getLong(String path, long def) {
        return Long.parseLong(this.getObject(path, def).toString());
    }

    public float getFloat(String path, float def) {
        return Float.parseFloat(this.getObject(path, Float.valueOf(def)).toString());
    }

    public double getDouble(String path, double def) {
        return Double.parseDouble(this.getObject(path, def).toString());
    }

    public boolean getBoolean(String path, boolean def) {
        return Boolean.parseBoolean(this.getObject(path, def).toString());
    }

    public String getString(String path) {
        return this.getString(path, null);
    }

    public List<String> getStrings(String path, List<String> def) {
        Object o = this.getObject(path);
        if (!(o instanceof List)) {
            return def;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Object i : (List)o) {
            strings.add(i.toString());
        }
        return strings;
    }

    public String getString(String path, String def) {
        Object o = this.getObject(path, def);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Color getColor(String path, String def) {
        String lclr = this.getString(path, def);
        if (lclr != null && lclr.startsWith("#")) {
            try {
                int c = Integer.parseInt(lclr.substring(1), 16);
                return new Color(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF);
            }
            catch (NumberFormatException nfx) {
                Log.severe("Invalid color value: " + lclr + " for '" + path + "'");
            }
        }
        return null;
    }

    public <T> List<T> getList(String path) {
        try {
            List list = (List)this.getObject(path, null);
            return list;
        }
        catch (ClassCastException e) {
            try {
                Object o = this.getObject(path, null);
                if (o == null) {
                    return new ArrayList();
                }
                ArrayList<Object> al = new ArrayList<Object>();
                al.add(o);
                return al;
            }
            catch (ClassCastException e2) {
                return new ArrayList();
            }
        }
    }

    public List<Map<String, Object>> getMapList(String path) {
        return this.getList(path);
    }

    public ConfigurationNode getNode(String path) {
        Map v = null;
        if ((v = (Map)this.getGeneric(path, v)) == null) {
            return null;
        }
        return new ConfigurationNode(v);
    }

    public List<ConfigurationNode> getNodes(String path) {
        List o = this.getList(path);
        if (o == null) {
            return new ArrayList<ConfigurationNode>();
        }
        ArrayList<ConfigurationNode> nodes = new ArrayList<ConfigurationNode>();
        for (Object i : o) {
            Map map;
            if (!(i instanceof Map)) continue;
            try {
                map = (Map)i;
            }
            catch (ClassCastException e) {
                continue;
            }
            nodes.add(new ConfigurationNode(map));
        }
        return nodes;
    }

    public void extend(Map<String, Object> other) {
        if (other != null) {
            ConfigurationNode.extendMap(this, other);
        }
    }

    private static final Object copyValue(Object v) {
        if (v instanceof Map) {
            Map mv = (Map)v;
            LinkedHashMap newv = new LinkedHashMap();
            for (Map.Entry me : mv.entrySet()) {
                newv.put(me.getKey(), ConfigurationNode.copyValue(me.getValue()));
            }
            return newv;
        }
        if (v instanceof List) {
            List lv = (List)v;
            ArrayList<Object> newv = new ArrayList<Object>();
            for (int i = 0; i < lv.size(); ++i) {
                newv.add(ConfigurationNode.copyValue(lv.get(i)));
            }
            return newv;
        }
        return v;
    }

    private static final void extendMap(Map<String, Object> left, Map<String, Object> right) {
        ConfigurationNode original = new ConfigurationNode(left);
        for (Map.Entry<String, Object> entry : right.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            original.put(key, ConfigurationNode.copyValue(value));
        }
    }

    public <T> T createInstance(Class<?>[] constructorParameters, Object[] constructorArguments) {
        String typeName = this.getString("class");
        try {
            Class<?> mapTypeClass = Class.forName(typeName);
            Class[] constructorParameterWithConfiguration = new Class[constructorParameters.length + 1];
            for (int i = 0; i < constructorParameters.length; ++i) {
                constructorParameterWithConfiguration[i] = constructorParameters[i];
            }
            constructorParameterWithConfiguration[constructorParameterWithConfiguration.length - 1] = ConfigurationNode.class;
            Object[] constructorArgumentsWithConfiguration = new Object[constructorArguments.length + 1];
            for (int i = 0; i < constructorArguments.length; ++i) {
                constructorArgumentsWithConfiguration[i] = constructorArguments[i];
            }
            constructorArgumentsWithConfiguration[constructorArgumentsWithConfiguration.length - 1] = this;
            Constructor<?> constructor = mapTypeClass.getConstructor(constructorParameterWithConfiguration);
            Object t = constructor.newInstance(constructorArgumentsWithConfiguration);
            return (T)t;
        }
        catch (Exception e) {
            Log.severe("Error loading maptype", e);
            e.printStackTrace();
            return null;
        }
    }

    public <T> List<T> createInstances(String path, Class<?>[] constructorParameters, Object[] constructorArguments) {
        List<ConfigurationNode> nodes = this.getNodes(path);
        ArrayList<T> instances = new ArrayList<T>();
        for (ConfigurationNode node : nodes) {
            T instance = node.createInstance(constructorParameters, constructorArguments);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.entries.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.entries.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.entries.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.entries.putAll(m);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.entries.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.entries.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries.entrySet();
    }

    private class EmptyNullRepresenter
    extends Representer {
        public EmptyNullRepresenter() {
            this.nullRepresenter = new EmptyRepresentNull();
        }

        @Override
        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            NodeTuple tuple = super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            Node valueNode = tuple.getValueNode();
            if (valueNode instanceof CollectionNode) {
                CollectionNode seq;
                if (Tag.SEQ.equals(valueNode.getTag()) && ((SequenceNode)(seq = (SequenceNode)valueNode)).getValue().isEmpty()) {
                    return null;
                }
                if (Tag.MAP.equals(valueNode.getTag()) && ((MappingNode)(seq = (MappingNode)valueNode)).getValue().isEmpty()) {
                    return null;
                }
            }
            return tuple;
        }

        protected class EmptyRepresentNull
        implements Represent {
            protected EmptyRepresentNull() {
            }

            @Override
            public Node representData(Object data) {
                return EmptyNullRepresenter.this.representScalar(Tag.NULL, "");
            }
        }
    }
}

