/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.WorldBorder;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class CmdSet
extends WBCmd {
    public CmdSet() {
        this.permission = "set";
        this.name = "set";
        this.hasWorldNameInput = true;
        this.consoleRequiresWorldName = false;
        this.minParams = 1;
        this.maxParams = 4;
        this.addCmdExample(this.nameEmphasizedW() + "<radiusX> [radiusZ] <x> <z> - use x/z coords.");
        this.addCmdExample(this.nameEmphasizedW() + "<radiusX> [radiusZ] ^spawn - use spawn point.");
        this.addCmdExample(this.nameEmphasized() + "<radiusX> [radiusZ] - set border, centered on you.", true, false, true);
        this.addCmdExample(this.nameEmphasized() + "<radiusX> [radiusZ] ^player <name> - center on player.");
        this.helpText = "Set a border for a world, with several options for defining the center location. [world] is optional for players and defaults to the world the player is in. If [radiusZ] is not specified, the radiusX value will be used for both. The <x> and <z> coordinates can be decimal values (ex. 1.234).";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        int radiusZ;
        int radiusX;
        double z;
        double x;
        if (params.size() == 1 && player == null) {
            this.sendErrorAndHelp(sender, "You have not provided a sufficient number of parameters.");
            return;
        }
        WorldServer world = null;
        if (worldName != null) {
            if (params.size() == 2 && !params.get(params.size() - 1).equalsIgnoreCase("spawn")) {
                this.sendErrorAndHelp(sender, "You have not provided a sufficient number of arguments.");
                return;
            }
            world = Worlds.getWorld(worldName);
            if (world == null) {
                if (params.get(params.size() - 1).equalsIgnoreCase("spawn")) {
                    this.sendErrorAndHelp(sender, "The world you specified (\"" + worldName + "\") could not be found on the server, so the spawn point cannot be determined.");
                    return;
                }
                Util.chat(sender, "The world you specified (\"" + worldName + "\") could not be found on the server, but data for it will be stored anyway.", new Object[0]);
            }
        } else {
            if (player == null) {
                if (!params.get(params.size() - 2).equalsIgnoreCase("player")) {
                    this.sendErrorAndHelp(sender, "You must specify a world name from console if not specifying a player name.");
                    return;
                }
                player = WorldBorder.SERVER.func_184103_al().func_152612_a(params.get(params.size() - 1));
                if (player == null) {
                    this.sendErrorAndHelp(sender, "The player you specified (\"" + params.get(params.size() - 1) + "\") does not appear to be online.");
                    return;
                }
            }
            worldName = Worlds.getWorldName(player.field_70170_p);
        }
        int radiusCount = params.size();
        try {
            if (params.get(params.size() - 1).equalsIgnoreCase("spawn")) {
                assert (world != null);
                BlockPos loc = world.func_175694_M();
                x = loc.func_177958_n();
                z = loc.func_177952_p();
                --radiusCount;
            } else if (params.size() > 2 && params.get(params.size() - 2).equalsIgnoreCase("player")) {
                EntityPlayerMP playerT = WorldBorder.SERVER.func_184103_al().func_152612_a(params.get(params.size() - 1));
                if (playerT == null) {
                    this.sendErrorAndHelp(sender, "The player you specified (\"" + params.get(params.size() - 1) + "\") does not appear to be online.");
                    return;
                }
                worldName = Worlds.getWorldName(playerT.field_70170_p);
                x = playerT.field_70165_t;
                z = playerT.field_70161_v;
                radiusCount -= 2;
            } else if (player == null || radiusCount > 2) {
                x = Double.parseDouble(params.get(params.size() - 2));
                z = Double.parseDouble(params.get(params.size() - 1));
                radiusCount -= 2;
            } else {
                x = player.field_70165_t;
                z = player.field_70161_v;
            }
            radiusX = Integer.parseInt(params.get(0));
            radiusZ = radiusCount < 2 ? radiusX : Integer.parseInt(params.get(1));
            if ((double)radiusX < Config.getKnockBack() || (double)radiusZ < Config.getKnockBack()) {
                this.sendErrorAndHelp(sender, "Radius value(s) must be more than the knockback distance.");
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "Radius value(s) must be integers and x and z values must be numerical.");
            return;
        }
        assert (worldName != null);
        Config.setBorder(worldName, radiusX, radiusZ, x, z);
        Util.chat(sender, "Border has been set. " + Config.BorderDescription(worldName), new Object[0]);
    }
}

