/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.DynMapFeatures;
import com.wimbli.WorldBorder.WBCommand;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.listener.BlockPlaceListener;
import com.wimbli.WorldBorder.listener.EnderPearlListener;
import com.wimbli.WorldBorder.listener.MobSpawnListener;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="worldborder", name="worldborder", version="1.0.0", serverSideOnly=true, acceptableRemoteVersions="*", acceptableSaveVersions="", acceptedMinecraftVersions="[1.12.2]")
public class WorldBorder {
    public static final String VERSION = "1.0.0";
    public static final String MODID = "worldborder";
    public static WorldBorder INSTANCE = null;
    public static MinecraftServer SERVER = null;
    public static WBCommand COMMAND = null;
    private BlockPlaceListener blockPlaceListener = null;
    private MobSpawnListener mobSpawnListener = null;
    private EnderPearlListener enderPearlListener = null;

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void clientPreInit(FMLPreInitializationEvent event) {
        Log.error("This mod is intended only for use on servers", new Object[0]);
        Log.error("Please consider removing this mod from your installation", new Object[0]);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    public void serverPreInit(FMLPreInitializationEvent event) {
        Config.setupConfigDir(event.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    public void serverStart(FMLServerStartingEvent event) {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        if (SERVER == null) {
            SERVER = event.getServer();
        }
        if (COMMAND == null) {
            COMMAND = new WBCommand();
        }
        Config.load(false);
        event.registerServerCommand((ICommand)COMMAND);
        if (Config.preventBlockPlace()) {
            this.enableBlockPlaceListener(true);
        }
        if (Config.preventMobSpawn()) {
            this.enableMobSpawnListener(true);
        }
        if (Config.getDenyEnderpearl()) {
            this.enableEnderPearlListener(true);
        }
        DynMapFeatures.registerListener();
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    public void serverPostStart(FMLServerStartedEvent event) {
        WBCommand.checkRegistrations(SERVER);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    public void serverStop(FMLServerStoppingEvent event) {
        DynMapFeatures.removeAllBorders();
        Config.storeFillTask();
    }

    @SideOnly(value=Side.SERVER)
    public BorderData getWorldBorder(String worldName) {
        return Config.Border(worldName);
    }

    @SideOnly(value=Side.SERVER)
    public void enableBlockPlaceListener(boolean enable) {
        if (enable) {
            this.blockPlaceListener = new BlockPlaceListener();
            MinecraftForge.EVENT_BUS.register((Object)this.blockPlaceListener);
        } else if (this.blockPlaceListener != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.blockPlaceListener);
        }
    }

    @SideOnly(value=Side.SERVER)
    public void enableMobSpawnListener(boolean enable) {
        if (enable) {
            this.mobSpawnListener = new MobSpawnListener();
            MinecraftForge.EVENT_BUS.register((Object)this.mobSpawnListener);
        } else if (this.mobSpawnListener != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.mobSpawnListener);
        }
    }

    @SideOnly(value=Side.SERVER)
    public void enableEnderPearlListener(boolean enable) {
        if (enable) {
            this.enderPearlListener = new EnderPearlListener();
            MinecraftForge.EVENT_BUS.register((Object)this.enderPearlListener);
        } else if (this.enderPearlListener != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.enderPearlListener);
        }
    }
}

