/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.environmental;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.heat.MuseHeatUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPlayerTickModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.common.utils.modulehelpers.FluidUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;

public abstract class CoolingSystemBase
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public CoolingSystemBase(EnumModuleTarget moduleTargetIn) {
        super(moduleTargetIn);
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack itemStack) {
        if (!player.field_70170_p.field_72995_K) {
            double currentHeat = MuseHeatUtils.getPlayerHeat((EntityPlayer)player);
            if (currentHeat <= 0.0) {
                return;
            }
            double maxHeat = MuseHeatUtils.getPlayerMaxHeat((EntityPlayer)player);
            FluidUtils fluidUtils = new FluidUtils(player, itemStack, this.getDataName());
            double fluidEfficiencyBoost = fluidUtils.getCoolingEfficiency();
            if (currentHeat < maxHeat) {
                double coolJoules = (fluidEfficiencyBoost + this.getCoolingBonus(itemStack)) * this.getCoolingFactor();
                if ((double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)player) > coolJoules) {
                    coolJoules = MuseHeatUtils.coolPlayer((EntityPlayer)player, (double)coolJoules);
                    ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)((int)(coolJoules * this.getEnergyConsumption(itemStack))));
                }
            } else {
                double overheatAmount = currentHeat - maxHeat;
                int fluidLevel = fluidUtils.getFluidLevel();
                boolean usedEmergencyCooling = false;
                if (fluidLevel >= (int)(fluidEfficiencyBoost * overheatAmount)) {
                    fluidUtils.drain((int)(fluidEfficiencyBoost * overheatAmount));
                    MuseHeatUtils.coolPlayer((EntityPlayer)player, (double)(overheatAmount + 1.0));
                    usedEmergencyCooling = true;
                } else if (fluidLevel > 0) {
                    fluidUtils.drain(fluidLevel);
                    MuseHeatUtils.coolPlayer((EntityPlayer)player, (double)(fluidEfficiencyBoost * (double)fluidLevel));
                    usedEmergencyCooling = true;
                }
                if (usedEmergencyCooling) {
                    for (int i = 0; i < 4; ++i) {
                        player.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public abstract double getCoolingFactor();

    public abstract double getCoolingBonus(@Nonnull ItemStack var1);

    public abstract double getEnergyConsumption(@Nonnull ItemStack var1);

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public abstract TextureAtlasSprite getIcon(ItemStack var1);

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_ENVIRONMENTAL;
    }

    public abstract String getDataName();
}

