/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.machinemuse.numina.common.base.MuseLogger;
import net.machinemuse.powersuits.common.base.InstallCost;
import net.machinemuse.powersuits.common.base.MPSItems;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.config.CosmeticPresetSaveLoad;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmorBoots;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.common.item.tool.ItemPowerFist;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="powersuits", name="machinemuse/powersuits")
public class MPSSettings {
    public static HUD hud = new HUD();
    public static RecipesAllowed recipesAllowed = new RecipesAllowed();
    public static General general = new General();
    public static Modules modules = new Modules();
    public static Limits limits = new Limits();
    public static Cosmetics cosmetics = new Cosmetics();

    public static void loadCustomInstallCosts() {
        try {
            File installCostFile = new File(Loader.instance().getConfigDir() + "/machinemuse/", "custominstallcosts.json");
            Gson gson = new Gson();
            if (installCostFile.exists()) {
                InstallCost[] costs;
                DataInputStream is = new DataInputStream(new FileInputStream(installCostFile));
                byte[] bytes = new byte[(int)installCostFile.length()];
                is.readFully(bytes);
                String string = Charset.defaultCharset().decode(ByteBuffer.wrap(bytes)).toString();
                is.close();
                MuseLogger.logDebug((String)string);
                for (InstallCost cost : costs = (InstallCost[])gson.fromJson(string, InstallCost[].class)) {
                    String moduleName = cost.moduleName;
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(cost.modId, cost.itemName));
                    if (item != null) {
                        int metadata;
                        int quantity = cost.itemQuantity == null ? 1 : cost.itemQuantity;
                        ItemStack stack = new ItemStack(item, quantity, metadata = cost.itemMetadata == null ? 0 : cost.itemMetadata);
                        if (!stack.func_190926_b()) {
                            ModuleManager.INSTANCE.addCustomInstallCost(moduleName, stack);
                            continue;
                        }
                        MuseLogger.logError((String)("Invalid Itemstack in custom install cost. Module [" + cost.moduleName + "], item [" + cost.itemName + "]"));
                        continue;
                    }
                    MuseLogger.logError((String)("Invalid Item in custom install cost. Module [" + cost.moduleName + "], item [" + cost.itemName + "]"));
                }
            } else {
                installCostFile.createNewFile();
                InstallCost examplecost = new InstallCost();
                examplecost.moduleName = "Shock Absorber";
                examplecost.itemName = "wool";
                examplecost.modId = "minecraft";
                examplecost.itemQuantity = 2;
                examplecost.itemMetadata = 0;
                InstallCost examplecost2 = new InstallCost();
                examplecost2.moduleName = "Shock Absorber";
                examplecost2.itemName = "powerArmorComponent";
                examplecost2.modId = "powersuits";
                examplecost2.itemQuantity = 2;
                examplecost2.itemMetadata = 2;
                InstallCost[] output = new InstallCost[]{examplecost, examplecost2};
                String json = gson.toJson((Object)output);
                PrintWriter dest = new PrintWriter(installCostFile);
                dest.write(json);
                dest.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Cosmetics {
        @Config.Comment(value={"Use legacy cosmetic configuration instead of cosmetic presets"})
        public boolean useLegacyCosmeticSystem = true;
        @Config.Comment(value={"Allow high polly armor models instead of just skins"})
        public boolean allowHighPollyArmorModuels = true;
        @Config.Comment(value={"Allow PowerFist model to be customized"})
        public boolean allowPowerFistCustomization = false;
        @Config.Ignore
        private BiMap<String, NBTTagCompound> cosmeticPresetsPowerFist = HashBiMap.create();
        @Config.Ignore
        private BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorHelmet = HashBiMap.create();
        @Config.Ignore
        private BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorChestplate = HashBiMap.create();
        @Config.Ignore
        private BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorLeggings = HashBiMap.create();
        @Config.Ignore
        private BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorBoots = HashBiMap.create();

        public void updateCosmeticInfo(ResourceLocation location, String name, NBTTagCompound cosmeticInfo) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
            if (item instanceof ItemPowerFist) {
                this.cosmeticPresetsPowerFist.put((Object)name, (Object)cosmeticInfo);
            } else if (item instanceof ItemPowerArmorHelmet) {
                this.cosmeticPresetsPowerArmorHelmet.put((Object)name, (Object)cosmeticInfo);
            } else if (item instanceof ItemPowerArmorChestplate) {
                this.cosmeticPresetsPowerArmorChestplate.put((Object)name, (Object)cosmeticInfo);
            } else if (item instanceof ItemPowerArmorLeggings) {
                this.cosmeticPresetsPowerArmorLeggings.put((Object)name, (Object)cosmeticInfo);
            } else if (item instanceof ItemPowerArmorBoots) {
                this.cosmeticPresetsPowerArmorBoots.put((Object)name, (Object)cosmeticInfo);
            }
        }

        public BiMap<String, NBTTagCompound> getCosmeticPresetsPowerFist() {
            if (this.cosmeticPresetsPowerFist.isEmpty() && !this.allowPowerFistCustomization) {
                this.cosmeticPresetsPowerFist = CosmeticPresetSaveLoad.loadPresetsForItem((Item)MPSItems.powerFist, 0);
            }
            return this.cosmeticPresetsPowerFist;
        }

        public BiMap<String, NBTTagCompound> getCosmeticPresetsPowerArmorHelmet() {
            if (this.cosmeticPresetsPowerArmorHelmet.isEmpty() && !this.useLegacyCosmeticSystem) {
                this.cosmeticPresetsPowerArmorHelmet = CosmeticPresetSaveLoad.loadPresetsForItem((Item)MPSItems.powerArmorHead, 0);
            }
            return this.cosmeticPresetsPowerArmorHelmet;
        }

        public BiMap<String, NBTTagCompound> getCosmeticPresetsPowerArmorChestplate() {
            if (this.cosmeticPresetsPowerArmorChestplate.isEmpty() && !this.useLegacyCosmeticSystem) {
                this.cosmeticPresetsPowerArmorChestplate = CosmeticPresetSaveLoad.loadPresetsForItem((Item)MPSItems.powerArmorTorso, 0);
            }
            return this.cosmeticPresetsPowerArmorChestplate;
        }

        public BiMap<String, NBTTagCompound> getCosmeticPresetsPowerArmorLeggings() {
            if (this.cosmeticPresetsPowerArmorLeggings.isEmpty() && !this.useLegacyCosmeticSystem) {
                this.cosmeticPresetsPowerArmorLeggings = CosmeticPresetSaveLoad.loadPresetsForItem((Item)MPSItems.powerArmorLegs, 0);
            }
            return this.cosmeticPresetsPowerArmorLeggings;
        }

        public BiMap<String, NBTTagCompound> getCosmeticPresetsPowerArmorBoots() {
            if (this.cosmeticPresetsPowerArmorBoots.isEmpty() && !this.useLegacyCosmeticSystem) {
                this.cosmeticPresetsPowerArmorBoots = CosmeticPresetSaveLoad.loadPresetsForItem((Item)MPSItems.powerArmorFeet, 0);
            }
            return this.cosmeticPresetsPowerArmorBoots;
        }
    }

    public static class Limits {
        @Config.LangKey(value="config.powersuits.limitsmaxArmorModules")
        @Config.Comment(value={"Max number of Armor modules per armor item"})
        @Config.RangeInt(min=0, max=99)
        public int maxArmorModules = 1;
        @Config.LangKey(value="config.powersuits.limitsmaxEnergyStorageModules")
        @Config.Comment(value={"Max number of Energy Storage modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxEnergyStorageModules = 1;
        @Config.LangKey(value="config.powersuits.limitsmaxEnergyGenModules")
        @Config.Comment(value={"Max number of Energy Storage modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxEnergyGenModules = 1;
        @Config.LangKey(value="config.powersuits.limitsmaxToolModules")
        @Config.Comment(value={"Max number of Tool modules per Power Fist"})
        @Config.RangeInt(min=0, max=99)
        public int maxToolModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxWeaponModules")
        @Config.Comment(value={"Max number of Weapon modules per Power Fist"})
        @Config.RangeInt(min=0, max=99)
        public int maxWeaponModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxMovementModules")
        @Config.Comment(value={"Max number of Movement modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxMovementModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxCosmeticModules")
        @Config.Comment(value={"Max number of Cosmetic modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxCosmeticModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxVisionModules")
        @Config.Comment(value={"Max number of Vision modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxVisionModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxEnvironmentalModules")
        @Config.Comment(value={"Max number of Environmental modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxEnvironmentalModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxSpecialModules")
        @Config.Comment(value={"Max number of Special modules per item"})
        @Config.RangeInt(min=0, max=99)
        public int maxSpecialModules = 99;
        @Config.LangKey(value="config.powersuits.limitsmaxMiningEnhancementModules")
        @Config.Comment(value={"Max number of Mining Enhancement modules per Power Fist"})
        @Config.RangeInt(min=0, max=99)
        public int maxMiningEnhancementModules = 99;
    }

    public static class Modules {
        @Config.LangKey(value="config.powersuits.module")
        @Config.Comment(value={"Whether or not specified module is allowed"})
        public Map<String, Boolean> allowedModules = new HashMap<String, Boolean>(){
            {
                this.put("debugModule", true);
                this.put("leatherPlating", true);
                this.put("ironPlating", true);
                this.put("diamondPlating", true);
                this.put("energyShield", true);
                this.put("transparentArmor", true);
                this.put("basicBattery", true);
                this.put("advancedBattery", true);
                this.put("eliteBattery", true);
                this.put("ultimateBattery", true);
                this.put("advSolarGenerator", true);
                this.put("coalGenerator", true);
                this.put("kineticGenerator", true);
                this.put("solarGenerator", true);
                this.put("thermalGenerator", true);
                this.put("airtightSeal", true);
                this.put("apiaristArmor", true);
                this.put("autoFeeder", true);
                this.put("basicCoolingSystem", true);
                this.put("hazmat", true);
                this.put("mobRepulsor", true);
                this.put("advancedCoolingSystem", true);
                this.put("waterElectrolyzer", true);
                this.put("blinkDrive", true);
                this.put("climbAssist", true);
                this.put("flightControl", true);
                this.put("glider", true);
                this.put("jetBoots", true);
                this.put("jetpack", true);
                this.put("jumpAssist", true);
                this.put("parachute", true);
                this.put("shockAbsorber", true);
                this.put("sprintAssist", true);
                this.put("swimAssist", true);
                this.put("clock", true);
                this.put("compass", true);
                this.put("invisibility", true);
                this.put("magnet", true);
                this.put("binoculars", true);
                this.put("nightVision", true);
                this.put("aurameter", true);
                this.put("appengECWirelessFluid", true);
                this.put("appengWireless", true);
                this.put("axe", true);
                this.put("chisel", false);
                this.put("diamondPickUpgrade", true);
                this.put("dimRiftGen", true);
                this.put("fieldTinkerer", true);
                this.put("flintAndSteel", true);
                this.put("grafter", true);
                this.put("hoe", true);
                this.put("leafBlower", true);
                this.put("luxCapacitor", true);
                this.put("mffsFieldTeleporter", true);
                this.put("ocTerminal", true);
                this.put("omniProbe", true);
                this.put("omniwrench", true);
                this.put("oreScanner", true);
                this.put("cmPSD", true);
                this.put("pickaxe", true);
                this.put("portableCraftingTable", true);
                this.put("refinedStorageWirelessGrid", true);
                this.put("scoop", true);
                this.put("shears", true);
                this.put("shovel", true);
                this.put("treetap", true);
                this.put("aoePickUpgrade", true);
                this.put("aquaAffinity", true);
                this.put("fortuneModule", false);
                this.put("madModule", true);
                this.put("silk_touch", true);
                this.put("bladeLauncher", true);
                this.put("lightningSummoner", true);
                this.put("meleeAssist", true);
                this.put("plasmaCannon", true);
                this.put("railgun", true);
            }
        };
        @Config.LangKey(value="config.powersuits.modulePropertyDoubles")
        @Config.Comment(value={"Value of specified property"})
        public Map<String, Double> propertyDouble = new HashMap<String, Double>(){
            {
                this.put("advSolarGenerator.daytimeEnergyGen.base", 45000.0);
                this.put("advSolarGenerator.daytimeHeatGen.base", 15.0);
                this.put("advSolarGenerator.nightTimeEnergyGen.base", 1500.0);
                this.put("advSolarGenerator.nightTimeHeatGen.base", 5.0);
                this.put("advSolarGenerator.slotPoints.base", 1.0);
                this.put("advancedBattery.maxEnergy.base", 5000000.0);
                this.put("advancedBattery.slotPoints.base", 1.0);
                this.put("advancedCoolingSystem.advCoolSysEnergyCon.advancedCoolingPower.multiplier", 160.0);
                this.put("advancedCoolingSystem.coolingBonus.advancedCoolingPower.multiplier", 7.0);
                this.put("advancedCoolingSystem.slotPoints.base", 1.0);
                this.put("aoePickUpgrade.aoeEnergyCon.base", 500.0);
                this.put("aoePickUpgrade.aoeEnergyCon.diameter.multiplier", 9500.0);
                this.put("aoePickUpgrade.aoeMiningDiameter.diameter.multiplier", 5.0);
                this.put("aoePickUpgrade.slotPoints.base", 1.0);
                this.put("apiaristArmor.apiaristArmorEnergyCon.base", 100.0);
                this.put("apiaristArmor.slotPoints.base", 1.0);
                this.put("appengECWirelessFluid.slotPoints.base", 1.0);
                this.put("appengWireless.slotPoints.base", 1.0);
                this.put("aquaAffinity.slotPoints.base", 1.0);
                this.put("aquaAffinity.underWaterEnergyCon.base", 0.0);
                this.put("aquaAffinity.underWaterEnergyCon.power.multiplier", 1000.0);
                this.put("aquaAffinity.underWaterHarvSpeed.base", 0.2);
                this.put("aquaAffinity.underWaterHarvSpeed.power.multiplier", 0.8);
                this.put("aurameter.slotPoints.base", 1.0);
                this.put("autoFeeder.autoFeederEfficiency.base", 50.0);
                this.put("autoFeeder.autoFeederEfficiency.efficiency.multiplier", 50.0);
                this.put("autoFeeder.eatingEnergyCon.base", 100.0);
                this.put("autoFeeder.eatingEnergyCon.efficiency.multiplier", 1000.0);
                this.put("autoFeeder.slotPoints.base", 1.0);
                this.put("axe.axeEnergyCon.base", 500.0);
                this.put("axe.axeEnergyCon.overclock.multiplier", 9500.0);
                this.put("axe.axeHarvSpd.base", 8.0);
                this.put("axe.axeHarvSpd.overclock.multiplier", 22.0);
                this.put("axe.slotPoints.base", 1.0);
                this.put("basicBattery.maxEnergy.base", 1000000.0);
                this.put("basicBattery.slotPoints.base", 1.0);
                this.put("basicCoolingSystem.coolingBonus.basicCoolingPower.multiplier", 4.0);
                this.put("basicCoolingSystem.coolingSystemEnergyCon.basicCoolingPower.multiplier", 100.0);
                this.put("basicCoolingSystem.slotPoints.base", 1.0);
                this.put("binoculars.fieldOfView.base", 0.5);
                this.put("binoculars.fieldOfView.fOVMult.multiplier", 9.5);
                this.put("binoculars.slotPoints.base", 1.0);
                this.put("bladeLauncher.slotPoints.base", 1.0);
                this.put("bladeLauncher.spinBladeDam.base", 6.0);
                this.put("bladeLauncher.spinBladeEnergyCon.base", 5000.0);
                this.put("blinkDrive.blinkDriveEnergyCon.base", 10000.0);
                this.put("blinkDrive.blinkDriveEnergyCon.range.multiplier", 30000.0);
                this.put("blinkDrive.blinkDriveRange.base", 5.0);
                this.put("blinkDrive.blinkDriveRange.range.multiplier", 59.0);
                this.put("blinkDrive.slotPoints.base", 1.0);
                this.put("climbAssist.slotPoints.base", 1.0);
                this.put("clock.slotPoints.base", 1.0);
                this.put("compass.slotPoints.base", 1.0);
                this.put("diamondPickUpgrade.slotPoints.base", 1.0);
                this.put("diamondPlating.armorPhysical.base", 5.0);
                this.put("diamondPlating.maxHeat.base", 400.0);
                this.put("diamondPlating.slotPoints.base", 1.0);
                this.put("dimRiftGen.energyCon.base", 200000.0);
                this.put("dimRiftGen.heatGeneration.base", 55.0);
                this.put("dimRiftGen.slotPoints.base", 1.0);
                this.put("eliteBattery.maxEnergy.base", 5.0E7);
                this.put("eliteBattery.slotPoints.base", 1.0);
                this.put("energyShield.armorEnergy.fieldStrength.multiplier", 6.0);
                this.put("energyShield.armorEnergyPerDamage.fieldStrength.multiplier", 5000.0);
                this.put("energyShield.maxHeat.fieldStrength.multiplier", 500.0);
                this.put("energyShield.slotPoints.base", 1.0);
                this.put("fieldTinkerer.slotPoints.base", 1.0);
                this.put("flightControl.slotPoints.base", 1.0);
                this.put("flightControl.yLookRatio.vertically.multiplier", 1.0);
                this.put("flintAndSteel.ignitEnergyCon.base", 10000.0);
                this.put("flintAndSteel.slotPoints.base", 1.0);
                this.put("fortuneModule.fortuneEnCon.base", 500.0);
                this.put("fortuneModule.fortuneEnCon.enchLevel.multiplier", 9500.0);
                this.put("fortuneModule.fortuneLevel.enchLevel.multiplier", 3.0);
                this.put("fortuneModule.slotPoints.base", 1.0);
                this.put("glider.slotPoints.base", 1.0);
                this.put("grafter.grafterEnergyCon.base", 10000.0);
                this.put("grafter.grafterHeatGen.base", 20.0);
                this.put("grafter.slotPoints.base", 1.0);
                this.put("hazmat.slotPoints.base", 1.0);
                this.put("hoe.hoeEnergyCon.base", 500.0);
                this.put("hoe.hoeEnergyCon.radius.multiplier", 9500.0);
                this.put("hoe.hoeSearchRad.radius.multiplier", 8.0);
                this.put("hoe.slotPoints.base", 1.0);
                this.put("invisibility.slotPoints.base", 1.0);
                this.put("ironPlating.armorPhysical.base", 4.0);
                this.put("ironPlating.maxHeat.base", 300.0);
                this.put("ironPlating.slotPoints.base", 1.0);
                this.put("jetBoots.jetBootsEnergyCon.base", 0.0);
                this.put("jetBoots.jetBootsEnergyCon.thrust.multiplier", 750.0);
                this.put("jetBoots.jetbootsThrust.base", 0.0);
                this.put("jetBoots.jetbootsThrust.thrust.multiplier", 0.08);
                this.put("jetBoots.slotPoints.base", 1.0);
                this.put("jetpack.jetpackEnergyCon.base", 0.0);
                this.put("jetpack.jetpackEnergyCon.thrust.multiplier", 1500.0);
                this.put("jetpack.jetpackThrust.base", 0.0);
                this.put("jetpack.jetpackThrust.thrust.multiplier", 0.16);
                this.put("jetpack.slotPoints.base", 1.0);
                this.put("jumpAssist.jumpBoost.base", 1.0);
                this.put("jumpAssist.jumpBoost.power.multiplier", 4.0);
                this.put("jumpAssist.jumpEnergyCon.base", 0.0);
                this.put("jumpAssist.jumpEnergyCon.compensation.multiplier", 50.0);
                this.put("jumpAssist.jumpEnergyCon.power.multiplier", 250.0);
                this.put("jumpAssist.jumpExhaustComp.base", 0.0);
                this.put("jumpAssist.jumpExhaustComp.compensation.multiplier", 1.0);
                this.put("jumpAssist.slotPoints.base", 1.0);
                this.put("kineticGenerator.energyPerBlock.base", 2000.0);
                this.put("kineticGenerator.energyPerBlock.energyGenerated.multiplier", 6000.0);
                this.put("kineticGenerator.movementResistance.base", 0.0);
                this.put("kineticGenerator.movementResistance.energyGenerated.multiplier", 0.5);
                this.put("kineticGenerator.slotPoints.base", 1.0);
                this.put("leafBlower.energyCon.base", 500.0);
                this.put("leafBlower.energyCon.radius.multiplier", 9500.0);
                this.put("leafBlower.radius.base", 1.0);
                this.put("leafBlower.radius.radius.multiplier", 15.0);
                this.put("leafBlower.slotPoints.base", 1.0);
                this.put("leatherPlating.armorPhysical.base", 3.0);
                this.put("leatherPlating.maxHeat.base", 75.0);
                this.put("leatherPlating.slotPoints.base", 1.0);
                this.put("lightningSummoner.energyCon.base", 4900000.0);
                this.put("lightningSummoner.heatEmission.base", 100.0);
                this.put("lightningSummoner.slotPoints.base", 1.0);
                this.put("luxCapacitor.luxCapBlue.blue.multiplier", 1.0);
                this.put("luxCapacitor.luxCapEnergyCon.base", 1000.0);
                this.put("luxCapacitor.luxCapGreen.green.multiplier", 1.0);
                this.put("luxCapacitor.luxCapRed.red.multiplier", 1.0);
                this.put("luxCapacitor.slotPoints.base", 1.0);
                this.put("madModule.energyCon.base", 100.0);
                this.put("madModule.slotPoints.base", 1.0);
                this.put("magnet.energyCon.base", 0.0);
                this.put("magnet.energyCon.power.multiplier", 2000.0);
                this.put("magnet.magnetRadius.base", 5.0);
                this.put("magnet.magnetRadius.power.multiplier", 10.0);
                this.put("magnet.slotPoints.base", 1.0);
                this.put("meleeAssist.meleeDamage.base", 2.0);
                this.put("meleeAssist.meleeDamage.impact.multiplier", 8.0);
                this.put("meleeAssist.meleeKnockback.carryThrough.multiplier", 1.0);
                this.put("meleeAssist.punchEnergyCon.base", 10.0);
                this.put("meleeAssist.punchEnergyCon.carryThrough.multiplier", 200.0);
                this.put("meleeAssist.punchEnergyCon.impact.multiplier", 1000.0);
                this.put("meleeAssist.slotPoints.base", 1.0);
                this.put("mobRepulsor.repulsorEnergyCon.base", 2500.0);
                this.put("mobRepulsor.slotPoints.base", 1.0);
                this.put("nightVision.slotPoints.base", 1.0);
                this.put("omniwrench.slotPoints.base", 1.0);
                this.put("oreScanner.slotPoints.base", 1.0);
                this.put("parachute.slotPoints.base", 1.0);
                this.put("pickaxe.pickHarvSpd.base", 8.0);
                this.put("pickaxe.pickHarvSpd.overclock.multiplier", 52.0);
                this.put("pickaxe.pickaxeEnergyCon.base", 500.0);
                this.put("pickaxe.pickaxeEnergyCon.overclock.multiplier", 9500.0);
                this.put("pickaxe.slotPoints.base", 1.0);
                this.put("plasmaCannon.plasmaDamage.amperage.multiplier", 38.0);
                this.put("plasmaCannon.plasmaDamage.base", 2.0);
                this.put("plasmaCannon.plasmaEnergyPerTick.amperage.multiplier", 1500.0);
                this.put("plasmaCannon.plasmaEnergyPerTick.base", 100.0);
                this.put("plasmaCannon.plasmaEnergyPerTick.voltage.multiplier", 500.0);
                this.put("plasmaCannon.plasmaExplosiveness.voltage.multiplier", 0.5);
                this.put("plasmaCannon.slotPoints.base", 1.0);
                this.put("portableCraftingTable.slotPoints.base", 1.0);
                this.put("railgun.railgunEnergyCost;.base", 5000.0);
                this.put("railgun.railgunEnergyCost;.voltage.multiplier", 25000.0);
                this.put("railgun.railgunHeatEm.base", 2.0);
                this.put("railgun.railgunHeatEm.voltage.multiplier", 10.0);
                this.put("railgun.railgunTotalImpulse.base", 500.0);
                this.put("railgun.railgunTotalImpulse.voltage.multiplier", 2500.0);
                this.put("railgun.slotPoints.base", 1.0);
                this.put("refinedStorageWirelessGrid.slotPoints.base", 1.0);
                this.put("scoop.scoopEnergyCon.base", 20000.0);
                this.put("scoop.scoopHarSpd.base", 5.0);
                this.put("scoop.slotPoints.base", 1.0);
                this.put("shears.shearEnergyCon.base", 1000.0);
                this.put("shears.shearHarvSpd.base", 8.0);
                this.put("shears.slotPoints.base", 1.0);
                this.put("shockAbsorber.distanceRed.base", 0.0);
                this.put("shockAbsorber.distanceRed.power.multiplier", 10.0);
                this.put("shockAbsorber.impactEnergyCon.base", 0.0);
                this.put("shockAbsorber.impactEnergyCon.power.multiplier", 100.0);
                this.put("shockAbsorber.slotPoints.base", 1.0);
                this.put("shovel.shovelEnergyCon.base", 500.0);
                this.put("shovel.shovelEnergyCon.overclock.multiplier", 9500.0);
                this.put("shovel.shovelHarvSpd.base", 8.0);
                this.put("shovel.shovelHarvSpd.overclock.multiplier", 22.0);
                this.put("shovel.slotPoints.base", 1.0);
                this.put("silk_touch.silkTouchEnCon.base", 2500.0);
                this.put("silk_touch.slotPoints.base", 1.0);
                this.put("solarGenerator.daytimeEnergyGen.base", 15000.0);
                this.put("solarGenerator.nightTimeEnergyGen.base", 1500.0);
                this.put("solarGenerator.slotPoints.base", 1.0);
                this.put("sprintAssist.slotPoints.base", 1.0);
                this.put("sprintAssist.sprintEnergyCon.base", 0.0);
                this.put("sprintAssist.sprintEnergyCon.compensation.multiplier", 20.0);
                this.put("sprintAssist.sprintEnergyCon.sprintAssist.multiplier", 100.0);
                this.put("sprintAssist.sprintExComp.base", 0.0);
                this.put("sprintAssist.sprintExComp.compensation.multiplier", 1.0);
                this.put("sprintAssist.sprintSpeedMult.base", 0.01);
                this.put("sprintAssist.sprintSpeedMult.sprintAssist.multiplier", 2.49);
                this.put("sprintAssist.walkingEnergyCon.base", 0.0);
                this.put("sprintAssist.walkingEnergyCon.walkingAssist.multiplier", 100.0);
                this.put("sprintAssist.walkingSpeedMult.base", 0.01);
                this.put("sprintAssist.walkingSpeedMult.walkingAssist.multiplier", 1.99);
                this.put("swimAssist.slotPoints.base", 1.0);
                this.put("swimAssist.swimBoostEnergyCon.thrust.multiplier", 1000.0);
                this.put("swimAssist.underwaterMovBoost.thrust.multiplier", 1.0);
                this.put("thermalGenerator.slotPoints.base", 1.0);
                this.put("thermalGenerator.thermalEnergyGen.base", 250.0);
                this.put("thermalGenerator.thermalEnergyGen.energyGenerated.multiplier", 250.0);
                this.put("transparentArmor.slotPoints.base", 1.0);
                this.put("treetap.energyCon.base", 1000.0);
                this.put("treetap.slotPoints.base", 1.0);
                this.put("ultimateBattery.maxEnergy.base", 1.0E8);
                this.put("ultimateBattery.slotPoints.base", 1.0);
                this.put("waterElectrolyzer.joltEnergy.base", 10000.0);
                this.put("waterElectrolyzer.slotPoints.base", 1.0);
            }
        };
        @Config.LangKey(value="config.powersuits.modulePropertyIntegers")
        @Config.Comment(value={"Value of specified property"})
        public Map<String, Integer> propertyInteger = new HashMap<String, Integer>(){};
    }

    public static class General {
        @Config.LangKey(value="config.powersuits.general.useOldAutofeeder")
        @Config.Comment(value={"Use Old Auto Feeder Method"})
        public boolean useOldAutoFeeder = false;
        @Config.LangKey(value="config.powersuits.general.use24HrClock")
        @Config.Comment(value={"Use a 24h clock instead of 12h"})
        public boolean use24hClock = false;
        @Config.LangKey(value="config.powersuits.general.allowConflictingKeybinds")
        @Config.Comment(value={"Allow Conflicting Keybinds"})
        public boolean allowConflictingKeybinds = true;
        @Config.LangKey(value="config.powersuits.general.maxFlyingSpeed")
        @Config.Comment(value={"Maximum flight speed (in m/s)"})
        public double getMaximumFlyingSpeedmps = 25.0;
        @Config.LangKey(value="config.powersuits.general.getMaximumArmorPerPiece")
        @Config.Comment(value={"Maximum Armor per Piece"})
        @Config.RangeDouble(min=0.0, max=8.0)
        @Config.RequiresWorldRestart
        public double getMaximumArmorPerPiece = 6.0;
        @Config.LangKey(value="config.powersuits.general.salvageChance")
        @Config.Comment(value={"Chance of each item being returned when salvaged"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double getSalvageChance = 0.9;
        @Config.LangKey(value="config.powersuits.general.baseMaxHeatPowerfist")
        @Config.Comment(value={"PowerFist Base Heat Cap"})
        public double baseMaxHeatPowerFist = 5.0;
        @Config.LangKey(value="config.powersuits.general.baseMaxHeatHelmet")
        @Config.Comment(value={"Power Armor Helmet Heat Cap"})
        public double baseMaxHeatHelmet = 5.0;
        @Config.LangKey(value="config.powersuits.general.baseMaxHeatChest")
        @Config.Comment(value={"Power Armor Chestplate Heat Cap"})
        public double baseMaxHeatChest = 20.0;
        @Config.LangKey(value="config.powersuits.general.baseMaxHeatLegs")
        @Config.Comment(value={"Power Armor Leggings Heat Cap"})
        public double baseMaxHeatLegs = 15.0;
        @Config.LangKey(value="config.powersuits.general.baseMaxHeatFeet")
        @Config.Comment(value={"ItemModuleBase Heat Cap"})
        public double baseMaxHeatFeet = 5.0;
    }

    public static class RecipesAllowed {
        @Config.Comment(value={"Use recipes for Thermal Expansion"})
        public boolean useThermalExpansionRecipes = true;
        @Config.Comment(value={"Use recipes for EnderIO"})
        public boolean useEnderIORecipes = true;
        @Config.Comment(value={"Use recipes for TechReborn"})
        public boolean useTechRebornRecipes = true;
        @Config.Comment(value={"Use recipes for IndustrialCraft 2"})
        public boolean useIC2Recipes = true;
    }

    public static class HUD {
        @Config.LangKey(value="config.powersuits.hud.useGraphicalMeters")
        @Config.Comment(value={"Use Graphical Meters"})
        public static boolean useGraphicalMeters = true;
        @Config.LangKey(value="config.powersuits.hud.enableModuleSpam")
        @Config.Comment(value={"Chat message when toggling module"})
        public boolean toggleModuleSpam = false;
        @Config.LangKey(value="config.powersuits.hud.DisplayHUD")
        @Config.Comment(value={"Display HUD"})
        public boolean keybindHUDon = true;
        @Config.LangKey(value="config.powersuits.hud.Xposition")
        @Config.Comment(value={"x position"})
        @Config.RangeDouble(min=0.0)
        public double keybindHUDx = 8.0;
        @Config.LangKey(value="config.powersuits.hud.Yposition")
        @Config.Comment(value={"y position"})
        @Config.RangeDouble(min=0.0)
        public double keybindHUDy = 32.0;
    }
}

