/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.capabilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.common.module.IModuleManager;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MPSChestPlateFluidHandler
implements IFluidHandler,
IFluidHandlerItem,
INBTSerializable<NBTTagCompound> {
    public BasicCoolingTank basicCoolingTank;
    public AdvancedCoolingTank advancedCoolingTank;
    ItemStack container;
    List<ArmorTank> subHandlers;
    List<ArmorTank> allHandlers;
    IModuleManager moduleManager;

    public MPSChestPlateFluidHandler(@Nonnull ItemStack container, IModuleManager moduleManager) {
        this.container = container;
        this.moduleManager = moduleManager;
        this.basicCoolingTank = new BasicCoolingTank();
        this.advancedCoolingTank = new AdvancedCoolingTank();
        this.subHandlers = new LinkedList<ArmorTank>();
        this.allHandlers = new LinkedList<ArmorTank>(){
            {
                this.add(MPSChestPlateFluidHandler.this.basicCoolingTank);
                this.add(MPSChestPlateFluidHandler.this.advancedCoolingTank);
            }
        };
    }

    public void addHandler(ArmorTank handler) {
        if (!this.subHandlers.contains(handler)) {
            this.subHandlers.add(handler);
        }
    }

    @Nullable
    public ArmorTank getFluidTank(String dataName) {
        for (ArmorTank tank : this.subHandlers) {
            if (!tank.moduleDataName.equals(dataName)) continue;
            return tank;
        }
        return null;
    }

    public void removeHandler(IFluidHandler handler) {
        this.subHandlers.remove(handler);
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList tanks = Lists.newArrayList();
        for (IFluidHandler iFluidHandler : this.subHandlers) {
            Collections.addAll(tanks, iFluidHandler.getTankProperties());
        }
        return tanks.toArray(new IFluidTankProperties[tanks.size()]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        resource = resource.copy();
        int totalFillAmount = 0;
        for (IFluidHandler iFluidHandler : this.subHandlers) {
            int fillAmount = iFluidHandler.fill(resource, doFill);
            totalFillAmount += fillAmount;
            resource.amount -= fillAmount;
            if (resource.amount > 0) continue;
            break;
        }
        NBTTagCompound nbt = this.serializeNBT();
        for (ArmorTank armorTank : this.allHandlers) {
            if (!nbt.func_150297_b(armorTank.moduleDataName, 10)) continue;
            armorTank = (ArmorTank)armorTank.readFromModuleTag(nbt.func_74775_l(armorTank.moduleDataName));
            this.addHandler(armorTank);
        }
        return totalFillAmount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        resource = resource.copy();
        FluidStack totalDrained = null;
        for (IFluidHandler iFluidHandler : this.subHandlers) {
            FluidStack drain = iFluidHandler.drain(resource, doDrain);
            if (drain == null) continue;
            if (totalDrained == null) {
                totalDrained = drain;
            } else {
                totalDrained.amount += drain.amount;
            }
            resource.amount -= drain.amount;
            if (resource.amount > 0) continue;
            break;
        }
        NBTTagCompound nbt = this.serializeNBT();
        for (ArmorTank armorTank : this.allHandlers) {
            if (!nbt.func_150297_b(armorTank.moduleDataName, 10)) continue;
            armorTank = (ArmorTank)armorTank.readFromModuleTag(nbt.func_74775_l(armorTank.moduleDataName));
            this.addHandler(armorTank);
        }
        return totalDrained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain == 0) {
            return null;
        }
        FluidStack totalDrained = null;
        for (IFluidHandler iFluidHandler : this.subHandlers) {
            if (totalDrained == null) {
                totalDrained = iFluidHandler.drain(maxDrain, doDrain);
                if (totalDrained != null) {
                    maxDrain -= totalDrained.amount;
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.amount = maxDrain;
                FluidStack drain = iFluidHandler.drain(copy, doDrain);
                if (drain != null) {
                    totalDrained.amount += drain.amount;
                    maxDrain -= drain.amount;
                }
            }
            if (maxDrain > 0) continue;
            break;
        }
        return totalDrained;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public void updateFromNBT() {
        NBTTagCompound itemNBT = MuseNBTUtils.getMuseItemTag((ItemStack)this.container);
        if (itemNBT != null) {
            for (ArmorTank tank : this.allHandlers) {
                if (!this.moduleManager.itemHasModule(this.container, tank.moduleDataName)) continue;
                tank = (ArmorTank)tank.readFromItemTag(itemNBT);
                this.addHandler(tank);
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbtOut = new NBTTagCompound();
        for (IFluidHandler iFluidHandler : this.subHandlers) {
            if (!(iFluidHandler instanceof ArmorTank) || !this.moduleManager.itemHasModule(this.container, ((ArmorTank)iFluidHandler).moduleDataName)) continue;
            NBTTagCompound moduleTag = ((ArmorTank)iFluidHandler).getModuleTag();
            if (moduleTag != null) {
                ((ArmorTank)iFluidHandler).writeToModuleTag(moduleTag);
            }
            nbtOut.func_74782_a(((ArmorTank)iFluidHandler).moduleDataName, (NBTBase)moduleTag);
        }
        return nbtOut;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (ArmorTank armorTank : this.allHandlers) {
            if (!nbt.func_150297_b(armorTank.moduleDataName, 10)) continue;
            armorTank = (ArmorTank)armorTank.readFromModuleTag(nbt.func_74775_l(armorTank.moduleDataName));
            this.addHandler(armorTank);
        }
    }

    public class AdvancedCoolingTank
    extends ArmorTank {
        public AdvancedCoolingTank() {
            super("advancedCoolingSystem");
        }
    }

    public class BasicCoolingTank
    extends ArmorTank {
        public BasicCoolingTank() {
            super("basicCoolingSystem");
        }
    }

    public class ArmorTank
    extends FluidTank
    implements IArmorTank {
        String moduleDataName;

        public ArmorTank(String moduleDataName) {
            super(10000);
            this.moduleDataName = moduleDataName;
        }

        public boolean canDrainFluidType(@Nullable FluidStack fluid) {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            if (fluid != null) {
                if (fluid.getFluid() == FluidRegistry.WATER && this.moduleDataName == "basicCoolingSystem") {
                    return true;
                }
                if (fluid.getFluid() != FluidRegistry.WATER && this.moduleDataName == "advancedCoolingSystem") {
                    return true;
                }
            }
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER && this.moduleDataName == "basicCoolingSystem";
        }

        @Override
        @Nullable
        public NBTTagCompound getModuleTag() {
            NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag((ItemStack)MPSChestPlateFluidHandler.this.container);
            return (NBTTagCompound)nbt.func_74781_a(this.moduleDataName);
        }

        public NBTTagCompound writeToModuleTag(NBTTagCompound nbt) {
            NBTTagCompound fluidTag = this.writeToNBT(new NBTTagCompound());
            nbt.func_74782_a("fluid", (NBTBase)fluidTag);
            return nbt;
        }

        public FluidTank readFromItemTag(NBTTagCompound nbt) {
            NBTTagCompound nbtModuleTag = nbt.func_74775_l(this.moduleDataName);
            if (nbtModuleTag != null) {
                return this.readFromModuleTag(nbtModuleTag);
            }
            return this;
        }

        public FluidTank readFromModuleTag(NBTTagCompound nbt) {
            NBTTagCompound fluidTag = nbt.func_74775_l("fluid");
            if (fluidTag != null) {
                return this.readFromNBT(fluidTag);
            }
            return this;
        }

        protected void onContentsChanged() {
            NBTTagCompound itemNBT = MuseNBTUtils.getMuseItemTag((ItemStack)MPSChestPlateFluidHandler.this.container);
            NBTTagCompound moduleTag = itemNBT.func_74775_l(this.moduleDataName);
            if (moduleTag != null) {
                moduleTag = this.writeToModuleTag(moduleTag);
                NBTTagCompound nbtOut = new NBTTagCompound();
                nbtOut.func_74782_a(this.moduleDataName, (NBTBase)moduleTag);
                itemNBT.func_74782_a(this.moduleDataName, (NBTBase)moduleTag);
                MPSChestPlateFluidHandler.this.deserializeNBT(nbtOut);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArmorTank armorTank = (ArmorTank)o;
            return Objects.equals(this.moduleDataName, armorTank.moduleDataName);
        }

        public int hashCode() {
            return Objects.hash(this.moduleDataName);
        }
    }

    static interface IArmorTank {
        @Nullable
        public NBTTagCompound getModuleTag();
    }
}

