/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.model.helper;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.machinemuse.numina.client.model.helper.MuseModelHelper;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.powersuits.client.event.ModelBakeEventHandler;
import net.machinemuse.powersuits.common.constants.MPSResourceConstants;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ModelPowerFistHelper {
    INSTANCE;

    public static final ResourceLocation powerFistLocation;
    public static final ResourceLocation powerFistFingersNormalLocation;
    public static final ResourceLocation powerFistFingersFiringLocation;
    public static final ResourceLocation powerFistLeftLocation;
    public static final ResourceLocation powerFistFingersLeftNormalLocation;
    public static final ResourceLocation powerFistFingersLeftFiringLocation;
    public static final IModelState powerfistState;
    public static IBakedModel powerFist;
    public static IBakedModel powerFistFingers;
    public static IBakedModel powerFistFingersFiring;
    public static IBakedModel powerFistLeft;
    public static IBakedModel powerFistFingersLeft;
    public static IBakedModel powerFistFingersLeftFiring;
    public static LoadingCache<PowerFistQuadMapKey, List<BakedQuad>> colouredPowerFistQuadMap;

    public static void loadPowerFistModels(@Nullable TextureMap map) {
        if (map == null) {
            powerFist = MuseModelHelper.loadBakedModel((ResourceLocation)powerFistLocation);
            powerFistFingers = MuseModelHelper.loadBakedModel((ResourceLocation)powerFistFingersNormalLocation);
            powerFistFingersFiring = MuseModelHelper.loadBakedModel((ResourceLocation)powerFistFingersFiringLocation);
            powerFistLeft = MuseModelHelper.loadBakedModel((ResourceLocation)powerFistLeftLocation);
            powerFistFingersLeft = MuseModelHelper.loadBakedModel((ResourceLocation)powerFistFingersLeftNormalLocation);
            powerFistFingersLeftFiring = MuseModelHelper.loadBakedModel((ResourceLocation)powerFistFingersLeftFiringLocation);
        }
    }

    static IModelState getPowerfistState() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)MuseModelHelper.get((float)8.0f, (float)8.01f, (float)9.0f, (float)-15.0f, (float)180.0f, (float)0.0f, (float)0.63f, (float)0.63f, (float)0.63f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)MuseModelHelper.get((float)13.2f, (float)8.01f, (float)9.0f, (float)-15.0f, (float)180.0f, (float)0.0f, (float)0.63f, (float)0.63f, (float)0.63f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)MuseModelHelper.get((float)11.8f, (float)8.0f, (float)7.0f, (float)-16.0f, (float)-162.0f, (float)0.0f, (float)0.5f, (float)0.5f, (float)0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)MuseModelHelper.get((float)14.8f, (float)8.0f, (float)7.0f, (float)344.0f, (float)198.0f, (float)0.0f, (float)0.5f, (float)0.5f, (float)0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)MuseModelHelper.get((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.63f));
        return new SimpleModelState(builder.build());
    }

    static {
        powerFistLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist.obj");
        powerFistFingersNormalLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_normal.obj");
        powerFistFingersFiringLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_firing.obj");
        powerFistLeftLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerFist/powerfist_left.obj");
        powerFistFingersLeftNormalLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_normal_left.obj");
        powerFistFingersLeftFiringLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_firing_left.obj");
        powerfistState = ModelPowerFistHelper.getPowerfistState();
        colouredPowerFistQuadMap = CacheBuilder.newBuilder().maximumSize(40L).build((CacheLoader)new CacheLoader<PowerFistQuadMapKey, List<BakedQuad>>(){

            public List<BakedQuad> load(PowerFistQuadMapKey key) throws Exception {
                ImmutableList.Builder builder = ImmutableList.builder();
                switch (key.transformType) {
                    case THIRD_PERSON_LEFT_HAND: 
                    case FIRST_PERSON_LEFT_HAND: {
                        powerFistLeft.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad((Colour)key.getColour(), (BakedQuad)quad, (boolean)quad.shouldApplyDiffuseLighting())));
                        if (key.isFiring()) {
                            powerFistFingersLeftFiring.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad((Colour)key.getColour(), (BakedQuad)quad, (boolean)quad.shouldApplyDiffuseLighting())));
                        } else {
                            powerFistFingersLeft.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad((Colour)key.getColour(), (BakedQuad)quad, (boolean)quad.shouldApplyDiffuseLighting())));
                        }
                        return builder.build();
                    }
                    case THIRD_PERSON_RIGHT_HAND: 
                    case FIRST_PERSON_RIGHT_HAND: 
                    case GROUND: {
                        powerFist.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad((Colour)key.getColour(), (BakedQuad)quad, (boolean)quad.shouldApplyDiffuseLighting())));
                        if (key.isFiring()) {
                            powerFistFingersFiring.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad((Colour)key.getColour(), (BakedQuad)quad, (boolean)quad.shouldApplyDiffuseLighting())));
                        } else {
                            powerFistFingers.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad((Colour)key.getColour(), (BakedQuad)quad, (boolean)quad.shouldApplyDiffuseLighting())));
                        }
                        return builder.build();
                    }
                }
                return MuseModelHelper.getColoredQuads((List)ModelBakeEventHandler.powerFistIconModel.func_188616_a(null, null, 0L), (Colour)key.getColour());
            }
        });
    }

    public static class PowerFistQuadMapKey {
        private final Colour colour;
        private final ItemCameraTransforms.TransformType transformType;
        private final boolean firing;

        public PowerFistQuadMapKey(Colour colour, ItemCameraTransforms.TransformType transformType, boolean firing) {
            this.colour = colour;
            this.transformType = transformType;
            this.firing = firing;
        }

        public Colour getColour() {
            return this.colour;
        }

        public ItemCameraTransforms.TransformType getTransformType() {
            return this.transformType;
        }

        public boolean isFiring() {
            return this.firing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PowerFistQuadMapKey that = (PowerFistQuadMapKey)o;
            return this.firing == that.firing && Objects.equal((Object)this.getColour(), (Object)that.getColour()) && this.getTransformType() == that.getTransformType();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getColour(), this.getTransformType(), this.firing});
        }
    }
}

